/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.alarm;

import com.parablu.epa.common.service.backup.StatisticsCollectorJob;
import com.parablu.epa.common.service.settings.SettingHelper;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatisticsCollectorHelper {
    private static Logger logger = LoggerFactory.getLogger(StatisticsCollectorHelper.class);
    private static Timer statisticsRefreshTimer = null;
    private static long timeInMillisecondsConvertionFactorFromMinutes = 60000L;
    private static StatisticsCollectorJob collectorJob = null;

    private StatisticsCollectorHelper() {
    }

    public static synchronized void startStatisticsCollector() {
        if (collectorJob != null && collectorJob.isAlive() || !SettingHelper.isLicenseActive() || SettingHelper.isDeviceBlocked()) {
            logger.debug("Collector Job is not null and is alive");
            return;
        }
        if (SettingHelper.getIsStatisticsEnabled() == null || !"true".equalsIgnoreCase(SettingHelper.getIsStatisticsEnabled())) {
            logger.debug("isStatisticsEnabled: " + SettingHelper.getIsStatisticsEnabled());
            return;
        }
        collectorJob = new StatisticsCollectorJob();
        collectorJob.setDaemon(true);
        collectorJob.start();
        Runnable runnable = () -> {
            try {
                collectorJob.join();
                if (StatisticsCollectorHelper.collectorJob.jobsucceeded) {
                    return;
                }
            }
            catch (IllegalThreadStateException | InterruptedException e) {
                logger.error("IllegalThreadStateException", (Throwable)e);
            }
        };
        new Thread(runnable).start();
    }

    public static synchronized void initiateStatisticsTimer() {
        statisticsRefreshTimer = new Timer();
        statisticsRefreshTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                StatisticsCollectorHelper.startStatisticsCollector();
            }
        }, 5000L, 60L * timeInMillisecondsConvertionFactorFromMinutes);
    }

    public static synchronized void initiateStatisticsTimerAfterDelay() {
        statisticsRefreshTimer = new Timer();
        statisticsRefreshTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                StatisticsCollectorHelper.startStatisticsCollector();
            }
        }, (long)SettingHelper.getStatisticsRefreshIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes, (long)SettingHelper.getStatisticsRefreshIntervalInMins() * timeInMillisecondsConvertionFactorFromMinutes);
    }

    public static synchronized void resetStatisticsTimer() {
        if (statisticsRefreshTimer != null) {
            statisticsRefreshTimer.cancel();
        }
        StatisticsCollectorHelper.initiateStatisticsTimerAfterDelay();
    }

    public static void cancelStatisticsTimer() {
        statisticsRefreshTimer.cancel();
    }
}

