/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.parablu.epa.common.dao.BackUpImageDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.BluVaultIPHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.element.GroupPolicyElement;
import com.parablu.epa.core.element.GroupPolicyElementList;
import com.parablu.epa.core.element.ProxyElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BluVaultTO;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckBackupPolicy {
    private static String cloudName = SettingHelper.getCloudName();
    private static String keyStorePath = SettingHelper.getKeystorePath();
    public static BackupAdapter backUpAdapter = new BackupAdapter(cloudName, keyStorePath);
    private static BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
    private static Logger logger = LoggerFactory.getLogger(CheckBackupPolicy.class);
    static int policyRefreshIntervalInHrs = -1;
    static int statisticsRefreshIntervalInHrs = -1;

    private CheckBackupPolicy() {
    }

    public static void checkGroupPolicy() {
        if (NotificationHelper.policyRefreshStarted) {
            logger.debug("policy refresh finished:" + NotificationHelper.policyRefreshStarted);
            return;
        }
        NotificationHelper.policyRefreshStarted = true;
        BackupPolicyTO currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        if (currentPolicy != null) {
            BackupPolicyTO backupPolicyTo = new BackupPolicyTO();
            GroupPolicyElementList groupPolicyElementList = null;
            try {
                logger.debug("Getting GROUP POLICY ELEMENT#######################");
                groupPolicyElementList = backUpAdapter.getGroupPolicyElement(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceName(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
                if (groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
                    groupPolicyElementList = CheckBackupPolicy.retryUsingUpdatedIp();
                }
            }
            catch (CrawlAdapterException protocolException) {
                logger.error("Client protocol exception...." + protocolException);
                groupPolicyElementList = CheckBackupPolicy.retryUsingUpdatedIp();
            }
            catch (Exception e) {
                logger.error("Error in get latest policy:" + e);
            }
            if (groupPolicyElementList != null && !groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
                try {
                    for (GroupPolicyElement groupPolicyElement : groupPolicyElementList.getGroupPolicyElement()) {
                        if (groupPolicyElement.getStatus() == 416) {
                            SettingHelper.setLicenseActive(false);
                            continue;
                        }
                        SettingHelper.setLicenseActive(true);
                        PolicyManagementServerHelper.createGroupPolicyAndChildDetails(backupPolicyDAOImpl, backupPolicyTo, groupPolicyElementList);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Error in create group  policy:" + e);
                }
            }
            CheckBackupPolicy.checkPolicyNameAndDeleteBackupDb();
        } else {
            logger.debug("Due to some connection error previous policy may null so get latest policy");
            PolicyManagementServerHelper.loadBackupPolicyElement(SettingHelper.getDeviceName());
            CheckBackupPolicy.checkPolicyNameAndDeleteBackupDb();
        }
        NotificationHelper.policyRefreshStarted = false;
    }

    public static void loadBackupPolicyElement(String deviceName) {
        GroupPolicyElementList groupPolicyElementList = null;
        BackupPolicyTO backupPolicyTo = new BackupPolicyTO();
        try {
            logger.debug("Getting GROUP POLICY ELEMENT#######################");
            groupPolicyElementList = backUpAdapter.getGroupPolicyElement(SettingHelper.getCurrentCloudIpAddress(), deviceName, SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
            if (groupPolicyElementList.getGroupPolicyElement() == null) {
                groupPolicyElementList = CheckBackupPolicy.retryUsingUpdatedIp();
            }
        }
        catch (CrawlAdapterException protocolException) {
            logger.error("Client protocol exception." + protocolException);
            groupPolicyElementList = CheckBackupPolicy.retryUsingUpdatedIp();
        }
        catch (Exception e) {
            logger.debug("Exception in load backup policy so retrying it" + e);
            groupPolicyElementList = CheckBackupPolicy.retryUsingUpdatedIp();
        }
        if (!groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
            try {
                PolicyManagementServerHelper.createGroupPolicyAndChildDetails(backupPolicyDAOImpl, backupPolicyTo, groupPolicyElementList);
            }
            catch (Exception e) {
                logger.error("Error in adding policy details....." + e);
            }
        }
    }

    private static GroupPolicyElementList retryUsingUpdatedIp() {
        boolean retry = false;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        String currentIP = SettingHelper.getPublicIpAddress();
        BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
        List<BluVaultTO> ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
        do {
            logger.debug("Retrying to get policy information.");
            ebmsList = CheckBackupPolicy.removeCurrentIp(ebmsList, currentIP);
            logger.debug("ebms list size after removing the current ip:" + ebmsList.size());
            if (ebmsList.isEmpty()) {
                logger.debug("inside ebms list empty cycle finished so sleep and reset");
                sleepTime = ParabluFileSystemUtils.sleepForGivenTime((long)sleepTime);
                ++retryCount;
                ebmsList = bluVaultIPHelper.getEbmsList(backupPolicyDAOImpl);
            }
            if (!ebmsList.isEmpty()) {
                currentIP = ebmsList.get(0).getBluVaultName();
            }
            logger.debug("The current IP to get policy is:" + currentIP);
            GroupPolicyElementList groupPolicyElementList = null;
            try {
                backUpAdapter.resetClientConnection(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                logger.debug("Getting GROUP POLICY ELEMENT#######################");
                groupPolicyElementList = backUpAdapter.getGroupPolicyElement(currentIP, SettingHelper.getDeviceName(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
            }
            catch (CrawlAdapterException protocolException) {
                logger.error("client protocol exception...." + protocolException);
            }
            catch (Exception e) {
                logger.error("Error in retrying  to get policy:" + e);
            }
            if (groupPolicyElementList != null && !groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
                for (GroupPolicyElement groupPolicyElement : groupPolicyElementList.getGroupPolicyElement()) {
                    if (groupPolicyElement.getStatus() == 416) {
                        SettingHelper.setLicenseActive(false);
                        retry = false;
                        continue;
                    }
                    SettingHelper.setCurrentCloudIpAddress(currentIP);
                    ProxyElement.setIp((String)currentIP);
                    SettingHelper.applyChangesToSharedPreferences(false);
                    SettingHelper.setLicenseActive(true);
                    return groupPolicyElementList;
                }
            } else {
                retry = true;
            }
        } while (retry && retryCount < 4);
        return null;
    }

    private static List<BluVaultTO> removeCurrentIp(List<BluVaultTO> ebmsList, String currentIP) {
        List<BluVaultTO> ebmsList1 = ebmsList.stream().filter(p -> !p.getBluVaultName().equalsIgnoreCase(currentIP)).collect(Collectors.toList());
        logger.debug("After removing the ip size:" + ebmsList1.size() + "  current Ip:" + currentIP);
        return ebmsList1;
    }

    private static void checkPolicyNameAndDeleteBackupDb() {
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
            BackupPolicyTO currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
            String policyName = "";
            if (currentPolicy != null) {
                policyName = currentPolicy.getPolicyGroupName();
            }
            logger.debug("Policy Name: " + policyName);
            if (!StringUtils.isEmpty((String)policyName) && policyName.contentEquals("RESTART")) {
                BackUpImageDAOImpl backUpImageDAOImpl = new BackUpImageDAOImpl(SettingHelper.getBackUpDbUrl());
                backUpImageDAOImpl.deleteEntireTable();
            }
        }
    }
}

