/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.microsoft.graph.http.GraphServiceException;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.EncryptionKeyDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EncryptionKey;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.MailAttachment;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.PrivacyGatewayMapping;
import com.parablu.pcbd.domain.RestoreBackUpImage;
import com.parablu.pcbd.domain.RestoredFiles;
import com.parablu.pcbd.domain.User;
import com.parablu.query.util.BackupFileQueryElement;
import com.pg.dao.BackupFileDao;
import com.pg.dao.FileDao;
import com.pg.dao.OneDriveDao;
import com.pg.dao.SyncFileDao;
import com.pg.domain.FileInfo;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.element.RestoreElement;
import com.pg.encryption.service.FileEncryptionService;
import com.pg.exception.BlukryptClientAbortException;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.odb.util.OneDriveUtil;
import com.pg.paracloud.to.DownloadFileTO;
import com.pg.paracloud.to.DownloadTO;
import com.pg.service.CloudSupportService;
import com.pg.service.DownloadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncDownloadService;
import com.pg.util.ResourceFileHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.zeroturnaround.zip.ZipUtil;

@Service
public class DownloadServiceImpl
implements DownloadService {
    private static Logger logger = LoggerFactory.getLogger(DownloadServiceImpl.class);
    private static final int BUFFER_CHUNK_SIZE = 1024;
    @Autowired
    private BackupFileDao backupFileDao;
    private static final String ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH = "ERROR Trying to download from orginal source path ..... ";
    private static final String MERGE = "merge";
    private static final String LOOP_BEFORE_DOWNLOAD_FILE = "for loop  BEFORE DOWNLOADING Chunks file  >>>>>> ";
    private static final String DECRYPTED = "decrypted";
    private static final String WRITTING_OUTSIDE_TO_STREAM_AND_DOWNLOAD_COUNT = "@#@#@#@##### Writing outside to stream ....download count>>";
    private static final String PARABLU_OF = "----PARABLUEOF";
    private static final String CONTENT_DISPOSITION_FORM_DATA = "Content-Disposition: form-data;";
    private static final String CHUNK = "chunk";
    private static final String FILE_NAME = "fileName:";
    private static final String FILE_PATH = "filePath:";
    private static final String CLIENT_MODIFIED_TIME = "clientModifiedTime:";
    private static final String CLIENT_ACCESS_TIME = "accessTime:";
    private static final String MD5_CHECKSUM = "md5Checksum:";
    private static final String FILE_MD5 = " File md5 .......... ";
    private static final String COUNT = "count:";
    private static final String SKIP_VALUE = "skipValue:";
    private static final String ERROR_TRYING_TO_WRITE_DATA = "Error trying to write data .....%%%%%%%%% ";
    private static final String FILE_PATH_STR = "file path>>>";
    private static final String FILE_NAME_STR = "file name>>>";
    private static final String SOCKET_EXCEPTION = "SocketException";
    private static final String CLIENT_ABORT_EXCEPTION = "ClientAbortException";
    private static final String THROW_CLIENT_ABORT_EXCEPTION = " throw client abort exception .......";
    private static final String CLIENT_ABORTED = "Client Aborted";
    private static final String BACKUP = "backup";
    private static final String AZURE_DOWNLOAD_ERROR = "Azure download error";
    private static final String AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY = "Azure download error while get decrypt key";
    private static final String PARAMETERS = "parameters";
    private static final String PREFIX_HTTPS = "https://";
    private static final String NO_MERGE = "!!!!NO MERGE..................";
    private static final String ERROR_WHILE_TRYING_TO_WRITE_DATA = "Error trying to write data ..... ";
    private static final String SENDING_FILE = "Sending file ";
    private static final String IS_COMPRESSED = "$$$$$ isCompressed>>>>";
    private static final String BACKUP_FILE_IS_COMPRESSED = "Backup File is compressed>> ";
    private static final String FINISHED_FILE = "Finished file ";
    private static final String EXCEPTION_WHILE_RESTORE_FROM_CLOUD = "Exception While Restoring Files From Cloud :";
    private static final String EXCEPTION_WHILE_WRITTING_DATA_TO_STREAM = "Exception While Writting Data to Stream :";
    private static final String EXCEPTION_WHILE_GETTING_DECRYPTED_FILE = "Exception While Getting Decrypted File :";
    private static final String EXCEPTION_WHILE_BRUTE_FORCE_RESTORE_FROM_CLOUD = "Exception While Brute Force Restore From Cloud :";
    private static final String EXCEPTION_WHILE_SEARCHING_FOR_REPLICA_AND_RESTORE = "Exception While Searching for Replica and Restore :";
    private static final String COMPRESSION_ENABLED = "isCompressed:";
    private static final String CHUNK_DETAILS_NULL = "Chunk detail is null>>>>>>>>";
    private static final String CLOUD_CHUNK_NAME = "CLOUD CHUNK NAME>>>>>>>>>";
    private static final String VERSION = "(Version-";
    private static final String BACKUP_ID = "backupId";
    private static final String CLOUD_NAME = "cloudName";
    private static final String FILE_INFO_RECEIVED = " fileinfo recieved ....... ";
    private static final String FILE_META_INFO_RECEIVED = " file meta info recieved .... ";
    private static final String FILE_FROM_PG = " file from pg..................";
    private static final String FILEPATH = "filePath";
    private static final String BLUKRYPT_BUILDER_DOWNLOAD_FROM_PG = "/BluKryptBuilder/download/frompg/";
    private static final String FILE_NOT_FOUND = " @@@@@ FILE NOT FOUND .... ";
    private static final String COPY = "-copy";
    private static final String SYNC_DECRYPT_KEY = "d8e87c0927539672f54462c837be0b7f";
    private static final String UTF8 = "UTF-8";
    private static final String BATCH_ID_LOG = "##batch id >>>>";
    @Autowired
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    @Autowired
    private EncryptionKeyDao encryptionKeyDao;
    @Autowired
    private BackUpImageDao backUpImageDao;
    @Autowired
    private PciAuthorizationTokensDao pciAuthorizationTokensDao;
    @Autowired
    private FileDao fileDao;
    @Autowired
    private OneDriveDao oneDriveDao;
    @Autowired
    private FileEncryptionService fileEncryptionService;
    @Autowired
    private UtilService utilService;
    @Autowired
    private CloudSupportService cloudSupportService;
    @Autowired
    private SyncDownloadService syncDownloadService;
    @Autowired
    private SyncFileDao syncFileDao;

    public void setSyncFileDao(SyncFileDao syncFileDao) {
        this.syncFileDao = syncFileDao;
    }

    public void setSyncDownloadService(SyncDownloadService syncDownloadService) {
        this.syncDownloadService = syncDownloadService;
    }

    public void setBackupFileDao(BackupFileDao backupFileDao) {
        this.backupFileDao = backupFileDao;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public void setEncryptionKeyDao(EncryptionKeyDao encryptionKeyDao) {
        this.encryptionKeyDao = encryptionKeyDao;
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setOneDriveDao(OneDriveDao oneDriveDao) {
        this.oneDriveDao = oneDriveDao;
    }

    public void setFileEncryptionService(FileEncryptionService fileEncryptionService) {
        this.fileEncryptionService = fileEncryptionService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setCloudSupportService(CloudSupportService cloudSupportService) {
        this.cloudSupportService = cloudSupportService;
    }

    @Override
    public DownloadTO restoreFileForExternalStorage(PciAuthorizationTokenElement authorizationTokenElement, String fileName, String folderPath, String saltKey, String deviceUUID, String backupId, String gatewayName, boolean isExternalDownload) {
        com.pg.domain.BackupFile dedupifiedFile;
        String mimeType = null;
        long fileSize = 0L;
        logger.debug(" @@@@@ Folder path for external Storage " + folderPath);
        String cloudName = authorizationTokenElement.getCloudName();
        String userName = authorizationTokenElement.getUserName();
        com.pg.domain.BackupFile backupFile = this.fileDao.getBackupFile(userName, cloudName, backupId, gatewayName);
        if (backupFile == null) {
            logger.debug(FILE_NOT_FOUND + backupId);
            throw new ParacloudBackupException(FILE_NOT_FOUND, 507);
        }
        if (!StringUtils.isEmpty((String)backupFile.getDedupBackupId()) && (dedupifiedFile = this.fileDao.getBackupFile(userName, cloudName, backupFile.getDedupBackupId(), gatewayName)) == null) {
            logger.debug(FILE_NOT_FOUND + backupId);
            throw new ParacloudBackupException(FILE_NOT_FOUND, 507);
        }
        ArrayList<String> nameList = new ArrayList<String>();
        logger.debug(" BEFORE DOWNLOADING Chunks  >>>>>> " + backupFile.getDeviceUUID());
        for (com.pg.domain.ChunkFile chunkFile : backupFile.getChunkFiles()) {
            BufferedInputStream inputStream;
            String accessToken = this.oneDriveDao.getOneDriveAccessToken(authorizationTokenElement);
            try {
                String url = "https://apis.live.net/v5.0/" + chunkFile.getFileId() + "/content?download=true&access_token=" + accessToken;
                logger.debug(" *****************NEW DOWNLOAD URL***************** " + url);
                inputStream = this.getInputStreamFromExternalStorage(url);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.debug(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                String url = chunkFile.getFileSource();
                logger.debug(url + "Retry to download ....." + e.getMessage());
                inputStream = this.getInputStreamFromExternalStorage(url);
            }
            this.getDecryptedFile(cloudName, saltKey, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream);
            nameList.add(chunkFile.getFileName());
        }
        logger.debug(" After DOWNLOADING Chunks  >>>>>> " + backupFile.getDeviceUUID());
        String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + backupFile.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        String destPath = path + MERGE;
        String destFile = destPath + "/" + backupFile.getFileName();
        File destFolder = new File(destPath);
        if (destFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)destFolder);
        }
        com.pg.util.FileUtils.merge(nameList, (String)(path + DECRYPTED), (String)destFile);
        BufferedInputStream decryptedStream = null;
        try {
            decryptedStream = new BufferedInputStream(new FileInputStream(new File(destFile)), 1024);
            logger.debug("************************DOWNLOADED*********************************" + destFile);
        }
        catch (FileNotFoundException e) {
            logger.trace("" + e);
            logger.error(e + " Unable to get decrypt file stream " + backupFile.getFileName(), (Object)e.getMessage());
        }
        if (isExternalDownload) {
            String downloadPath = PCHelperConstant.getPropertyFileValueDefaultExtDownloadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            File sourceFile = new File(destFile);
            File file = new File(downloadPath + fileName);
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileUtils.copyFile((File)sourceFile, (File)file);
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error("Error trying to copy files to download folder ..... " + e.getMessage());
            }
        }
        DownloadTO downloadTO = new DownloadTO(mimeType, (InputStream)decryptedStream, fileSize, backupFile.getMd5());
        downloadTO.setPath(destFile);
        return downloadTO;
    }

    private BufferedInputStream getInputStreamFromExternalStorage(String url) {
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new URL(url).openStream(), 1024);
        }
        catch (Exception ex) {
            logger.trace("" + ex);
            throw new ParacloudBackupException("Error trying to Open file " + ex.getMessage(), 507);
        }
        return inputStream;
    }

    private File getDecryptedFile(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStream) {
        String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File decryptedDir = new File(path + DECRYPTED);
        if (!decryptedDir.exists()) {
            decryptedDir.mkdir();
        }
        this.createFolders(path);
        File decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        decryptedFile = this.fileEncryptionService.decrypt(saltKey, deviceUUID, inputStream, decryptedFile);
        return decryptedFile;
    }

    private void createFolders(String pathname) {
        File decryptedDir = this.createDecryptedDirs(pathname);
        if (decryptedDir != null) {
            logger.debug("Directory created successfully");
        }
    }

    @Override
    public long countOfFilesToDownload(int cloudId, RestoreElement restoreElement, String userName) {
        String cloudName = restoreElement.getCloudName();
        String deviceUUID = restoreElement.getDeviceUUID();
        String devicePath = restoreElement.getDevicePath();
        String fileName = restoreElement.getFileName();
        if (!StringUtils.isEmpty((String)restoreElement.getBackupId())) {
            return 1L;
        }
        long totalCount = restoreElement.isDownloadAllVersions() ? this.backupFileDao.totalCountOfAllBackupFileVersions(cloudId, cloudName, deviceUUID, devicePath, fileName, userName) : this.backupFileDao.countOfBackupFileLatestRecords(cloudId, cloudName, deviceUUID, devicePath, fileName, userName);
        return totalCount;
    }

    @Override
    public long restoreFilesFromCloud(Cloud cloud, RestoreElement restoreElement, String pUserName, HttpServletResponse response, int skipValue, long totalCount, long downloadedCount, Map<String, Long> fileVersionMap, boolean isEncodedEnabled, String serverModifiedTime) {
        return 0L;
    }

    private String getDriveID(Cloud cloud, String driveId, String userName) {
        boolean useNewGraph;
        boolean bl = useNewGraph = cloud.getGraphApiEnabled() == 1;
        if (useNewGraph) {
            logger.debug("using new graph....");
            OneDriveUtil odbUtil = OneDriveUtil.getInstance();
            User user = this.utilService.getUserInfoByName(cloud.getCloudId(), userName);
            if (user == null) {
                logger.error("error in getting user to get drive id so return..");
                return "";
            }
            try {
                MSGTokens msgTokens = this.pciAuthorizationTokensDao.getMSGTokens(cloud.getCloudId());
                if (msgTokens != null) {
                    PciAuthorizationTokenElement tokenelement = this.getMSGTokenElement(msgTokens, user);
                    String emailId = user.getEmailId();
                    if (!StringUtils.isEmpty((String)user.getOdbLoginId())) {
                        emailId = user.getOdbLoginId();
                    }
                    if (!StringUtils.isEmpty((String)user.getDestOdbLoginId())) {
                        emailId = user.getDestOdbLoginId();
                    }
                    tokenelement.setAccountId(emailId.toLowerCase());
                    driveId = odbUtil.getPBFolderItemId(msgTokens.getAccessToken(), tokenelement.getAccountId());
                }
            }
            catch (GraphServiceException e) {
                logger.error("... error trying to get driveId ..." + e.getResponseCode());
                logger.debug("inside 401...");
                logger.error(" ... token expired so try after 1 min ... ");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException tokenelement) {
                    // empty catch block
                }
                try {
                    MSGTokens msgTokens = this.pciAuthorizationTokensDao.getMSGTokens(cloud.getCloudId());
                    if (msgTokens != null) {
                        PciAuthorizationTokenElement tokenelement = this.getMSGTokenElement(msgTokens, user);
                        String emailId = user.getEmailId();
                        if (!StringUtils.isEmpty((String)user.getOdbLoginId())) {
                            emailId = user.getOdbLoginId();
                        }
                        if (!StringUtils.isEmpty((String)user.getDestOdbLoginId())) {
                            emailId = user.getDestOdbLoginId();
                        }
                        tokenelement.setAccountId(emailId.toLowerCase());
                        driveId = odbUtil.getPBFolderItemId(msgTokens.getAccessToken(), tokenelement.getAccountId());
                    }
                }
                catch (GraphServiceException ee) {
                    logger.error("... unable to get driveid...");
                }
            }
        }
        logger.debug("after getting the drive id.....:" + driveId);
        return driveId;
    }

    private PciAuthorizationTokenElement getMSGTokenElement(MSGTokens msgTokens, User user) {
        PciAuthorizationTokenElement tokenElement = new PciAuthorizationTokenElement();
        if (msgTokens == null) {
            return tokenElement;
        }
        tokenElement.setAccessToken(msgTokens.getAccessToken());
        tokenElement.setClientId(msgTokens.getClientId());
        tokenElement.setClientSecret(msgTokens.getClientSecret());
        tokenElement.setRedirectUri(msgTokens.getRedirectUri());
        tokenElement.setRefreshToken(msgTokens.getRefreshToken());
        tokenElement.setAccountId(msgTokens.getAccountId());
        tokenElement.setSharePointUrl(msgTokens.getSharePointUrl());
        tokenElement.setCloudName(msgTokens.getCloudName());
        if (user != null) {
            if (StringUtils.isEmpty((String)user.getOdbLoginId())) {
                tokenElement.setAccountId(user.getEmailId());
            } else {
                tokenElement.setAccountId(user.getOdbLoginId());
            }
            tokenElement.setUserName(user.getUserName());
        }
        return tokenElement;
    }

    private String getDedupValue(String userName) {
        String dedupVal = null;
        User user = this.utilService.getUserInfoByName(1, userName);
        if (user != null) {
            OfficeBackupPolicy odbBackupPolicy;
            logger.debug("...user and policy...... " + userName + "......" + user.getPolicyName() + "......" + user.getOdbPolicyName());
            BackupPolicy backupPolicy = this.utilService.getBackupPolicy(1, user.getPolicyName());
            if (user.isBackupEnabled()) {
                if (backupPolicy != null) {
                    dedupVal = backupPolicy.getDedup();
                }
            } else if (user.isOnedriveBkpEnabled() && (odbBackupPolicy = this.utilService.getODBBackupPolicy(1, user.getOdbPolicyName())) != null) {
                dedupVal = odbBackupPolicy.getDedup();
            }
        }
        return dedupVal;
    }

    @Override
    public long restoreFilesFromCloudNew(Cloud cloud, RestoreElement restoreElement, String pUserName, HttpServletResponse response, int skipValue, long totalCount, long downloadedCount, Map<String, Long> fileVersionMap, String isImmediateFolderLevel, boolean isEncodedEnabled, String serverModifiedTime) {
        HttpHeaders headers;
        HttpComponentsClientHttpRequestFactory reqFactory;
        BufferedInputStream inputStream;
        String fileName;
        String backupId;
        int lastDot;
        boolean isGDEnabled;
        FileStatusElement fileStatusElement;
        Device device;
        ArrayList<FileInfo> clientDedupEnabledList;
        ArrayList<BackUpImage> pgBkpNoGatewayList;
        ArrayList<BackUpImage> pgBkpList;
        ArrayList<com.pg.domain.BackupFile> list;
        String restorePath;
        String path;
        String restoreId;
        String fileNameVal;
        String deviceUUID;
        String cloudName;
        int cloudId;
        Map<String, Long> fileVersionMapTemp;
        long downloadedCountTemp;
        String userName;
        block190: {
            BackupFileQueryElement backupFileQueryElement;
            block187: {
                block188: {
                    com.pg.domain.BackupFile backupFile;
                    block189: {
                        userName = pUserName;
                        downloadedCountTemp = downloadedCount;
                        fileVersionMapTemp = fileVersionMap;
                        cloudId = cloud.getCloudId();
                        cloudName = restoreElement.getCloudName();
                        deviceUUID = restoreElement.getDeviceUUID();
                        String devicePath = restoreElement.getDevicePath();
                        fileNameVal = restoreElement.getFileName();
                        restoreId = restoreElement.getRestoreBatchId();
                        backupFileQueryElement = new BackupFileQueryElement();
                        backupFileQueryElement.setCloudId(cloudId);
                        backupFileQueryElement.setCloudName(cloudName);
                        backupFileQueryElement.setUserName(userName);
                        backupFileQueryElement.setDevicePath(devicePath);
                        backupFileQueryElement.setFileName(fileNameVal);
                        backupFileQueryElement.setDeviceUUID(deviceUUID);
                        backupFileQueryElement.setSkipValue(skipValue);
                        backupFileQueryElement.setFileVersionMap(fileVersionMapTemp);
                        path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
                        restorePath = path + restoreId + "/";
                        File restorePathDir = new File(restorePath);
                        if (!restorePathDir.exists()) {
                            restorePathDir.mkdirs();
                        }
                        list = new ArrayList<com.pg.domain.BackupFile>();
                        pgBkpList = new ArrayList<BackUpImage>();
                        pgBkpNoGatewayList = new ArrayList<BackUpImage>();
                        clientDedupEnabledList = new ArrayList<FileInfo>();
                        device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
                        String driveId = "";
                        fileStatusElement = new FileStatusElement();
                        isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                        if (StringUtils.isEmpty((String)restoreElement.getBackupId())) break block187;
                        logger.debug(BATCH_ID_LOG + restoreId + " Only backup Id check ............. " + restoreElement.getBackupId());
                        backupFile = this.backupFileDao.getBackupFilesForId(cloudId, cloudName, userName, device, restoreElement.getBackupId());
                        if (backupFile == null || CollectionUtils.isEmpty((Collection)backupFile.getChunkFiles())) break block188;
                        if (StringUtils.isEmpty((String)serverModifiedTime) || Long.parseLong(serverModifiedTime) == 0L) break block189;
                        logger.debug("#####################....." + Long.parseLong(serverModifiedTime));
                        long modifiedTime = Long.parseLong(serverModifiedTime);
                        List backUpImagesList = this.backUpImageDao.getVersions(cloudId, cloudName, backupFileQueryElement.getFileName(), backupFileQueryElement.getDevicePath(), device);
                        BackUpImage backUpImage = backUpImagesList.stream().filter(file -> !file.getStatus().equalsIgnoreCase(PCHelperConstant.REVISION_STATUS.DELETED.toString()) && file.getLastServerModifiedTime() <= modifiedTime).findFirst().orElse(null);
                        if (backUpImage == null) break block190;
                        logger.debug("...filteredImage....." + backUpImage.getId());
                        backupFile = this.backupFileDao.getBackupFilesForId(cloudId, cloudName, userName, device, backUpImage.getId().toString());
                        if (backupFile == null) break block190;
                        list.add(backupFile);
                        break block190;
                    }
                    list.add(backupFile);
                    break block190;
                }
                BackUpImage bkpImage = this.backUpImageDao.getBackupFileForID(cloudId, new ObjectId(restoreElement.getBackupId()), userName, device);
                if (!StringUtils.isEmpty((String)serverModifiedTime) && Long.parseLong(serverModifiedTime) != 0L) {
                    long modifiedTime = Long.parseLong(serverModifiedTime);
                    List list2 = this.backUpImageDao.getVersions(cloudId, cloudName, backupFileQueryElement.getFileName(), backupFileQueryElement.getDevicePath(), device);
                    bkpImage = list2.stream().filter(file -> !file.getStatus().equalsIgnoreCase(PCHelperConstant.REVISION_STATUS.DELETED.toString()) && file.getLastServerModifiedTime() <= modifiedTime).findFirst().orElse(null);
                }
                if (bkpImage != null && !StringUtils.isEmpty((String)bkpImage.getGatewayName())) {
                    pgBkpList.add(bkpImage);
                }
                if (bkpImage != null && StringUtils.isEmpty((String)bkpImage.getGatewayName()) && StringUtils.isEmpty((String)bkpImage.getStoragePlace())) {
                    pgBkpNoGatewayList.add(bkpImage);
                }
                if (bkpImage == null || !StringUtils.isEmpty((String)bkpImage.getGatewayName())) break block190;
                logger.debug("inside no pg and no chunk files list$$$$$$$$$$$$ ");
                this.createBackupFile(list, bkpImage);
                break block190;
            }
            if (restoreElement.isDownloadAllVersions()) {
                logger.debug(BATCH_ID_LOG + restoreId + " all-versions backup file........");
                backupFileQueryElement.setDownloadAllVersions(restoreElement.isDownloadAllVersions());
                List bkpImagelist = this.backupFileDao.getBackupFilesForGivenPathfromBackupImage(isImmediateFolderLevel, backupFileQueryElement, device, false, serverModifiedTime);
                if (bkpImagelist == null) {
                    logger.debug(BATCH_ID_LOG + restoreId + " bkpimaged is null>>>>>>>>>>>so return");
                    response.setStatus(500);
                    return -1L;
                }
                for (BackUpImage backUpImage : bkpImagelist) {
                    List oldFiles;
                    if (backUpImage != null && StringUtils.isEmpty((String)backUpImage.getGatewayName()) && StringUtils.isEmpty((String)backUpImage.getStoragePlace())) {
                        pgBkpNoGatewayList.add(backUpImage);
                    }
                    if (StringUtils.isEmpty((String)backUpImage.getStoragePlace()) && !StringUtils.isEmpty((String)backUpImage.getGatewayName())) {
                        pgBkpList.add(backUpImage);
                        continue;
                    }
                    ArrayList<ObjectId> backupIds = new ArrayList<ObjectId>();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
                        logger.debug("Chunk is empty so get chunk from MD5");
                        BackUpImage parentBkpImage = this.backupFileDao.getParentBackupImageForMd5(cloudId, backUpImage.getMd5Checksum(), device);
                        if (parentBkpImage != null && !CollectionUtils.isEmpty((Collection)parentBkpImage.getChunkFiles())) {
                            backUpImage.setChunkFiles(parentBkpImage.getChunkFiles());
                            this.backUpImageDao.saveImageToBackUp(cloudId, backUpImage, device);
                        }
                    }
                    com.pg.domain.BackupFile backupFile = this.convertBkpImageToBackupFile(backUpImage);
                    if (backUpImage != null && !CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
                        backupFile.setMd5(backUpImage.getMd5Checksum());
                        list.add(backupFile);
                    } else {
                        backupIds.add(backUpImage.getId());
                        hashMap.put(backUpImage.getId().toString(), backUpImage.getMd5Checksum());
                    }
                    if (CollectionUtils.isEmpty((Collection)(oldFiles = this.backupFileDao.getBackupFilesForBackupImageId(cloudName, userName, deviceUUID, cloudId, fileVersionMapTemp, backupIds, hashMap)))) continue;
                    list.addAll(oldFiles);
                }
                logger.debug(BATCH_ID_LOG + restoreId + " end-all-versions backup file........");
            } else {
                logger.debug(BATCH_ID_LOG + restoreId + " Only latest versions ........");
                List bkpImagesdb = this.backupFileDao.getBackupFilesForGivenPathfromBackupImage(isImmediateFolderLevel, backupFileQueryElement, device, true, serverModifiedTime);
                ArrayList<BackUpImage> bkpImages = new ArrayList<BackUpImage>();
                logger.debug("....restoreId...." + restoreId);
                if (!StringUtils.isEmpty((String)backupFileQueryElement.getDevicePath())) {
                    this.backupFileDao.deleteRestoredFilesBySkipValue(cloudId, backupFileQueryElement.getUserName(), backupFileQueryElement.getDevicePath(), (long)backupFileQueryElement.getSkipValue(), restoreId);
                }
                for (BackUpImage backUpImage : bkpImagesdb) {
                    RestoredFiles restoredFiles = this.backupFileDao.getRestoredFiles(cloudId, backUpImage.getUserName(), backUpImage.getDevicePath(), backUpImage.getFileName(), restoreId);
                    if (restoredFiles == null) {
                        logger.debug("...$$$$...Adding restored files is empty for backUpImage.getUserName().." + backUpImage.getUserName() + "..backUpImage.getDevicePath().." + backUpImage.getDevicePath() + "...backUpImage.getFileName().." + backUpImage.getFileName());
                        RestoredFiles restoredFiles2 = new RestoredFiles();
                        restoredFiles2.setDevicePath(backUpImage.getDevicePath());
                        restoredFiles2.setFileName(backUpImage.getFileName());
                        restoredFiles2.setUserName(backUpImage.getUserName());
                        restoredFiles2.setSkipValue((long)backupFileQueryElement.getSkipValue());
                        this.backupFileDao.saveRestoredFiles(cloudId, restoredFiles2, restoreId);
                        bkpImages.add(backUpImage);
                        continue;
                    }
                    logger.debug("...$$$$...already restored files is exists for backUpImage.getUserName().." + backUpImage.getUserName() + "..backUpImage.getDevicePath().." + backUpImage.getDevicePath() + "...backUpImage.getFileName().." + backUpImage.getFileName());
                }
                if (CollectionUtils.isEmpty((Collection)bkpImagesdb)) {
                    logger.debug(BATCH_ID_LOG + restoreId + " bkpimaged is null>>>>>>>>>>>so return");
                    response.setStatus(500);
                    return -1L;
                }
                if (CollectionUtils.isEmpty(bkpImages)) {
                    logger.debug("backup images are empty increase the skip value...");
                    return downloadedCountTemp;
                }
                ArrayList<ObjectId> backupIds = new ArrayList<ObjectId>();
                HashMap<String, String> md5Map = new HashMap<String, String>();
                for (BackUpImage backUpImage : bkpImages) {
                    if (backUpImage != null && StringUtils.isEmpty((String)backUpImage.getGatewayName()) && StringUtils.isEmpty((String)backUpImage.getStoragePlace()) && CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
                        pgBkpNoGatewayList.add(backUpImage);
                    }
                    if (StringUtils.isEmpty((String)backUpImage.getStoragePlace()) && !StringUtils.isEmpty((String)backUpImage.getGatewayName())) {
                        if (backUpImage == null) continue;
                        pgBkpList.add(backUpImage);
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
                        BackUpImage parentFile = this.backupFileDao.getParentBackupImageForMd5(cloudId, backUpImage.getMd5Checksum(), device);
                        logger.debug("Chunk is empty so get chunk from MD5:" + backUpImage.getChunkFiles());
                        if (parentFile != null && !CollectionUtils.isEmpty((Collection)parentFile.getChunkFiles())) {
                            backUpImage.setChunkFiles(parentFile.getChunkFiles());
                            this.backUpImageDao.saveImageToBackUp(cloudId, backUpImage, device);
                        }
                    }
                    logger.debug(" convert to chunk ....");
                    com.pg.domain.BackupFile backupFile = this.convertBkpImageToBackupFile(backUpImage);
                    if (backUpImage != null && !CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
                        backupFile.setMd5(backUpImage.getMd5Checksum());
                        list.add(backupFile);
                        continue;
                    }
                    backupIds.add(backUpImage.getId());
                    md5Map.put(backUpImage.getId().toString(), backUpImage.getMd5Checksum());
                }
                List list3 = this.backupFileDao.getBackupFilesForBackupImageId(cloudName, userName, deviceUUID, cloudId, fileVersionMapTemp, backupIds, md5Map);
                ArrayList<ObjectId> leftoutBackupIds = new ArrayList<ObjectId>();
                if (!CollectionUtils.isEmpty((Collection)list3)) {
                    list.addAll(list3);
                }
                for (com.pg.domain.BackupFile backupFile : list3) {
                    leftoutBackupIds.add(backupFile.getBackupId());
                }
                backupIds.removeAll(leftoutBackupIds);
                for (BackUpImage backUpImage : bkpImages) {
                    if (!backupIds.contains(backUpImage.getId())) continue;
                    this.createBackupFile(list, backUpImage);
                }
            }
        }
        if (CollectionUtils.isEmpty(list) && CollectionUtils.isEmpty(pgBkpList) && CollectionUtils.isEmpty(pgBkpNoGatewayList)) {
            logger.debug(BATCH_ID_LOG + restoreId + " No files for download .......... ");
            return -1L;
        }
        List licenseDetails = cloud.getCloudCustomisableDetails();
        boolean isODBEnabled = false;
        licenseDetails.removeAll(Collections.singleton(null));
        for (CloudCustomisableDetails cloudCustomisableDetails : licenseDetails) {
            if (!"ODB Enabled".equals(cloudCustomisableDetails.getName())) continue;
            isODBEnabled = true;
            break;
        }
        PciAuthorizationTokenElement element = null;
        if (isODBEnabled) {
            logger.debug("  USER NAME .................... " + userName);
            User user = this.utilService.getUserInfoByName(cloudId, userName);
            element = this.utilService.getPCITokenElement(cloudId, user.getUserId());
            if (user != null && element != null) {
                element.setUserName(user.getUserName());
            }
        }
        fileVersionMapTemp = new HashMap<String, Long>();
        if (!CollectionUtils.isEmpty(list)) {
            Collections.sort(list, new Comparator<com.pg.domain.BackupFile>(){

                @Override
                public int compare(com.pg.domain.BackupFile c1, com.pg.domain.BackupFile c2) {
                    long t1 = c2.getUploadedTimestamp();
                    long t2 = c1.getUploadedTimestamp();
                    if (t2 > t1) {
                        return 1;
                    }
                    if (t1 > t2) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        for (com.pg.domain.BackupFile backupFile : list) {
            String mapKey = backupFile.getFilePath() + backupFile.getFileName();
            if (fileVersionMapTemp.containsKey(mapKey)) {
                String newFileName;
                Long versionVal = fileVersionMapTemp.get(mapKey);
                fileVersionMapTemp.remove(mapKey);
                long newVersion = versionVal + 1L;
                fileVersionMapTemp.put(mapKey, newVersion);
                if (StringUtils.isNotEmpty((String)FilenameUtils.getExtension((String)backupFile.getFileName()))) {
                    lastDot = backupFile.getFileName().lastIndexOf(46);
                    newFileName = backupFile.getFileName().substring(0, lastDot) + VERSION + newVersion + ")" + backupFile.getFileName().substring(lastDot);
                } else {
                    newFileName = backupFile.getFileName() + VERSION + newVersion + ")";
                }
                backupFile.setFileName(newFileName);
                continue;
            }
            fileVersionMapTemp.put(mapKey, 1L);
        }
        if (!CollectionUtils.isEmpty(pgBkpList)) {
            Collections.sort(pgBkpList, new Comparator<BackUpImage>(){

                @Override
                public int compare(BackUpImage c1, BackUpImage c2) {
                    long t1 = c2.getLastClientModifiedTime();
                    long t2 = c1.getLastClientModifiedTime();
                    if (t2 > t1) {
                        return 1;
                    }
                    if (t1 > t2) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        for (BackUpImage backUpImage : pgBkpList) {
            String mapKey;
            PrivacyGatewayMapping privacyGatewayMapping = this.utilService.getPrivacyGatewayMapping(cloudId, backUpImage.getGatewayName());
            if (privacyGatewayMapping != null) {
                logger.debug("........." + privacyGatewayMapping.getGatewayName() + "...........new........" + privacyGatewayMapping.getNewGatewayName());
                backUpImage.setGatewayName(privacyGatewayMapping.getNewGatewayName());
            }
            if (fileVersionMapTemp.containsKey(mapKey = backUpImage.getDevicePath() + backUpImage.getFileName())) {
                Long versionVal = fileVersionMapTemp.get(mapKey);
                fileVersionMapTemp.remove(mapKey);
                long newVersion = versionVal + 1L;
                fileVersionMapTemp.put(mapKey, newVersion);
                lastDot = backUpImage.getFileName().lastIndexOf(46);
                String newFileName = backUpImage.getFileName().substring(0, lastDot) + VERSION + newVersion + ")" + backUpImage.getFileName().substring(lastDot);
                backUpImage.setFileName(newFileName);
                continue;
            }
            fileVersionMapTemp.put(mapKey, 1L);
        }
        for (com.pg.domain.BackupFile backupFile : list) {
            backupId = backupFile.getId();
            fileName = backupFile.getFileName();
            String folderPath = backupFile.getFilePath();
            List chunkFileList = backupFile.getChunkFiles();
            Collections.sort(chunkFileList, new Comparator<com.pg.domain.ChunkFile>(){

                @Override
                public int compare(com.pg.domain.ChunkFile d1, com.pg.domain.ChunkFile d2) {
                    return d1.getFileName().compareTo(d2.getFileName());
                }
            });
            inputStream = null;
            ArrayList<String> nameList = new ArrayList<String>();
            logger.debug(backupFile.getFileName() + WRITTING_OUTSIDE_TO_STREAM_AND_DOWNLOAD_COUNT + downloadedCountTemp);
            boolean isChunksDownloaded = false;
            for (com.pg.domain.ChunkFile chunkFile : chunkFileList) {
                ChunkDetail chunkDetail;
                String saltKey;
                block186: {
                    saltKey = null;
                    chunkDetail = null;
                    isChunksDownloaded = false;
                    try {
                        String md5 = chunkFile.getMd5();
                        logger.debug(BATCH_ID_LOG + restoreId + " MD5 latest for chunk Fiile $$$$$>>>>>>>>>>>>>>>" + md5);
                        if (StringUtils.isEmpty((String)md5)) {
                            logger.debug("Inside Getting md5 from file name");
                            md5 = DownloadServiceImpl.getMd5FromFileName(chunkFile.getFileName());
                            logger.debug(BATCH_ID_LOG + restoreId + " md5 after filter from filename>>>>" + md5);
                            chunkFile.setMd5(md5);
                        }
                        String dedupVal = this.getDedupValue(userName);
                        List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
                        if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                            logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                            chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                        }
                        if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                            for (ChunkDetail detailFromDB : chunkDetailList) {
                                if (detailFromDB.getRefCount() <= 0) continue;
                                chunkDetail = detailFromDB;
                            }
                        }
                        if (chunkDetail == null) {
                            logger.debug(CHUNK_DETAILS_NULL);
                            chunkDetail = new ChunkDetail();
                            if (isGDEnabled && !StringUtils.isEmpty((String)chunkFile.getFileId())) {
                                chunkDetail.setCloudChunkName(chunkFile.getFileId());
                            } else {
                                chunkDetail.setCloudChunkName(chunkFile.getFileName());
                            }
                            chunkDetail.setCloudStoragePath(chunkFile.getCloudStoragePath());
                            chunkDetail.setContainerName(userName.toLowerCase());
                            chunkDetail.setMd5(chunkFile.getMd5());
                            chunkDetail.setUserName(userName.toLowerCase());
                        } else {
                            chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                            if (StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !StringUtils.isEmpty((String)chunkDetail.getProductType()) && !chunkDetail.getProductType().equals("SYNC")) {
                                chunkDetail.setContainerName(userName.toLowerCase());
                            }
                        }
                        logger.debug(BATCH_ID_LOG + restoreId + chunkFile.getFileName() + "...md5...." + chunkFile.getMd5() + "....CLOUD CHUNK NAME>>>>>>>>>" + chunkDetail.getCloudChunkName());
                        StringBuilder fileNameToDownload = new StringBuilder(chunkDetail.getCloudChunkName());
                        int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                        String chunkProductType = BACKUP;
                        if (chunkDetail != null && !StringUtils.isEmpty((String)chunkDetail.getProductType())) {
                            chunkProductType = chunkDetail.getProductType();
                        }
                        saltKey = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), chunkProductType);
                        if (occurance == 0 || occurance == 1 && chunkFileList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                            fileNameToDownload.append(".").append(backupId);
                        } else if (occurance == 1 && chunkFileList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                            fileNameToDownload.append("." + backupId);
                        }
                        String fileToDownload = fileNameToDownload.toString();
                        if (isGDEnabled) {
                            fileToDownload = chunkDetail.getCloudChunkName();
                        }
                        if ((inputStream = this.downloadFileFromCloud(cloud, restorePath, fileToDownload, userName, cloudName, deviceUUID, element, chunkFile, backupFile, chunkDetail.getContainerName(), chunkDetail.getUserName().toLowerCase(), chunkDetail, fileStatusElement)) == null && occurance == 1 && chunkFileList.size() > 1) {
                            logger.debug(BATCH_ID_LOG + restoreId + " Before writeDatatoStream bruteForceRestoreFromCloud... ");
                            File decryptedFile = this.bruteForceRestoreFromCloud(cloud, cloudName, userName, backupFile, nameList, saltKey, fileName, folderPath, element, restorePath, device, fileStatusElement);
                            if (decryptedFile == null) {
                                this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 507, restoreId);
                                this.sendEmptyContents(response);
                                break;
                            }
                            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                            downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                            logger.debug(BATCH_ID_LOG + restoreId + " after writeDatatoStream bruteForceRestoreFromCloud... ");
                            continue;
                        }
                    }
                    catch (ParacloudBackupException e) {
                        logger.debug("Exception :" + (Object)((Object)e));
                        logger.error(BATCH_ID_LOG + restoreId + " THE error code is>>>>>$$>>>>>" + e.getResponseCode());
                        if (e.getResponseCode() != 404) break block186;
                        nameList.clear();
                        try {
                            File decryptedFile = this.searchReplicaAndRestore(cloud, cloudName, userName, backupFile, nameList, saltKey, fileName, folderPath, element, restorePath, device, fileStatusElement);
                            logger.debug(" Before writeDatatoStream searchReplicaAndRestore... ");
                            if (decryptedFile == null) {
                                this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                                this.sendEmptyContents(response);
                                break;
                            }
                            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                            downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                            logger.debug(BATCH_ID_LOG + restoreId + " After writeDatatoStream searchReplicaAndRestore... ");
                            continue;
                        }
                        catch (Exception ex) {
                            logger.trace("" + ex);
                            logger.error(BATCH_ID_LOG + restoreId + " Error in searchReplicaAndRestore - File not found ...." + ex.getMessage());
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException e1) {
                                logger.trace("" + e1);
                                logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
                            }
                            inputStream = null;
                        }
                    }
                    catch (Exception e) {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e1) {
                            logger.trace("" + e1);
                            logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
                        }
                        logger.trace("" + e);
                        logger.error(BATCH_ID_LOG + restoreId + " Error trying to write data .....22222%%%%%%%%% " + FILE_PATH_STR + backupFile.getFilePath() + FILE_NAME_STR + backupFile.getFileName() + e.getMessage());
                        logger.debug(BATCH_ID_LOG + restoreId + ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH, (Throwable)e);
                        throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                    }
                }
                if (inputStream == null) {
                    this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                    try {
                        logger.debug(BATCH_ID_LOG + restoreId + " DEcrypt file is null so send empty contents .....");
                        this.sendEmptyContents(response);
                    }
                    catch (IOException e) {
                        logger.debug("IOException   " + e);
                        logger.error("IOException   " + e.getMessage());
                    }
                    break;
                }
                String decryptUserName = userName;
                String productType = BACKUP;
                if (chunkDetail != null && "ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                    productType = "sync";
                    decryptUserName = SYNC_DECRYPT_KEY;
                }
                if (chunkDetail != null && StringUtils.isNotEmpty((String)chunkDetail.getProductType()) && chunkDetail.getProductType().equals("SYNC")) {
                    productType = "sync";
                    decryptUserName = SYNC_DECRYPT_KEY;
                }
                if ((saltKey = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), productType)) == null) {
                    throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
                }
                if (!StringUtils.isEmpty((String)chunkDetail.getUserName())) {
                    decryptUserName = chunkDetail.getUserName();
                }
                if (chunkDetail != null && !StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !chunkDetail.getContainerName().equalsIgnoreCase(userName)) {
                    decryptUserName = !StringUtils.isEmpty((String)chunkDetail.getUserName()) ? chunkDetail.getUserName() : chunkDetail.getContainerName();
                }
                if (chunkDetail != null && "ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                    productType = "sync";
                    decryptUserName = SYNC_DECRYPT_KEY;
                }
                logger.debug(BATCH_ID_LOG + restoreId + " close shield input stream decrypt username>>>>>>" + decryptUserName + " ..product type:" + productType);
                logger.debug(fileStatusElement.getFileOwner() + " file owner ...decrypt user name..." + decryptUserName);
                File decryptedDir = this.createDecryptedDirs(restorePath);
                File copyFile = this.copyInputStreamToAFile(fileNameVal, inputStream, decryptedDir);
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(copyFile));
                }
                catch (FileNotFoundException e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                }
                File decryptedFile = this.getDecryptedFile(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), inputStream, decryptUserName, restorePath, chunkFile, cloudId, chunkDetail);
                if (decryptedFile == null) {
                    if (StringUtils.isNotEmpty((String)fileStatusElement.getFileOwner())) {
                        logger.debug("decryptedFile is null and file owner is not empty.." + fileStatusElement.getFileOwner());
                        BufferedInputStream in = null;
                        try {
                            in = new BufferedInputStream(new FileInputStream(copyFile));
                        }
                        catch (FileNotFoundException e) {
                            logger.trace("" + e);
                            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                        }
                        decryptedFile = this.getDecryptedFile(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), in, fileStatusElement.getFileOwner(), restorePath, chunkFile, cloudId, chunkDetail);
                    }
                    if (copyFile.exists()) {
                        copyFile.delete();
                    }
                    if (decryptedFile == null) break;
                }
                if (copyFile.exists()) {
                    copyFile.delete();
                }
                String isChunk = "true";
                this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, isChunk, skipValue, isEncodedEnabled, 203, restoreId);
                downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                nameList.add(chunkFile.getFileName());
                isChunksDownloaded = true;
            }
            if (isChunksDownloaded) {
                ++downloadedCountTemp;
            }
            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, new com.pg.domain.ChunkFile(), "false", skipValue, isEncodedEnabled, 203, restoreId);
        }
        for (BackUpImage backUpImage : pgBkpList) {
            backupId = backUpImage.getId().toString();
            logger.debug(BATCH_ID_LOG + restoreId + backupId + " NEW LOGIC pgBkpList blukrypt gateway .........." + backUpImage.getGatewayName());
            reqFactory = HttpClientUtil.getHttpRequestFactory();
            reqFactory.setConnectTimeout(15000);
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
            ArrayList<Object> messageConverters = new ArrayList<Object>();
            messageConverters.add(new MappingJackson2HttpMessageConverter());
            messageConverters.add(new ByteArrayHttpMessageConverter());
            restTemplate.setMessageConverters(messageConverters);
            headers = new HttpHeaders();
            headers.add(BACKUP_ID, backupId);
            headers.add(CLOUD_NAME, cloudName);
            HttpEntity entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
            FileInfo fileInfo = null;
            String url = "";
            try {
                url = PREFIX_HTTPS + backUpImage.getGatewayName() + "/BluKryptBuilder/get/fileInfo/";
                ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, FileInfo.class, new Object[0]);
                fileInfo = (FileInfo)result.getBody();
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(BATCH_ID_LOG + restoreId + " error trying to connect to pgs ..." + e.getMessage());
            }
            if (fileInfo == null) {
                logger.debug(" File from mongo new Table........ ");
                fileInfo = this.utilService.getPgFileFromMongo(cloudId, cloudName, backupId, true);
            }
            logger.debug(url + FILE_INFO_RECEIVED + fileInfo);
            if (fileInfo == null) continue;
            if (fileInfo.isClientDedupEnabled()) {
                clientDedupEnabledList.add(fileInfo);
                continue;
            }
            logger.debug(BATCH_ID_LOG + restoreId + backUpImage.getFileName() + " pgBkp file meta info recieved .... " + fileInfo.getId());
            fileInfo.setFileName(backUpImage.getFileName());
            List chunkFileList = fileInfo.getChunkFiles();
            Collections.sort(chunkFileList);
            if (backUpImage.getAccessTime() != 0L) {
                fileInfo.setAccessTime(backUpImage.getAccessTime());
            }
            fileInfo.setUploadedTimestamp(Long.valueOf(backUpImage.getLastClientModifiedTime()));
            logger.debug(BATCH_ID_LOG + restoreId + WRITTING_OUTSIDE_TO_STREAM_AND_DOWNLOAD_COUNT + downloadedCountTemp + "chunk list size..." + chunkFileList.size());
            Object deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
            String batchId = fileInfo.getBatchId();
            if (!StringUtils.isEmpty((String)batchId)) {
                deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
            }
            String chunkFilePath = (String)deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
            boolean isChunksDownloaded = false;
            if (!StringUtils.isEmpty((String)fileInfo.getSubject()) || !StringUtils.isEmpty((String)fileInfo.getBodyContent())) {
                this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, fileInfo.getMd5(), skipValue, isEncodedEnabled, restoreId);
                this.restoreMailFromPG(cloudName, response, fileInfo, restoreId);
                isChunksDownloaded = true;
            } else {
                for (String chunkName : chunkFileList) {
                    int endIndex;
                    isChunksDownloaded = false;
                    String fileNameValue = chunkName;
                    String md5 = DownloadServiceImpl.getMd5FromFileName(chunkName);
                    logger.debug(chunkFilePath + FILE_FROM_PG + chunkName);
                    if (!StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                        chunkName = chunkName.substring(0, endIndex);
                    }
                    String filePath = chunkFilePath + "/" + chunkName;
                    restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
                    messageConverters = new ArrayList();
                    messageConverters.add(new ByteArrayHttpMessageConverter());
                    messageConverters.add(new StringHttpMessageConverter());
                    messageConverters.add(new ResourceHttpMessageConverter());
                    messageConverters.add(new SourceHttpMessageConverter());
                    messageConverters.add(new AllEncompassingFormHttpMessageConverter());
                    restTemplate.setMessageConverters(messageConverters);
                    headers = new HttpHeaders();
                    headers.add(FILEPATH, filePath);
                    headers.setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM));
                    entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
                    url = PREFIX_HTTPS + backUpImage.getGatewayName() + BLUKRYPT_BUILDER_DOWNLOAD_FROM_PG;
                    logger.debug(BATCH_ID_LOG + restoreId + " downloadpgBkpList pg url .............." + url);
                    try {
                        ResponseEntity resultObj = restTemplate.exchange(url, HttpMethod.GET, entity, byte[].class, new Object[]{"1"});
                        byte[] bytes = (byte[])resultObj.getBody();
                        if (resultObj.getStatusCode().equals((Object)HttpStatus.NO_CONTENT)) {
                            logger.error(BATCH_ID_LOG + restoreId + " downloadpgBkpList file does not exist in pg..... ");
                            String dedupVal = this.getDedupValue(userName);
                            ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, false, false);
                            if (chunkDetail == null) {
                                logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                                chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, false, true);
                            }
                            if (chunkDetail == null) continue;
                            chunkName = chunkDetail.getCloudChunkName();
                            com.pg.domain.ChunkFile chunkFile = this.getChunkFileFromDetail(fileNameValue, chunkDetail);
                            com.pg.domain.BackupFile backupFile = this.getBackupFile(fileInfo);
                            BufferedInputStream inputStream2 = this.downloadFileFromCloud(cloud, restorePath, chunkName, chunkDetail.getContainerName().toLowerCase(), cloudName, deviceUUID, element, chunkFile, backupFile, chunkDetail.getContainerName().toLowerCase(), chunkDetail.getUserName().toLowerCase(), chunkDetail, fileStatusElement);
                            String saltKey = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), BACKUP);
                            if (saltKey == null) {
                                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
                            }
                            User user = this.utilService.getUserInfoByName(cloudId, chunkDetail.getContainerName());
                            File decryptedFile = this.getDecryptedFile(cloudName, saltKey, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream2, user.getUserName(), restorePath, chunkFile, cloudId, chunkDetail);
                            if (decryptedFile == null) {
                                this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                                this.sendEmptyContents(response);
                                break;
                            }
                            this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                            downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                            isChunksDownloaded = true;
                            continue;
                        }
                        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                        this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                        this.writeDataToStream(response, path, fileInfo, chunkName, filePath, input, restoreId);
                        isChunksDownloaded = true;
                    }
                    catch (Exception e) {
                        logger.trace("" + e);
                        logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e.getMessage());
                        try {
                            this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                            this.sendEmptyContents(response);
                        }
                        catch (IOException e1) {
                            logger.trace("" + e);
                            logger.error("##batch id >>>> new " + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e.getMessage());
                        }
                        break;
                    }
                }
            }
            if (isChunksDownloaded) {
                ++downloadedCountTemp;
            }
            try {
                response.getOutputStream().println();
                response.getOutputStream().println(PARABLU_OF);
                String partHeader = CONTENT_DISPOSITION_FORM_DATA;
                response.getOutputStream().println(partHeader);
                String fileNameHeader = this.getEncodedFileName(isEncodedEnabled, fileInfo.getFilePath());
                byte[] fileNameBytes = fileNameHeader.getBytes(UTF8);
                response.getOutputStream().write(fileNameBytes);
                response.getOutputStream().println();
                String filePathHeader = this.getEncodedFilePath(isEncodedEnabled, fileInfo.getFilePath());
                byte[] filePathBytes = filePathHeader.getBytes(UTF8);
                response.getOutputStream().write(filePathBytes);
                response.getOutputStream().println();
                String clientModifiedTimeHeader = CLIENT_MODIFIED_TIME + fileInfo.getUploadedTimestamp();
                response.getOutputStream().println(clientModifiedTimeHeader);
                if (fileInfo.getAccessTime() != 0L) {
                    String clientAccessTimeHeader = CLIENT_ACCESS_TIME + fileInfo.getAccessTime();
                    response.getOutputStream().println(clientAccessTimeHeader);
                }
                String chunkMd5 = MD5_CHECKSUM;
                response.getOutputStream().println(chunkMd5);
                response.getOutputStream().println("isAChunkFile:false");
                response.getOutputStream().println(COUNT + downloadedCountTemp);
                response.getOutputStream().println();
            }
            catch (Exception e) {
                logger.error(BATCH_ID_LOG + restoreId + " Download Exception NEW......");
                try {
                    String simpleName = e.getCause().getClass().getSimpleName();
                    logger.trace("" + e);
                    logger.error(BATCH_ID_LOG + restoreId + ERROR_TRYING_TO_WRITE_DATA + simpleName + FILE_PATH_STR + fileInfo.getFilePath() + FILE_NAME_STR + fileInfo.getFileName() + e.getMessage());
                    String exceptionMsg = e.getMessage();
                    if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                        this.deleteFilesUnderMergeAndDecrypt(path, restoreId);
                        if (!StringUtils.isEmpty((String)restoreId)) {
                            String pathToDelete = path + restoreId;
                            logger.debug("...deletebase folder..." + pathToDelete);
                            File file2 = new File(pathToDelete);
                            if (file2.exists()) {
                                FileUtils.deleteDirectory((File)file2);
                            }
                        }
                        logger.error(THROW_CLIENT_ABORT_EXCEPTION);
                        throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                    }
                    response.getOutputStream().close();
                }
                catch (IOException e1) {
                    logger.trace("" + e1);
                    logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
                }
            }
        }
        for (FileInfo fileInfo : clientDedupEnabledList) {
            backupId = fileInfo.getId();
            fileName = fileInfo.getFileName();
            String folderPath = fileInfo.getFilePath();
            List chunkFileList = fileInfo.getChunkFiles();
            Collections.sort(chunkFileList, new Comparator<String>(){

                @Override
                public int compare(String d1, String d2) {
                    return d1.compareTo(d2);
                }
            });
            inputStream = null;
            ArrayList<String> nameList = new ArrayList<String>();
            logger.debug(fileInfo.getFileName() + WRITTING_OUTSIDE_TO_STREAM_AND_DOWNLOAD_COUNT + downloadedCountTemp);
            com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
            List bkpImageList = pgBkpList.parallelStream().filter(bkpImage1 -> bkpImage1.getId().toString().equals(backupId)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(bkpImageList)) {
                BackUpImage bkpImage = (BackUpImage)bkpImageList.get(0);
                backupFile.setAccessTime(Long.valueOf(bkpImage.getAccessTime()));
                backupFile.setBackupId(bkpImage.getId());
                backupFile.setCompressed(fileInfo.isCompressed());
                backupFile.setDeviceUUID(bkpImage.getDeviceUUID());
                backupFile.setFileName(bkpImage.getFileName());
                fileInfo.setFileName(bkpImage.getFileName());
                backupFile.setFilePath(bkpImage.getDevicePath());
                backupFile.setMd5(bkpImage.getMd5Checksum());
                backupFile.setId(bkpImage.getId().toString());
                backupFile.setSize(Long.valueOf(bkpImage.getSize()));
                backupFile.setSizeInBytes(Long.valueOf(bkpImage.getSizeInBytes()));
                backupFile.setUserName(bkpImage.getUserName());
                backupFile.setGatewayName(bkpImage.getGatewayName());
                PrivacyGatewayMapping privacyGatewayMapping = this.utilService.getPrivacyGatewayMapping(cloudId, bkpImage.getGatewayName());
                if (privacyGatewayMapping != null) {
                    logger.debug("........." + privacyGatewayMapping.getGatewayName() + "...........new........" + privacyGatewayMapping.getNewGatewayName());
                    backupFile.setGatewayName(privacyGatewayMapping.getNewGatewayName());
                }
                backupFile.setUploadedTimestamp(Long.valueOf(bkpImage.getLastClientModifiedTime()));
            }
            boolean isChunksDownloaded = false;
            for (String chunkFileStr : chunkFileList) {
                String saltKey = null;
                ChunkDetail chunkDetail = null;
                isChunksDownloaded = false;
                com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
                try {
                    logger.debug(BATCH_ID_LOG + restoreId);
                    logger.debug("Inside Getting md5 from file name");
                    String md5 = DownloadServiceImpl.getMd5FromFileName(chunkFileStr);
                    logger.debug(BATCH_ID_LOG + restoreId + " md5 after filter from filename>>>>" + md5);
                    String dedupVal = this.getDedupValue(userName);
                    List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, md5, dedupVal, userName, true, false);
                    if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, md5, dedupVal, userName, true, true);
                    }
                    if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                        for (ChunkDetail detailFromDB : chunkDetailList) {
                            if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                            chunkDetail = detailFromDB;
                        }
                    }
                    if (chunkDetail == null) {
                        logger.debug(CHUNK_DETAILS_NULL);
                        break;
                    }
                    if (!chunkDetail.isPreEntry()) {
                        if (StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !StringUtils.isEmpty((String)chunkDetail.getProductType()) && !chunkDetail.getProductType().equals("SYNC")) {
                            chunkDetail.setContainerName(userName.toLowerCase());
                        }
                        StringBuilder fileNameToDownload = new StringBuilder(chunkDetail.getCloudChunkName());
                        int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                        String chunkProductType = BACKUP;
                        if (chunkDetail != null && !StringUtils.isEmpty((String)chunkDetail.getProductType())) {
                            chunkProductType = chunkDetail.getProductType();
                        }
                        saltKey = this.getEncryptOrDecryptKey(cloudId, chunkDetail.getChunkCreatedTime(), chunkProductType);
                        if (occurance == 0 || occurance == 1 && chunkFileList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                            fileNameToDownload.append(".").append(backupId);
                        } else if (occurance == 1 && chunkFileList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                            fileNameToDownload.append("." + backupId);
                        }
                        String fileToDownload = fileNameToDownload.toString();
                        if (isGDEnabled) {
                            fileToDownload = chunkDetail.getCloudChunkName();
                        }
                        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                        chunkFile.setEncodedName(chunkDetail.getEncodedName());
                        chunkFile.setFileId(chunkDetail.getId().toString());
                        chunkFile.setfSPath(chunkDetail.getFsPath());
                        chunkFile.setUploadedTimeStamp(chunkDetail.getChunkCreatedTime());
                        chunkFile.setFileName(chunkDetail.getCloudChunkName());
                        chunkFile.setMd5(chunkDetail.getMd5());
                        inputStream = this.downloadFileFromCloud(cloud, restorePath, fileToDownload, userName, cloudName, deviceUUID, element, chunkFile, backupFile, chunkDetail.getContainerName(), chunkDetail.getUserName().toLowerCase(), chunkDetail, fileStatusElement);
                        if (inputStream == null && occurance == 1 && chunkFileList.size() > 1) {
                            logger.debug(BATCH_ID_LOG + restoreId + " Before writeDatatoStream bruteForceRestoreFromCloud... ");
                            File decryptedFile = this.bruteForceRestoreFromCloud(cloud, cloudName, userName, backupFile, nameList, saltKey, fileName, folderPath, element, restorePath, device, fileStatusElement);
                            if (decryptedFile == null) {
                                this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                                this.sendEmptyContents(response);
                                break;
                            }
                            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                            downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                            logger.debug(BATCH_ID_LOG + restoreId + " after writeDatatoStream bruteForceRestoreFromCloud... ");
                            continue;
                        }
                        if (inputStream == null) {
                            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                            try {
                                logger.debug(BATCH_ID_LOG + restoreId + " DEcrypt file is null so send empty contents .....");
                                this.sendEmptyContents(response);
                            }
                            catch (IOException e) {
                                logger.debug("IOException   " + e);
                                logger.error("IOException   " + e.getMessage());
                            }
                            break;
                        }
                        String decryptUserName = userName;
                        String productType = BACKUP;
                        if (chunkDetail != null && "ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                            productType = "sync";
                            decryptUserName = SYNC_DECRYPT_KEY;
                        }
                        if (chunkDetail != null && StringUtils.isNotEmpty((String)chunkDetail.getProductType()) && chunkDetail.getProductType().equals("SYNC")) {
                            productType = "sync";
                            decryptUserName = SYNC_DECRYPT_KEY;
                        }
                        logger.debug("...productType..." + productType);
                        saltKey = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), productType);
                        if (saltKey == null) {
                            throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
                        }
                        if (chunkDetail != null && !StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !chunkDetail.getContainerName().equalsIgnoreCase(userName)) {
                            decryptUserName = !StringUtils.isEmpty((String)chunkDetail.getUserName()) ? chunkDetail.getUserName() : chunkDetail.getContainerName();
                        }
                        if (chunkDetail != null && "ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                            productType = "sync";
                            decryptUserName = SYNC_DECRYPT_KEY;
                        }
                        logger.debug(BATCH_ID_LOG + restoreId + " close shield input stream decrypt username>>>>>>" + decryptUserName + " ..product type:" + productType);
                        File decryptedDir = this.createDecryptedDirs(restorePath);
                        File copyFile = this.copyInputStreamToAFile(fileNameVal, inputStream, decryptedDir);
                        try {
                            inputStream = new BufferedInputStream(new FileInputStream(copyFile));
                        }
                        catch (FileNotFoundException e) {
                            logger.trace("" + e);
                            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                        }
                        File decryptedFile = this.getDecryptedFile(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), inputStream, decryptUserName, restorePath, chunkFile, cloudId, chunkDetail);
                        if (decryptedFile == null) {
                            if (StringUtils.isNotEmpty((String)fileStatusElement.getFileOwner())) {
                                BufferedInputStream in = null;
                                try {
                                    in = new BufferedInputStream(new FileInputStream(copyFile));
                                }
                                catch (FileNotFoundException e) {
                                    logger.trace("" + e);
                                    logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                                }
                                decryptedFile = this.getDecryptedFile(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), in, fileStatusElement.getFileOwner(), restorePath, chunkFile, cloudId, chunkDetail);
                            }
                            if (copyFile.exists()) {
                                copyFile.delete();
                            }
                            if (decryptedFile == null) break;
                        }
                        if (copyFile.exists()) {
                            copyFile.delete();
                        }
                        String isChunk = "true";
                        this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, isChunk, skipValue, isEncodedEnabled, 203, restoreId);
                        downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                        nameList.add(chunkFile.getFileName());
                        isChunksDownloaded = true;
                        continue;
                    }
                    if (!chunkDetail.isPreEntry()) continue;
                    logger.debug(BATCH_ID_LOG + restoreId + chunkFile.getFileName() + " pgBkp file meta info recieved .... " + fileInfo.getId());
                    if (backupFile.getAccessTime() != 0L) {
                        fileInfo.setAccessTime(backupFile.getAccessTime().longValue());
                    }
                    fileInfo.setUploadedTimestamp(backupFile.getUploadedTimestamp());
                    logger.debug(BATCH_ID_LOG + restoreId + WRITTING_OUTSIDE_TO_STREAM_AND_DOWNLOAD_COUNT + downloadedCountTemp + "chunk list size..." + chunkFileList.size());
                    isChunksDownloaded = false;
                    String fileNameValue = chunkFileStr;
                    md5 = DownloadServiceImpl.getMd5FromFileName(chunkFileStr);
                    logger.debug(chunkDetail.getFsPath() + FILE_FROM_PG + chunkFileStr);
                    String filePath = chunkDetail.getFsPath();
                    HttpComponentsClientHttpRequestFactory reqFactory2 = HttpClientUtil.getHttpRequestFactory();
                    reqFactory2.setConnectTimeout(15000);
                    RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory2);
                    ArrayList<Object> messageConverters = new ArrayList<Object>();
                    messageConverters.add(new MappingJackson2HttpMessageConverter());
                    messageConverters.add(new ByteArrayHttpMessageConverter());
                    restTemplate.setMessageConverters(messageConverters);
                    HttpHeaders headers2 = new HttpHeaders();
                    restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory2);
                    messageConverters = new ArrayList();
                    messageConverters.add(new ByteArrayHttpMessageConverter());
                    messageConverters.add(new StringHttpMessageConverter());
                    messageConverters.add(new ResourceHttpMessageConverter());
                    messageConverters.add(new SourceHttpMessageConverter());
                    messageConverters.add(new AllEncompassingFormHttpMessageConverter());
                    restTemplate.setMessageConverters(messageConverters);
                    headers2 = new HttpHeaders();
                    headers2.add(FILEPATH, filePath);
                    headers2.setAccept(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM));
                    HttpEntity entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers2);
                    String url = PREFIX_HTTPS + backupFile.getGatewayName() + BLUKRYPT_BUILDER_DOWNLOAD_FROM_PG;
                    logger.debug(BATCH_ID_LOG + restoreId + " downloadpgBkpList pg url .............." + url);
                    try {
                        ResponseEntity resultObj = restTemplate.exchange(url, HttpMethod.GET, entity, byte[].class, new Object[]{"1"});
                        byte[] bytes = (byte[])resultObj.getBody();
                        if (resultObj.getStatusCode().equals((Object)HttpStatus.NO_CONTENT)) {
                            logger.error(BATCH_ID_LOG + restoreId + " downloadpgBkpList file does not exist in pg..... ");
                            dedupVal = this.getDedupValue(userName);
                            chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, false, false);
                            if (chunkDetail == null) {
                                logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                                chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, false, true);
                            }
                            if (chunkDetail == null) continue;
                            String chunkName = chunkDetail.getCloudChunkName();
                            chunkFile = this.getChunkFileFromDetail(fileNameValue, chunkDetail);
                            backupFile = this.getBackupFile(fileInfo);
                            inputStream = this.downloadFileFromCloud(cloud, restorePath, chunkName, chunkDetail.getContainerName().toLowerCase(), cloudName, deviceUUID, element, chunkFile, backupFile, chunkDetail.getContainerName().toLowerCase(), chunkDetail.getUserName().toLowerCase(), chunkDetail, fileStatusElement);
                            saltKey = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), BACKUP);
                            if (saltKey == null) {
                                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
                            }
                            User user = this.utilService.getUserInfoByName(cloudId, chunkDetail.getContainerName());
                            File decryptedFile = this.getDecryptedFile(cloudName, saltKey, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, user.getUserName(), restorePath, chunkFile, cloudId, chunkDetail);
                            if (decryptedFile == null) {
                                this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                                this.sendEmptyContents(response);
                                break;
                            }
                            this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                            downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                            isChunksDownloaded = true;
                            continue;
                        }
                        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                        this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                        this.writeDataToStream(response, path, fileInfo, chunkFileStr, filePath, input, restoreId);
                        isChunksDownloaded = true;
                    }
                    catch (Exception e) {
                        logger.trace("" + e);
                        logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e.getMessage());
                        try {
                            this.addHeaderFieldsToMultiPartFrFilesInPG(response, downloadedCountTemp, path, fileInfo, md5, skipValue, isEncodedEnabled, restoreId);
                            this.sendEmptyContents(response);
                        }
                        catch (IOException e1) {
                            logger.trace("" + e);
                            logger.error("##batch id >>>> new " + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e.getMessage());
                        }
                        break;
                    }
                }
                catch (ParacloudBackupException e) {
                    logger.debug("Exception :" + (Object)((Object)e));
                    logger.error(BATCH_ID_LOG + restoreId + " THE error code is>>>>>$$>>>>>" + e.getResponseCode());
                    if (e.getResponseCode() != 404) continue;
                    nameList.clear();
                    try {
                        File decryptedFile = this.searchReplicaAndRestore(cloud, cloudName, userName, backupFile, nameList, saltKey, fileName, folderPath, element, restorePath, device, fileStatusElement);
                        logger.debug(" Before writeDatatoStream searchReplicaAndRestore... ");
                        if (decryptedFile == null) {
                            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                            this.sendEmptyContents(response);
                            break;
                        }
                        this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, chunkFile, "true", skipValue, isEncodedEnabled, 203, restoreId);
                        downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                        logger.debug(BATCH_ID_LOG + restoreId + " After writeDatatoStream searchReplicaAndRestore... ");
                    }
                    catch (Exception ex) {
                        logger.trace("" + ex);
                        logger.error(BATCH_ID_LOG + restoreId + " Error in searchReplicaAndRestore - File not found ...." + ex.getMessage());
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e1) {
                            logger.trace("" + e1);
                            logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
                        }
                        inputStream = null;
                    }
                }
                catch (Exception e) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        logger.trace("" + e1);
                        logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
                    }
                    logger.trace("" + e);
                    logger.error(BATCH_ID_LOG + restoreId + " Error trying to write data .....22222%%%%%%%%% " + FILE_PATH_STR + backupFile.getFilePath() + FILE_NAME_STR + backupFile.getFileName() + e.getMessage());
                    logger.debug(BATCH_ID_LOG + restoreId + ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e);
                    throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                }
            }
            if (isChunksDownloaded) {
                ++downloadedCountTemp;
            }
            this.addHeadersInMultiPart(response, downloadedCountTemp, path, backupFile, new com.pg.domain.ChunkFile(), "false", skipValue, isEncodedEnabled, 203, restoreId);
        }
        for (BackUpImage backUpImage : pgBkpNoGatewayList) {
            backupId = backUpImage.getId().toString();
            logger.error(backupId + "pgBkpNoGatewayList blukrypt gateway .........." + backUpImage.getGatewayName());
            reqFactory = HttpClientUtil.getHttpRequestFactory();
            reqFactory.setConnectTimeout(15000);
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
            ArrayList<Object> messageConverters = new ArrayList<Object>();
            messageConverters.add(new MappingJackson2HttpMessageConverter());
            messageConverters.add(new ByteArrayHttpMessageConverter());
            restTemplate.setMessageConverters(messageConverters);
            headers = new HttpHeaders();
            headers.add(BACKUP_ID, backupId);
            headers.add(CLOUD_NAME, cloudName);
            headers.add("userName", backUpImage.getUserName());
            HttpEntity entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
            FileInfo fileInfo = null;
            List pgList = this.backupFileDao.getAllGateways(cloudId);
            String gateWayName = "";
            for (PrivacyGateway privacyGateway : pgList) {
                if (StringUtils.isEmpty((String)privacyGateway.getGatewayName())) continue;
                try {
                    String url = PREFIX_HTTPS + privacyGateway.getGatewayName() + "/BluKryptBuilder/get/user/fileInfo/";
                    ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, FileInfo.class, new Object[0]);
                    fileInfo = (FileInfo)result.getBody();
                    gateWayName = privacyGateway.getGatewayName();
                    logger.error(privacyGateway.getGatewayName() + FILE_INFO_RECEIVED + fileInfo);
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error(" pgBkpNoGatewayList trying to get fileinfo from Pg...... " + e.getMessage());
                }
                if (fileInfo == null) continue;
                break;
            }
            if (fileInfo == null) continue;
            logger.error(BATCH_ID_LOG + restoreId + fileInfo.getFileName() + FILE_META_INFO_RECEIVED + fileInfo.getId());
            List chunkFileList = fileInfo.getChunkFiles();
            Collections.sort(chunkFileList);
            fileInfo.setUploadedTimestamp(Long.valueOf(backUpImage.getLastClientModifiedTime()));
            logger.debug(BATCH_ID_LOG + restoreId + WRITTING_OUTSIDE_TO_STREAM_AND_DOWNLOAD_COUNT + downloadedCountTemp);
            String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
            String batchId = fileInfo.getBatchId();
            if (!StringUtils.isEmpty((String)batchId)) {
                deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
            }
            String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
            boolean isChunksDownloaded = false;
            for (String chunkName : chunkFileList) {
                int endIndex;
                isChunksDownloaded = false;
                String fileNameValue = chunkName;
                logger.debug(BATCH_ID_LOG + restoreId + chunkFilePath + FILE_FROM_PG + chunkName);
                String md5 = DownloadServiceImpl.getMd5FromFileName(chunkName);
                if (!StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                    chunkName = chunkName.substring(0, endIndex);
                }
                String filePath = chunkFilePath + "/" + chunkName;
                restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
                messageConverters = new ArrayList();
                messageConverters.add(new MappingJackson2HttpMessageConverter());
                messageConverters.add(new ByteArrayHttpMessageConverter());
                messageConverters.add(new StringHttpMessageConverter());
                messageConverters.add(new ResourceHttpMessageConverter());
                restTemplate.setMessageConverters(messageConverters);
                headers = new HttpHeaders();
                headers.add(FILEPATH, filePath);
                entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
                String url = PREFIX_HTTPS + gateWayName + BLUKRYPT_BUILDER_DOWNLOAD_FROM_PG;
                logger.debug(" downloadpgBkpNoGatewayList pg url .............." + url);
                try {
                    ResponseEntity resultObj = restTemplate.exchange(url, HttpMethod.GET, entity, byte[].class, new Object[0]);
                    if (resultObj.getStatusCode().equals((Object)HttpStatus.NO_CONTENT)) {
                        logger.debug(BATCH_ID_LOG + restoreId + "file does not exist in pg. try parent file.... ");
                        String dedupVal = this.getDedupValue(userName);
                        ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, false, false);
                        if (chunkDetail == null) {
                            logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                            chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, false, true);
                        }
                        if (chunkDetail == null) continue;
                        com.pg.domain.ChunkFile chunkFile = this.getChunkFileFromDetail(fileNameValue, chunkDetail);
                        com.pg.domain.BackupFile backupFile = this.getBackupFile(fileInfo);
                        chunkName = chunkDetail.getCloudChunkName();
                        BufferedInputStream inputStream3 = this.downloadFileFromCloud(cloud, restorePath, chunkName, chunkDetail.getContainerName().toLowerCase(), cloudName, deviceUUID, element, chunkFile, backupFile, chunkDetail.getContainerName().toLowerCase(), chunkDetail.getUserName().toLowerCase(), chunkDetail, fileStatusElement);
                        String saltKey = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), BACKUP);
                        if (saltKey == null) {
                            throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
                        }
                        User user = this.utilService.getUserInfoByName(cloudId, chunkDetail.getContainerName());
                        File decryptedFile = this.getDecryptedFile(cloudName, saltKey, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream3, user.getUserName(), restorePath, chunkFile, cloudId, chunkDetail);
                        if (decryptedFile == null) {
                            this.addHeadersInMultiPartForFilesInOthrPG(response, downloadedCountTemp, path, backUpImage, fileInfo, skipValue, isEncodedEnabled, restoreId);
                            this.sendEmptyContents(response);
                            break;
                        }
                        downloadedCountTemp = this.addHeadersInMultiPartForFilesInOthrPG(response, downloadedCountTemp, path, backUpImage, fileInfo, skipValue, isEncodedEnabled, restoreId);
                        downloadedCountTemp = this.writeDataToStream(response, totalCount, downloadedCountTemp, path, restorePath, backupFile, decryptedFile, restoreId);
                        isChunksDownloaded = true;
                        continue;
                    }
                    byte[] bytes = (byte[])resultObj.getBody();
                    ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                    downloadedCountTemp = this.addHeadersInMultiPartForFilesInOthrPG(response, downloadedCountTemp, path, backUpImage, fileInfo, skipValue, isEncodedEnabled, restoreId);
                    this.writeDataToStream(response, path, fileInfo, chunkName, filePath, input, restoreId);
                    isChunksDownloaded = true;
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error(BATCH_ID_LOG + restoreId + EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e.getMessage());
                }
            }
            if (isChunksDownloaded) {
                ++downloadedCountTemp;
            }
            downloadedCountTemp = this.addHeadersInMultiPartForFilesInOthrPG(response, downloadedCountTemp, path, backUpImage, fileInfo, skipValue, isEncodedEnabled, restoreId);
        }
        return downloadedCountTemp;
    }

    private File retryWithParentSaltKey(int cloudId, String cloudName, String deviceUUID, String restorePath, com.pg.domain.ChunkFile chunkFile, ChunkDetail chunkDetail, String decryptUserName, BufferedInputStream csis, File decryptedFile1) {
        File decryptedFile = decryptedFile1;
        String saltKey = "";
        if (chunkDetail == null) {
            return null;
        }
        logger.debug("decrypted file is null so get salt key for parent file id>>>>>" + chunkDetail.getCloudChunkName());
        int occurance = StringUtils.countMatches((String)chunkDetail.getCloudChunkName(), (String)".");
        String backupIdOfchunkFile = DownloadServiceImpl.getBackupIdFromFileName(chunkDetail.getCloudChunkName(), occurance);
        logger.debug("Backup id of chunk file is>>>>>>" + backupIdOfchunkFile);
        if (!StringUtils.isEmpty((String)backupIdOfchunkFile)) {
            logger.debug("inside getting bkp image Backup id of chunk file is>>>>>>" + backupIdOfchunkFile);
            BackUpImage bkpImage = this.backUpImageDao.getBackupFileForIDOnly(cloudId, new ObjectId(backupIdOfchunkFile));
            if (bkpImage != null) {
                if (!CollectionUtils.isEmpty((Collection)bkpImage.getChunkFiles())) {
                    logger.debug("Backup image is not null>>>>>>" + bkpImage.getChunkFiles().size());
                    for (ChunkFile chunkFile2 : bkpImage.getChunkFiles()) {
                        if (chunkFile2.getMd5() == null) {
                            chunkFile2.setMd5(DownloadServiceImpl.getMd5FromFileName(chunkFile2.getFileName()));
                        }
                        if (!chunkFile2.getMd5().equals(chunkDetail.getMd5())) continue;
                        logger.debug("BEFORE ####Salt key for retry to get decrypt file with parent file salt key############:");
                        saltKey = this.getEncryptOrDecryptKey(cloudId, chunkFile2.getUploadedTimeStamp(), BACKUP);
                        logger.debug("Salt key for retry to get decrypt file with parent file salt key############:" + saltKey);
                        break;
                    }
                    decryptedFile = this.getDecryptedFile1(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), csis, decryptUserName, restorePath);
                } else {
                    List encryptionKeysList = new ArrayList();
                    if (chunkFile.getUploadedTimeStamp() == 0L) {
                        encryptionKeysList = this.encryptionKeyDao.getAllEncryptionKeys(cloudId, BACKUP);
                    }
                    for (EncryptionKey key : encryptionKeysList) {
                        logger.debug("inside else part salt key is>>>>>>" + backupIdOfchunkFile);
                        decryptedFile = this.getDecryptedFile1(cloudName, key.getSaltKey(), deviceUUID, chunkFile.getFileName(), csis, decryptUserName, restorePath);
                        if (decryptedFile == null) {
                            logger.debug("inside getting bkp image is null for id>>>>>>" + backupIdOfchunkFile);
                            continue;
                        }
                        break;
                    }
                }
            } else {
                decryptedFile = this.getDecryptedFile1(cloudName, saltKey, deviceUUID, chunkFile.getFileName(), csis, decryptUserName, restorePath);
                logger.debug("inside getting saltKey is null for id>>>>>>" + saltKey);
            }
        }
        return decryptedFile;
    }

    private void createBackupFile(List<com.pg.domain.BackupFile> list, BackUpImage backUpImage) {
        com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
        BeanUtils.copyProperties((Object)backUpImage, (Object)backupFile);
        backupFile.setBackupId(backUpImage.getId());
        backupFile.setFilePath(backUpImage.getDevicePath());
        backupFile.setUploadedTimestamp(Long.valueOf(backUpImage.getLastClientModifiedTime()));
        backupFile.setMd5(backUpImage.getMd5Checksum());
        ArrayList<com.pg.domain.ChunkFile> pgChunkFiles = new ArrayList<com.pg.domain.ChunkFile>();
        com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
        chunkFile.setFileName(backUpImage.getMd5Checksum() + "." + backUpImage.getId().toString());
        chunkFile.setFileId(backUpImage.getMd5Checksum() + "." + backUpImage.getId().toString());
        chunkFile.setMd5(backUpImage.getMd5Checksum());
        pgChunkFiles.add(chunkFile);
        backupFile.setChunkFiles(pgChunkFiles);
        list.add(backupFile);
    }

    private long addHeadersInMultiPartForFilesInOthrPG(HttpServletResponse response, long downloadedCountTemp, String path, BackUpImage pgBkp, FileInfo fileInfo, int skipValue, Boolean isEncodedEnabled, String restoreId) {
        try {
            response.getOutputStream().println();
            response.getOutputStream().println(PARABLU_OF);
            String partHeader = CONTENT_DISPOSITION_FORM_DATA;
            response.getOutputStream().println(partHeader);
            String fileNameHeader = this.getEncodedFileName(isEncodedEnabled, fileInfo.getFileName());
            byte[] fileNameBytes = fileNameHeader.getBytes(UTF8);
            response.getOutputStream().write(fileNameBytes);
            response.getOutputStream().println();
            String filePathHeader = this.getEncodedFilePath(isEncodedEnabled, fileInfo.getFilePath());
            byte[] filePathBytes = filePathHeader.getBytes(UTF8);
            response.getOutputStream().write(filePathBytes);
            response.getOutputStream().println();
            String clientModifiedTimeHeader = CLIENT_MODIFIED_TIME + fileInfo.getUploadedTimestamp();
            response.getOutputStream().println(clientModifiedTimeHeader);
            if (fileInfo.getAccessTime() != 0L) {
                String clientAccessTimeHeader = CLIENT_ACCESS_TIME + fileInfo.getAccessTime();
                response.getOutputStream().println(clientAccessTimeHeader);
            }
            String md5 = MD5_CHECKSUM + pgBkp.getMd5Checksum();
            response.getOutputStream().println(md5);
            logger.debug(FILE_MD5 + md5);
            response.getOutputStream().println(COMPRESSION_ENABLED + String.valueOf(pgBkp.isCompressed()));
            response.getOutputStream().println(COUNT + downloadedCountTemp);
            response.getOutputStream().println(SKIP_VALUE + skipValue);
            response.getOutputStream().println();
        }
        catch (Exception e) {
            String simpleName = e.getCause().getClass().getSimpleName();
            logger.trace("" + e);
            logger.error(ERROR_TRYING_TO_WRITE_DATA + simpleName + FILE_PATH_STR + fileInfo.getFilePath() + FILE_NAME_STR + fileInfo.getFileName() + e.getMessage());
            try {
                String exceptionMsg = e.getMessage();
                if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                    this.deleteFilesUnderMergeAndDecrypt(path, restoreId);
                    logger.error(THROW_CLIENT_ABORT_EXCEPTION);
                    throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error(EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
            }
        }
        return downloadedCountTemp;
    }

    private void addHeadersInMultiPart(HttpServletResponse response, long downloadedCountTemp, String path, com.pg.domain.BackupFile backupFile, com.pg.domain.ChunkFile chunkFile, String isChunk, int skipValue, Boolean isEncodedEnabled, int statusCode, String restoreId) {
        try {
            response.getOutputStream().println();
            response.getOutputStream().println(PARABLU_OF);
            String partHeader = CONTENT_DISPOSITION_FORM_DATA;
            response.getOutputStream().println(partHeader);
            String fileNameHeader = this.getEncodedFileName(isEncodedEnabled, backupFile.getFileName());
            byte[] fileNameBytes = fileNameHeader.getBytes(UTF8);
            response.getOutputStream().write(fileNameBytes);
            response.getOutputStream().println();
            String filePathHeader = this.getEncodedFilePath(isEncodedEnabled, backupFile.getFilePath());
            byte[] filePathBytes = filePathHeader.getBytes(UTF8);
            response.getOutputStream().write(filePathBytes);
            response.getOutputStream().println();
            String clientModifiedTimeHeader = CLIENT_MODIFIED_TIME + backupFile.getUploadedTimestamp();
            response.getOutputStream().println(clientModifiedTimeHeader);
            if (backupFile.getAccessTime() != null) {
                String clientAccessTimeHeader = CLIENT_ACCESS_TIME + backupFile.getAccessTime();
                response.getOutputStream().println(clientAccessTimeHeader);
            }
            String md5 = MD5_CHECKSUM + chunkFile.getMd5();
            response.getOutputStream().println(md5);
            logger.debug(FILE_MD5 + md5 + ".....client...." + clientModifiedTimeHeader);
            response.getOutputStream().println(COMPRESSION_ENABLED + String.valueOf(backupFile.isCompressed()));
            response.getOutputStream().println("isAChunkFile:" + isChunk);
            response.getOutputStream().println(SKIP_VALUE + skipValue);
            response.getOutputStream().println("downloadStatus:" + statusCode);
            response.getOutputStream().println(COUNT + downloadedCountTemp);
            response.getOutputStream().println();
        }
        catch (Exception e) {
            String simpleName = e.getCause().getClass().getSimpleName();
            logger.trace("" + e);
            logger.error(ERROR_TRYING_TO_WRITE_DATA + simpleName + FILE_PATH_STR + backupFile.getFilePath() + FILE_NAME_STR + backupFile.getFileName() + e.getMessage());
            try {
                String exceptionMsg = e.getMessage();
                if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                    this.deleteFilesUnderMergeAndDecrypt(path, restoreId);
                    if (!StringUtils.isEmpty((String)restoreId)) {
                        String pathToDelete = path + restoreId;
                        logger.debug("...deletebase folder..." + pathToDelete);
                        File file = new File(pathToDelete);
                        if (file.exists()) {
                            FileUtils.deleteDirectory((File)file);
                        }
                    }
                    logger.error(THROW_CLIENT_ABORT_EXCEPTION + path);
                    throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error(EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
            }
        }
    }

    private void addHeaderFieldsToMultiPartFrFilesInPG(HttpServletResponse response, long downloadedCountTemp, String path, FileInfo fileInfo, String md5, int skipValue, Boolean isEncodedEnabled, String restoreId) {
        try {
            response.getOutputStream().println();
            response.getOutputStream().println(PARABLU_OF);
            String partHeader = CONTENT_DISPOSITION_FORM_DATA;
            response.getOutputStream().println(partHeader);
            String fileNameHeader = this.getEncodedFileName(isEncodedEnabled, fileInfo.getFileName());
            byte[] fileNameBytes = fileNameHeader.getBytes(UTF8);
            response.getOutputStream().write(fileNameBytes);
            response.getOutputStream().println();
            String filePathHeader = this.getEncodedFilePath(isEncodedEnabled, fileInfo.getFilePath());
            byte[] filePathBytes = filePathHeader.getBytes(UTF8);
            response.getOutputStream().write(filePathBytes);
            response.getOutputStream().println();
            String clientModifiedTimeHeader = CLIENT_MODIFIED_TIME + fileInfo.getUploadedTimestamp();
            response.getOutputStream().println(clientModifiedTimeHeader);
            if (fileInfo.getAccessTime() != 0L) {
                String clientAccessTimeHeader = CLIENT_ACCESS_TIME + fileInfo.getAccessTime();
                response.getOutputStream().println(clientAccessTimeHeader);
            }
            String chunkMd5 = MD5_CHECKSUM + md5;
            response.getOutputStream().println(chunkMd5);
            response.getOutputStream().println(COMPRESSION_ENABLED + String.valueOf(fileInfo.isCompressed()));
            logger.debug(FILE_MD5 + chunkMd5);
            response.getOutputStream().println("isAChunkFile:true");
            response.getOutputStream().println(SKIP_VALUE + skipValue);
            response.getOutputStream().println(COUNT + downloadedCountTemp);
            response.getOutputStream().println();
        }
        catch (Exception e) {
            String simpleName = e.getCause().getClass().getSimpleName();
            logger.trace("" + e);
            logger.error(ERROR_TRYING_TO_WRITE_DATA + simpleName + FILE_PATH_STR + fileInfo.getFilePath() + FILE_NAME_STR + fileInfo.getFileName() + e.getMessage());
            try {
                String exceptionMsg = e.getMessage();
                if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                    this.deleteFilesUnderMergeAndDecrypt(path, restoreId);
                    logger.error(THROW_CLIENT_ABORT_EXCEPTION);
                    throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error(EXCEPTION_WHILE_RESTORE_FROM_CLOUD + e1.getMessage());
            }
        }
    }

    private static String getMd5FromFileName(String fileName) {
        int occurance = StringUtils.countMatches((String)fileName, (String)".");
        String md5 = "";
        logger.debug("File name inside getmd5$$$$>>:" + fileName);
        if (occurance == 0) {
            md5 = fileName;
        } else if (occurance == 1) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        if (StringUtils.isNotEmpty((String)md5) && md5.contains("_")) {
            md5 = md5.substring(0, md5.lastIndexOf("_"));
        }
        return md5;
    }

    private long createEmptyFileContents(HttpServletResponse response, BackUpImage backUpImage, long downloadedCount, long totalCount, Boolean isEncodedEnabled) {
        long downloadedCountTemp = downloadedCount;
        try {
            logger.error("FILESNOTINPG....................." + downloadedCountTemp);
            response.getOutputStream().println();
            response.getOutputStream().println(PARABLU_OF);
            String partHeader = CONTENT_DISPOSITION_FORM_DATA;
            response.getOutputStream().println(partHeader);
            String fileNameHeader = this.getEncodedFileName(isEncodedEnabled, backUpImage.getFileName());
            byte[] fileNameBytes = fileNameHeader.getBytes(UTF8);
            response.getOutputStream().write(fileNameBytes);
            response.getOutputStream().println();
            String filePathHeader = this.getEncodedFilePath(isEncodedEnabled, backUpImage.getDevicePath());
            byte[] filePathBytes = filePathHeader.getBytes(UTF8);
            response.getOutputStream().write(filePathBytes);
            response.getOutputStream().println();
            String clientModifiedTimeHeader = CLIENT_MODIFIED_TIME + backUpImage.getLastClientModifiedTime();
            response.getOutputStream().println(clientModifiedTimeHeader);
            if (backUpImage.getAccessTime() != 0L) {
                String clientAccessTimeHeader = CLIENT_ACCESS_TIME + backUpImage.getAccessTime();
                response.getOutputStream().println(clientAccessTimeHeader);
            }
            String md5 = MD5_CHECKSUM + backUpImage.getMd5Checksum();
            response.getOutputStream().println(md5);
            logger.debug(FILE_MD5 + md5);
            response.getOutputStream().println(COUNT + ++downloadedCountTemp);
            this.sendEmptyContents(response);
        }
        catch (Exception e) {
            String simpleName = e.getCause().getClass().getSimpleName();
            logger.trace("" + e);
            logger.error(ERROR_TRYING_TO_WRITE_DATA + simpleName + FILE_PATH_STR + backUpImage.getDevicePath() + FILE_NAME_STR + backUpImage.getFileName() + e.getMessage());
            try {
                String exceptionMsg = e.getMessage();
                if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                    logger.error(THROW_CLIENT_ABORT_EXCEPTION);
                    throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error("Exception While Creating Empty Contents :" + e1.getMessage());
            }
        }
        return downloadedCountTemp;
    }

    private void writeDataToStream(HttpServletResponse response, String path, FileInfo fileInfo, String chunkName, String filePath, InputStream input, String restoreId) {
        if (input != null) {
            logger.debug(" writeDataToStream file from pg.size................." + filePath);
            try {
                this.writeDataToStreamForPg(response, path, fileInfo, input, chunkName, restoreId);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(EXCEPTION_WHILE_WRITTING_DATA_TO_STREAM + e.getMessage());
            }
        } else {
            logger.error(" file does not exists........" + filePath);
        }
    }

    private com.pg.domain.ChunkFile getChunkFileFromDetail(String fileNameValue, ChunkDetail chunkDetail) {
        com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
        chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
        chunkFile.setMd5(chunkDetail.getMd5());
        chunkFile.setFileName(fileNameValue);
        return chunkFile;
    }

    private com.pg.domain.BackupFile getBackupFile(FileInfo fileInfo) {
        com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
        backupFile.setFileName(fileInfo.getFileName());
        backupFile.setFilePath(fileInfo.getFilePath());
        backupFile.setId(fileInfo.getId());
        backupFile.setBackupId(new ObjectId(fileInfo.getId()));
        return backupFile;
    }

    private long writeDataToStream(HttpServletResponse response, long totalCount, long downloadedCount, String path, String restorePath, com.pg.domain.BackupFile backupFile, File decryptedFile, String restoreId) {
        long downloadedCountTemp = downloadedCount;
        try {
            logger.debug(NO_MERGE);
            downloadedCountTemp = this.writeDataToStream(decryptedFile, backupFile, response, totalCount, downloadedCountTemp, restorePath);
        }
        catch (Exception e) {
            String simpleName = e.getCause().getClass().getSimpleName();
            logger.trace("" + e);
            logger.error(ERROR_WHILE_TRYING_TO_WRITE_DATA + simpleName + e.getMessage());
            try {
                if (decryptedFile.exists()) {
                    decryptedFile.delete();
                }
                String exceptionMsg = e.getMessage();
                if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                    this.deleteFilesUnderMergeAndDecrypt(path, restoreId);
                    logger.error(THROW_CLIENT_ABORT_EXCEPTION);
                    throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error(EXCEPTION_WHILE_WRITTING_DATA_TO_STREAM + e1.getMessage());
            }
        }
        return downloadedCountTemp;
    }

    private void writeDataToStreamForPg(HttpServletResponse response, String path, FileInfo fileInfo, InputStream fif, String fileName, String restoreId) {
        try {
            logger.debug(NO_MERGE);
            this.writeDataToStreamForPg(fileInfo, response, fif, fileName);
        }
        catch (Exception e) {
            String simpleName = e.getCause().getClass().getSimpleName();
            logger.trace("" + e);
            logger.error(ERROR_WHILE_TRYING_TO_WRITE_DATA + simpleName + e.getMessage());
            try {
                String exceptionMsg = e.getMessage();
                if (CLIENT_ABORT_EXCEPTION.equals(simpleName) || SOCKET_EXCEPTION.equals(simpleName) || simpleName.equals("IOException") && exceptionMsg.contains("Broken pipe")) {
                    this.deleteFilesUnderMergeAndDecrypt(path, restoreId);
                    logger.error(THROW_CLIENT_ABORT_EXCEPTION);
                    throw new BlukryptClientAbortException(CLIENT_ABORTED, 1);
                }
                response.getOutputStream().close();
            }
            catch (IOException e1) {
                logger.trace("" + e1);
                logger.error("Exception While Writting Data To Stream For PG :" + e1.getMessage());
            }
        }
    }

    public String getEncryptOrDecryptKey(int cloudId, long timeStamp, String productType) {
        EncryptionKey encryptionKey = this.encryptionKeyDao.getKeyForDecrypt(cloudId, timeStamp, productType);
        String encryptionKeyVal = "";
        if (encryptionKey != null) {
            encryptionKeyVal = encryptionKey.getSaltKey();
            logger.debug("Recieved salt key  for file ..... " + encryptionKeyVal);
        }
        return encryptionKeyVal;
    }

    private File getDecryptedFile(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStream, String userName, String restorePath, com.pg.domain.ChunkFile chunkFile, int cloudId, ChunkDetail chunkDetail) {
        BufferedInputStream inputStreamTemp = inputStream;
        File decryptedDir = this.createDecryptedDirs(restorePath);
        if (inputStreamTemp == null) {
            return null;
        }
        File copyFile = this.copyInputStreamToAFile(fileName, inputStreamTemp, decryptedDir);
        File decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        logger.debug("Before trying with userName normal copy file case>>>>>>" + userName + "inputstreamlength>>>>");
        try {
            inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
        }
        catch (FileNotFoundException e) {
            logger.trace("" + e);
            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
        }
        decryptedFile = this.fileEncryptionService.decrypt(saltKey, userName, inputStreamTemp, decryptedFile);
        logger.debug("END OF trying with userName normal case>>>>>>");
        if (decryptedFile == null) {
            String userLowerCase = null;
            try {
                userLowerCase = userName.toLowerCase();
                logger.error("Decryptfile is null so try with user lowercase...." + userLowerCase);
                decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
                inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
            }
            decryptedFile = this.fileEncryptionService.decrypt(saltKey, userLowerCase, inputStreamTemp, decryptedFile);
            logger.error("END Of try with user lowercase..");
            if (decryptedFile == null) {
                String userUpperCase = null;
                try {
                    userUpperCase = userName.toUpperCase();
                    logger.error("Decryptfile is null so try with user uppercase.." + userUpperCase);
                    decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
                    inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                }
                decryptedFile = this.fileEncryptionService.decrypt(saltKey, userUpperCase, inputStreamTemp, decryptedFile);
                logger.error("END Of try with user uppercase...\t");
            }
            if (decryptedFile == null) {
                List allEncryptionKeys = this.encryptionKeyDao.getAllEncryptionKeys(1, BACKUP);
                if (!CollectionUtils.isEmpty((Collection)allEncryptionKeys)) {
                    for (EncryptionKey encryptionKey : allEncryptionKeys) {
                        String oldSaltKey;
                        saltKey = oldSaltKey = encryptionKey.getSaltKey();
                    }
                }
                logger.error("Decryptfile is null so try with old saltkey.." + saltKey);
                decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
                try {
                    inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
                }
                catch (FileNotFoundException e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                }
                decryptedFile = this.fileEncryptionService.decrypt(saltKey, userName, inputStreamTemp, decryptedFile);
                logger.error("END Of try with user old saltkey....\t");
            }
            if (decryptedFile == null) {
                logger.debug("DEcrypted file is null>>>>> so create new file.....");
                decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
                try {
                    inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
                }
                catch (FileNotFoundException e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                }
                decryptedFile = this.retryWithParentSaltKey(cloudId, cloudName, deviceUUID, restorePath, chunkFile, chunkDetail, userName, inputStreamTemp, decryptedFile);
            }
        }
        if (copyFile.exists()) {
            copyFile.delete();
        }
        try {
            inputStreamTemp.close();
        }
        catch (IOException e) {
            logger.error("couldn't close the input stream....", (Throwable)e);
        }
        return decryptedFile;
    }

    private File copyInputStreamToAFile(String fileName, BufferedInputStream inputStreamTemp, File decryptedDir) {
        String copyPath = decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName + COPY;
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStreamTemp, (File)new File(copyPath));
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
        }
        File copyFile = new File(decryptedDir + "/" + fileName + COPY);
        return copyFile;
    }

    private File createDecryptedDirs(String restorePath) {
        File mergeDir;
        File decryptedDir = new File(restorePath + DECRYPTED);
        if (!decryptedDir.exists()) {
            decryptedDir.mkdir();
        }
        if (!(mergeDir = new File(restorePath + MERGE)).exists()) {
            mergeDir.mkdir();
        }
        return decryptedDir;
    }

    private File getDecryptedFile1(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStreamTemp1, String userName, String restorePath) {
        BufferedInputStream inputStreamTemp = inputStreamTemp1;
        File decryptedDir = this.createDecryptedDirs(restorePath);
        if (inputStreamTemp == null) {
            return null;
        }
        String copyPath = decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName + COPY;
        try {
            if (new File(copyPath).exists()) {
                new File(copyPath).delete();
            }
            FileUtils.copyInputStreamToFile((InputStream)inputStreamTemp, (File)new File(copyPath));
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
        }
        File decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        logger.debug("Before trying with userName normal copy file case>>>>>>" + userName + "decrpted path>>" + decryptedFile.getAbsolutePath());
        File copyFile = new File(decryptedDir + "/" + fileName + COPY);
        try {
            inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
        }
        catch (FileNotFoundException e) {
            logger.debug("FileNotFoundException  :" + e);
            logger.trace("" + e);
            logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
        }
        decryptedFile = this.fileEncryptionService.decrypt(saltKey, userName, inputStreamTemp, decryptedFile);
        logger.debug("END OF trying with userName normal case>>>>>>");
        if (decryptedFile == null) {
            String userLowerCase = userName.toLowerCase();
            logger.error("Decryptfile is null so try with user lowercase...." + userLowerCase);
            decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
            try {
                inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
            }
            catch (FileNotFoundException e) {
                logger.trace("" + e);
                logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
            }
            decryptedFile = this.fileEncryptionService.decrypt(saltKey, userLowerCase, inputStreamTemp, decryptedFile);
            logger.error("END Of try with user lowercase..");
            if (decryptedFile == null) {
                String userUpperCase = userName.toUpperCase();
                logger.error("Decryptfile is null so try with user uppercase.." + userUpperCase);
                decryptedFile = new File(decryptedDir + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
                try {
                    inputStreamTemp = new BufferedInputStream(new FileInputStream(copyFile));
                }
                catch (FileNotFoundException e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_WHILE_GETTING_DECRYPTED_FILE + e.getMessage());
                }
                decryptedFile = this.fileEncryptionService.decrypt(saltKey, userUpperCase, inputStreamTemp, decryptedFile);
                logger.error("END Of try with user uppercase...\t");
            }
            if (copyFile.exists()) {
                copyFile.delete();
            }
            if (decryptedFile == null) {
                logger.debug("DEcrypted file is null>>>>> so create new file.....");
                return null;
            }
        }
        if (copyFile.exists()) {
            copyFile.delete();
        }
        try {
            inputStreamTemp.close();
        }
        catch (IOException e) {
            logger.error("couldn't close the input stream....", (Throwable)e);
        }
        logger.debug("DEcrypted file PATH>>>" + decryptedFile.getAbsolutePath());
        return decryptedFile;
    }

    private long writeDataToStream(File file, com.pg.domain.BackupFile backupFile, HttpServletResponse response, long totalCount, long downloadedCount, String path) throws IOException {
        try {
            int buff;
            logger.debug(downloadedCount + SENDING_FILE + file.getName());
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream fif = new BufferedInputStream(fis);
            logger.debug(BACKUP_FILE_IS_COMPRESSED + backupFile.isCompressed());
            byte[] b = new byte[4096];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
                response.getOutputStream().flush();
            }
            ((InputStream)fif).close();
            logger.debug(file.length() + ".." + FINISHED_FILE + file.getName());
            file.delete();
            logger.debug("deleting  file  under path ....." + file.getPath());
        }
        catch (Exception e) {
            logger.debug("Exception   " + e);
            logger.error("Exception   " + e.getMessage());
        }
        return downloadedCount;
    }

    private void writeDataToStreamForPg(FileInfo fileInfo, HttpServletResponse response, InputStream fif, String fileName) throws IOException {
        int buff;
        InputStream fifTemp = fif;
        logger.debug(SENDING_FILE + fileName);
        logger.debug(BACKUP_FILE_IS_COMPRESSED + fileInfo.isCompressed());
        byte[] b = new byte[4096];
        while ((buff = fifTemp.read(b)) != -1) {
            response.getOutputStream().write(b, 0, buff);
            response.getOutputStream().flush();
        }
        fifTemp.close();
        logger.debug(FINISHED_FILE + fileName);
    }

    private void deleteFilesUnderMergeAndDecrypt(String path, String restoreId) {
        String mergePath = path + MERGE;
        String decryptedPath = path + DECRYPTED;
        logger.debug(mergePath + "...path.." + decryptedPath);
        File mergeFolder = new File(mergePath);
        File decryptedFolder = new File(decryptedPath);
        if (mergeFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)mergeFolder);
        }
        if (decryptedFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)decryptedFolder);
        }
        logger.debug("..restoreid ..." + restoreId);
        if (!StringUtils.isEmpty((String)restoreId)) {
            mergePath = path + restoreId + "/" + MERGE;
            decryptedPath = path + restoreId + "/" + DECRYPTED;
            logger.debug(mergePath + "...restorepath.." + decryptedPath);
            mergeFolder = new File(mergePath);
            decryptedFolder = new File(decryptedPath);
            if (mergeFolder.exists()) {
                ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)mergeFolder);
            }
            if (decryptedFolder.exists()) {
                ResourceFileHelper.deleteAllChildFilesExcludingDirectories((File)decryptedFolder);
            }
        }
    }

    private File bruteForceRestoreFromCloud(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKey, String folderPath, String fileName, PciAuthorizationTokenElement element, String restorePath, Device device, FileStatusElement fileStatusElement) {
        String saltKeyTemp = saltKey;
        int cloudId = cloud.getCloudId();
        File decryptedFile = null;
        logger.debug("FORCE RESTORE STARTS");
        BufferedInputStream inputStream = null;
        String folderPathTemp = backupFile.getFilePath();
        String fileNameTemp = backupFile.getFileName();
        List backupFiles = this.externalStorageBackupFileDao.getBackupFilesForGivenPathAndFileName(cloudId, cloudName, userName, folderPathTemp, fileNameTemp);
        if (CollectionUtils.isEmpty((Collection)backupFiles)) {
            logger.error(" backup files list is empty .......");
            return null;
        }
        String firstRevisionBackupId = new String();
        Map<String, List<ChunkFile>> firstRevisionChunks = this.getFirstRevisionFromExternalStorageTable(cloudName, userName, folderPathTemp, fileNameTemp, backupFiles, firstRevisionBackupId);
        if (firstRevisionChunks != null) {
            firstRevisionBackupId = firstRevisionChunks.keySet().toArray()[0].toString();
        }
        List<ChunkFile> backupChunkFileList = firstRevisionChunks.get(firstRevisionBackupId);
        com.pg.domain.ChunkFile chunkFile2 = new com.pg.domain.ChunkFile();
        logger.debug("FirstVersion backup Iddd>>" + firstRevisionBackupId);
        for (ChunkFile chunkFile : backupChunkFileList) {
            block15: {
                try {
                    BeanUtils.copyProperties((Object)chunkFile, (Object)chunkFile2);
                    ChunkDetail chunkDetail = new ChunkDetail();
                    BeanUtils.copyProperties((Object)chunkFile, (Object)chunkDetail);
                    String fileNameToDownload = chunkFile.getFileName() + "." + firstRevisionBackupId;
                    logger.debug(" BEFORE DOWNLOADING Chunks file for BruteForce >>>>>> " + fileNameToDownload);
                    logger.debug("File Download from BLOB...........");
                    inputStream = this.downloadFileFromCloud(cloud, restorePath, fileNameToDownload, userName.toLowerCase(), cloudName, backupFile.getDeviceUUID(), element, chunkFile2, backupFile, userName.toLowerCase(), userName.toLowerCase(), chunkDetail, fileStatusElement);
                }
                catch (ParacloudBackupException e) {
                    logger.trace("" + (Object)((Object)e));
                    logger.error("THE error code is>>>>>>>>>>" + e.getResponseCode());
                    if (e.getResponseCode() != 404) break block15;
                    nameList.clear();
                    try {
                        this.searchReplicaAndRestore(cloud, cloudName, userName, backupFile, nameList, saltKeyTemp, fileNameTemp, folderPathTemp, element, restorePath, device, fileStatusElement);
                    }
                    catch (ParacloudBackupException backupException) {
                        logger.debug("Exception : " + (Object)((Object)backupException));
                        logger.debug(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + backupException.getMessage());
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        logger.trace("" + e1);
                        logger.error(EXCEPTION_WHILE_BRUTE_FORCE_RESTORE_FROM_CLOUD + e1.getMessage());
                    }
                    return null;
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error(EXCEPTION_WHILE_BRUTE_FORCE_RESTORE_FROM_CLOUD + e.getMessage());
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e1) {
                        logger.trace("" + e1);
                        logger.error(EXCEPTION_WHILE_BRUTE_FORCE_RESTORE_FROM_CLOUD + e1.getMessage());
                    }
                    logger.debug(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                    throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                }
            }
            saltKeyTemp = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), BACKUP);
            if (saltKeyTemp == null) {
                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
            }
            decryptedFile = this.getDecryptedFile(cloudName, saltKeyTemp, backupFile.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, restorePath, chunkFile2, cloudId, null);
            nameList.add(chunkFile.getFileName());
        }
        return decryptedFile;
    }

    private Map<String, List<ChunkFile>> getFirstRevisionFromExternalStorageTable(String cloudName, String userName, String folderPath, String fileName, List<BackupFile> backupFiles, String firstversionBackupId) {
        HashMap<String, List<ChunkFile>> firstRevisionsChunks = new HashMap<String, List<ChunkFile>>();
        logger.debug("BACKUP FILE LIST SIZE" + backupFiles.size());
        HashMap<String, List> fileRevisionsList = new HashMap<String, List>();
        HashMap<Long, String> chunkListWithTimstamp = new HashMap<Long, String>();
        if (!CollectionUtils.isEmpty(backupFiles)) {
            for (BackupFile backupFile : backupFiles) {
                if (backupFile == null) continue;
                logger.debug("TimeStamp>>>>>>>" + ((ChunkFile)backupFile.getChunkFiles().get(0)).getUploadedTimeStamp());
                chunkListWithTimstamp.put(((ChunkFile)backupFile.getChunkFiles().get(0)).getUploadedTimeStamp(), backupFile.getId().toString());
                fileRevisionsList.put(backupFile.getId().toString(), backupFile.getChunkFiles());
            }
            Map<Long, String> chunkListWithTimstampInOrder = DownloadServiceImpl.sortByComparator(chunkListWithTimstamp);
            Object myKey = chunkListWithTimstampInOrder.keySet().toArray()[0];
            logger.debug("TimeStamp AFTER SORTING>>>>>>>" + myKey.toString());
            String firstversionBackupIdTemp = chunkListWithTimstampInOrder.get(myKey);
            logger.debug("BackupId AFTER SORTING>>>>>>>" + firstversionBackupIdTemp);
            List backupChunkFileList = (List)fileRevisionsList.get(firstversionBackupIdTemp);
            firstRevisionsChunks.put(firstversionBackupIdTemp, backupChunkFileList);
        }
        return firstRevisionsChunks;
    }

    private static Map<Long, String> sortByComparator(Map<Long, String> unsortMap) {
        LinkedList<Map.Entry<Long, String>> list = new LinkedList<Map.Entry<Long, String>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Long, String>>(){

            @Override
            public int compare(Map.Entry<Long, String> o1, Map.Entry<Long, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        LinkedHashMap<Long, String> sortedMap = new LinkedHashMap<Long, String>();
        for (Map.Entry entry : list) {
            sortedMap.put((Long)entry.getKey(), (String)entry.getValue());
        }
        return sortedMap;
    }

    private File searchReplicaAndRestore(Cloud cloud, String cloudName, String userName, com.pg.domain.BackupFile backupFile, List<String> nameList, String saltKey, String fileName, String folderPath, PciAuthorizationTokenElement element, String restorePath, Device device, FileStatusElement fileStatusElement) {
        String saltKeyTemp = saltKey;
        com.pg.domain.BackupFile backupFileTemp = backupFile;
        int cloudId = cloud.getCloudId();
        logger.debug("GET THE PARENT FILE AND RESTORE");
        File decryptedFile = null;
        BackUpImage list = this.backUpImageDao.getBackupFileForID(cloudId, backupFileTemp.getBackupId(), userName, device);
        if (list != null) {
            logger.debug("GET THE PARENT FILE AND RESTORE BACKUP IMAGE NOT NULL>>" + list.getId());
            backupFileTemp = this.getBackupFileFromDB(cloudName, userName, list.getId().toString());
            if (backupFileTemp != null) {
                BufferedInputStream inputStream = null;
                for (com.pg.domain.ChunkFile chunkFile : backupFileTemp.getChunkFiles()) {
                    try {
                        ChunkDetail chunkDetail = new ChunkDetail();
                        BeanUtils.copyProperties((Object)chunkFile, (Object)chunkDetail);
                        StringBuilder fileNameToDownload = new StringBuilder(chunkFile.getFileName());
                        int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                        if (occurance == 0) {
                            fileNameToDownload.append(".").append(backupFileTemp.getBackupId().toString());
                        } else if (occurance == 1 && backupFileTemp.getChunkFiles().size() > 1) {
                            decryptedFile = this.bruteForceRestoreFromCloud(cloud, cloudName, userName, backupFileTemp, nameList, saltKeyTemp, fileName, folderPath, element, restorePath, device, fileStatusElement);
                            return decryptedFile;
                        }
                        logger.debug(" BEFORE DOWNLOADING Chunks file for REPLICA >>>>>> " + fileNameToDownload);
                        logger.debug("File Download from BLOB...........");
                        inputStream = this.downloadFileFromCloud(cloud, restorePath, fileNameToDownload.toString(), userName.toLowerCase(), cloudName, backupFileTemp.getDeviceUUID(), element, chunkFile, backupFileTemp, userName.toLowerCase(), userName.toLowerCase(), chunkDetail, fileStatusElement);
                    }
                    catch (Exception e) {
                        logger.trace("" + e);
                        logger.error(EXCEPTION_WHILE_SEARCHING_FOR_REPLICA_AND_RESTORE + e.getMessage());
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException e1) {
                            logger.trace("" + e1);
                            logger.error(EXCEPTION_WHILE_SEARCHING_FOR_REPLICA_AND_RESTORE + e1.getMessage());
                        }
                        logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH + e.getMessage());
                        throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                    }
                    try {
                        saltKeyTemp = this.getEncryptOrDecryptKey(cloudId, chunkFile.getUploadedTimeStamp(), BACKUP);
                        if (saltKeyTemp == null) {
                            throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR_WHILE_GET_DECRYPT_KEY, 400);
                        }
                        decryptedFile = this.getDecryptedFile(cloudName, saltKeyTemp, backupFileTemp.getDeviceUUID(), chunkFile.getFileName(), inputStream, userName, restorePath, chunkFile, cloudId, null);
                        nameList.add(chunkFile.getFileName());
                    }
                    catch (Exception e) {
                        logger.trace("" + e);
                        logger.error(EXCEPTION_WHILE_SEARCHING_FOR_REPLICA_AND_RESTORE + e.getMessage());
                    }
                }
            } else {
                throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
            }
        }
        return decryptedFile;
    }

    private com.pg.domain.BackupFile getBackupFileFromDB(String cloudName, String userName, String backupId) {
        BackupFile file = this.externalStorageBackupFileDao.getBackupFile(1, cloudName, userName, backupId);
        com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
        ArrayList<com.pg.domain.ChunkFile> chunkList = new ArrayList<com.pg.domain.ChunkFile>();
        for (ChunkFile chunkFile : file.getChunkFiles()) {
            com.pg.domain.ChunkFile newChunkFile = new com.pg.domain.ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)newChunkFile);
            chunkList.add(newChunkFile);
        }
        BeanUtils.copyProperties((Object)file, (Object)backupFile);
        backupFile.setBackupId(file.getId());
        backupFile.getChunkFiles().clear();
        backupFile.getChunkFiles().addAll(chunkList);
        return backupFile;
    }

    private BufferedInputStream downloadFileFromCloud(Cloud cloud, String restorePathDir, String fileNameToDownload, String userName, String cloudName, String deviceUUID, PciAuthorizationTokenElement pciAuthorizationTokenElement, com.pg.domain.ChunkFile chunkFile, com.pg.domain.BackupFile backupFile, String containerName, String folderName, ChunkDetail chunkDetail, FileStatusElement fileStatusElement) {
        logger.debug(fileStatusElement.getDriveId() + ":drive id downloading files using cloudsupport service  >>>>>> " + fileNameToDownload + "...in container..." + containerName);
        com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
        BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
        BufferedInputStream inputStream = this.cloudSupportService.downloadFile(cloud, restorePathDir, fileNameToDownload, userName, deviceUUID, containerName, pgChunkFile, false, backupFile, fileStatusElement, folderName, chunkDetail, fileStatusElement.getDriveId());
        return inputStream;
    }

    private com.pg.domain.BackupFile convertBkpImageToBackupFile(BackUpImage backUpImage) {
        com.pg.domain.BackupFile backupFile = new com.pg.domain.BackupFile();
        if (backUpImage == null || CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) {
            return null;
        }
        BeanUtils.copyProperties((Object)backUpImage, (Object)backupFile);
        backupFile.setBackupId(backUpImage.getId());
        backupFile.setFilePath(backUpImage.getDevicePath());
        if (backUpImage.getAccessTime() != 0L) {
            backupFile.setAccessTime(Long.valueOf(backUpImage.getAccessTime()));
        }
        List list = backUpImage.getChunkFiles();
        ArrayList<com.pg.domain.ChunkFile> pgChunkFiles = new ArrayList<com.pg.domain.ChunkFile>();
        for (ChunkFile chunkFile : list) {
            com.pg.domain.ChunkFile pgChunk = new com.pg.domain.ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunk);
            pgChunkFiles.add(pgChunk);
        }
        backupFile.setUploadedTimestamp(Long.valueOf(backUpImage.getLastClientModifiedTime()));
        backupFile.setChunkFiles(new ArrayList());
        backupFile.setChunkFiles(pgChunkFiles);
        return backupFile;
    }

    private void sendEmptyContents(HttpServletResponse response) throws IOException {
        response.getOutputStream().write("file is not in pg".getBytes());
        response.getOutputStream().flush();
    }

    private static String getBackupIdFromFileName(String fileName, int occurance) {
        String backupId = "";
        if (occurance == 1 && !fileName.startsWith("part000")) {
            backupId = fileName.substring(fileName.lastIndexOf(46) + 1);
        } else if (occurance > 1) {
            backupId = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        }
        return backupId;
    }

    private void downloadFromCloudForPortal(com.pg.domain.BackupFile backupFileTemp, DownloadFileTO downloadFileTO, HttpServletResponse response, Cloud cloud, String browserType, Device device) {
        String saltKey = null;
        com.pg.domain.BackupFile backupFile = backupFileTemp;
        String cloudName = downloadFileTO.getCloudName();
        String userName = downloadFileTO.getUserName();
        String deviceUUID = downloadFileTO.getDeviceUUID();
        String fileName = backupFile.getFileName();
        boolean isSync = downloadFileTO.isSync();
        if (!StringUtils.isEmpty((String)backupFile.getDedupBackupId()) && isSync) {
            backupFile = this.utilService.getSyncFile(1, cloudName, userName, backupFile.getDedupBackupId());
        }
        ArrayList<String> nameList = new ArrayList<String>();
        logger.debug(backupFile.isMail() + " BEFORE DOWNLOADING File  >>>>>> " + fileName + "bowser type " + browserType);
        String encodedFilename = fileName;
        if (backupFile.isMail()) {
            fileName = fileName + ".eml";
        }
        logger.debug("...usernames..." + backupFile.getUserName() + "..." + userName);
        if (!StringUtils.isEmpty((String)backupFile.getUserName()) && !userName.equalsIgnoreCase(backupFile.getUserName())) {
            userName = backupFile.getUserName();
        }
        logger.debug("...after usernames..." + backupFile.getUserName() + "..." + userName);
        if (!StringUtils.isEmpty((String)downloadFileTO.getAttachmentId())) {
            logger.debug("... downaloding attachment .... ");
            BackUpImage backUpImage = this.backUpImageDao.getBackupFileForID(cloud.getCloudId(), backupFile.getBackupId(), userName, device);
            Long filesize = backUpImage.getSize();
            List attlist = backUpImage.getAttachments();
            String fileInfoFileName = backUpImage.getFileName();
            String chunk = "";
            MailAttachment attachmentOrg = null;
            for (MailAttachment attachment : attlist) {
                if (!attachment.getId().equalsIgnoreCase(downloadFileTO.getAttachmentId())) continue;
                fileInfoFileName = attachment.getName();
                chunk = (String)attachment.getChunkFiles().get(0);
                if (attachment.getSize() != null) {
                    filesize = (long)attachment.getSize();
                }
                attachmentOrg = attachment;
            }
            logger.debug(chunk + "....trying to download attachment  name..." + fileInfoFileName);
            ArrayList<String> list = new ArrayList<String>();
            list.add(chunk);
            Collections.sort(list);
            response.addHeader("Pragma", "public");
            response.addHeader("Expires", String.valueOf(200));
            response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            encodedFilename = fileInfoFileName;
            try {
                encodedFilename = URLEncoder.encode(fileInfoFileName, UTF8).replace("+", "%20");
                if (browserType.contains("Firefox")) {
                    response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFilename);
                } else if (browserType.contains("Chrome")) {
                    response.setHeader("Content-Disposition", "attachment; filename=" + encodedFilename);
                } else {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + fileInfoFileName + "\"");
                }
                response.addHeader("Content-Transfer-Encoding", "binary");
                response.addHeader("filename", fileInfoFileName);
                response.addHeader("Content-Transfer-Encodingsdasda", "binary");
                response.setContentType("application/octet-stream");
                this.syncDownloadService.downloadFileFromCloudForPortalForAttachment(cloud, cloudName, userName, backUpImage, nameList, saltKey, response, isSync, attachmentOrg);
            }
            catch (UnsupportedEncodingException e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
        } else {
            try {
                response.addHeader("Pragma", "public");
                response.addHeader("Expires", String.valueOf(200));
                response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                encodedFilename = URLEncoder.encode(fileName, UTF8).replace("+", "%20");
                if (browserType.contains("Firefox") || browserType.contains("Chrome")) {
                    response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFilename);
                } else {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                }
                response.addHeader("Content-Transfer-Encoding", "binary");
                if (isSync) {
                    response.addHeader("Content-Length", String.valueOf(backupFile.getSize()));
                } else if (backupFile.getSizeInBytes() != null && backupFile.getSizeInBytes() != 0L) {
                    response.addHeader("Content-Length", String.valueOf(backupFile.getSizeInBytes()));
                } else {
                    response.addHeader("Content-Length", String.valueOf((backupFile.getSize() + 1L) * 1024L));
                }
                response.addHeader("filename", fileName);
                response.addHeader("Content-Transfer-Encodingsdasda", "binary");
                response.setContentType("application/octet-stream");
                boolean fileExists = true;
                fileExists = this.syncDownloadService.downloadFileFromCloudForPortal(cloud, cloudName, userName, backupFile, nameList, saltKey, response, fileExists, isSync);
                if (!fileExists && downloadFileTO.isSync()) {
                    nameList = new ArrayList();
                    logger.debug(" portal .. try parent file for md5..........");
                    com.pg.domain.BackupFile backupFileObj = this.syncFileDao.getSyncFileForMd5(1, cloudName, userName, deviceUUID, backupFile.getMd5());
                    if (backupFileObj != null) {
                        logger.debug(" portal .. parent file for md5 exists ..........");
                        this.syncDownloadService.downloadFileFromCloudForPortal(cloud, cloudName, userName, backupFileObj, nameList, saltKey, response, fileExists, isSync);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
            logger.debug(backupFile.getSize() + "..bytes.." + backupFile.getSizeInBytes() + " After DOWNLOADING File  >>>>>> " + backupFile.getFileName());
        }
    }

    public byte[] downloadFromCloudContactsPhotoForPortal(com.pg.domain.BackupFile backupFileTemp, DownloadFileTO downloadFileTO, Cloud cloud, String browserType, Device device) {
        byte[] bytearr = null;
        String saltKey = null;
        com.pg.domain.BackupFile backupFile = backupFileTemp;
        String cloudName = downloadFileTO.getCloudName();
        String userName = downloadFileTO.getUserName();
        String deviceUUID = downloadFileTO.getDeviceUUID();
        String fileName = backupFile.getFileName();
        boolean isSync = downloadFileTO.isSync();
        if (!StringUtils.isEmpty((String)backupFile.getDedupBackupId()) && isSync) {
            backupFile = this.utilService.getSyncFile(1, cloudName, userName, backupFile.getDedupBackupId());
        }
        ArrayList<String> nameList = new ArrayList<String>();
        logger.debug(backupFile.isMail() + " BEFORE DOWNLOADING File  >>>>>> " + fileName + "bowser type " + browserType);
        String encodedFilename = fileName;
        if (backupFile.isMail()) {
            fileName = fileName + ".eml";
        }
        if (!StringUtils.isEmpty((String)downloadFileTO.getAttachmentId())) {
            logger.debug("... downaloding attachment .... ");
            BackUpImage backUpImage = this.backUpImageDao.getBackupFileForID(cloud.getCloudId(), backupFile.getBackupId(), userName, device);
            Long filesize = backUpImage.getSize();
            List attlist = backUpImage.getAttachments();
            String fileInfoFileName = backUpImage.getFileName();
            String chunk = "";
            MailAttachment attachmentOrg = null;
            for (MailAttachment attachment : attlist) {
                if (!attachment.getId().equalsIgnoreCase(downloadFileTO.getAttachmentId())) continue;
                fileInfoFileName = attachment.getName();
                chunk = (String)attachment.getChunkFiles().get(0);
                if (attachment.getSize() != null) {
                    filesize = (long)attachment.getSize();
                }
                attachmentOrg = attachment;
            }
            logger.debug(chunk + "....trying to download attachment  name..." + fileInfoFileName);
            ArrayList<String> list = new ArrayList<String>();
            list.add(chunk);
            Collections.sort(list);
            encodedFilename = fileInfoFileName;
            try {
                encodedFilename = URLEncoder.encode(fileInfoFileName, UTF8).replace("+", "%20");
                return this.syncDownloadService.downloadFromCloudContactsPhotoForPortal(cloud, cloudName, userName, backUpImage, nameList, saltKey, isSync, attachmentOrg);
            }
            catch (UnsupportedEncodingException e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
        }
        return bytearr;
    }

    @Override
    public File getDecryptedFileForPortal(String cloudName, String saltKey, String deviceUUID, String fileName, BufferedInputStream inputStream, String userName, String deccryptPath, com.pg.domain.ChunkFile chunkFile, int cloudId, ChunkDetail chunkDetail) {
        return this.getDecryptedFile(cloudName, saltKey, deviceUUID, fileName, inputStream, userName, deccryptPath, chunkFile, cloudId, chunkDetail);
    }

    private boolean isGDEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isGDEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"Google Drive Enabled".equalsIgnoreCase(license.getName())) continue;
            isGDEnabled = true;
            break;
        }
        return isGDEnabled;
    }

    private String getEncodedFileName(boolean isEncodedEnabled, String fileName) {
        String fileNameInHeader = FILE_NAME + fileName;
        try {
            if (isEncodedEnabled) {
                fileNameInHeader = FILE_NAME + this.encodeUTFBase64(fileName);
                return fileNameInHeader;
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("" + e);
        }
        return fileNameInHeader;
    }

    private String getEncodedFilePath(boolean isEncodedEnabled, String filePath) {
        String filePathInHeader = FILE_PATH + filePath;
        try {
            if (isEncodedEnabled) {
                filePathInHeader = FILE_PATH + this.encodeUTFBase64(filePath);
                return filePathInHeader;
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("" + e);
        }
        return filePathInHeader;
    }

    protected String encodeUTFBase64(String input) {
        try {
            return Base64.encodeBase64String((byte[])input.getBytes(UTF8));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
            return input;
        }
    }

    DownloadTO downloadZipFileFromCloudForPortal(DownloadFileTO downloadFileTO, HttpServletResponse response, Cloud cloud, String browserType, DownloadTO downloadTO, Device device) {
        try {
            this.downloadZipFileFromCloudForPortal(cloud, response, downloadFileTO, downloadTO, device);
        }
        catch (Exception e) {
            logger.error("Exception" + e.getMessage());
        }
        return downloadTO;
    }

    private void downloadZipFileFromCloudForPortal(Cloud cloud, HttpServletResponse response, DownloadFileTO downloadFileTO, DownloadTO downloadTO, Device device) {
        String deviceUUID = downloadFileTO.getDeviceUUID();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        String userName = downloadFileTO.getUserName();
        String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        long currentMills = System.currentTimeMillis();
        String restorePath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + currentMills + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File restoreFolderPath = new File(restorePath);
        if (!restoreFolderPath.exists()) {
            restoreFolderPath.mkdirs();
        }
        String devicePath = downloadFileTO.getFileName();
        logger.debug(devicePath + "Restore folder path is create :" + restoreFolderPath);
        try {
            long folderSize = 0L;
            ArrayList<BackUpImage> backupImageList = new ArrayList<BackUpImage>();
            BackUpImage backupImage = this.externalStorageBackupFileDao.getBackupFileById(cloudId, device, downloadFileTO.getBackupID());
            if (backupImage != null) {
                backupImageList.add(backupImage);
            }
            logger.debug("....backupImage..." + backupImage.getId());
            ArrayList<BackUpImage> backupImages = new ArrayList<BackUpImage>();
            if (!StringUtils.isEmpty((String)backupImage.getDevicePath())) {
                logger.debug("....backupImage devicepath not empty..." + backupImage.getDevicePath());
                this.getAllFolderChildrenByDevicePath(cloudName, userName, backupImage.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImage.getFileName(), device, cloudId, backupImages);
            } else {
                logger.debug("....backupImage devicepath  empty..." + backupImage.getFileName());
                this.getAllFolderChildrenByDevicePath(cloudName, userName, backupImage.getFileName(), device, cloudId, backupImages);
            }
            backupImageList.addAll(backupImages);
            logger.debug("...first Size..." + backupImageList.size());
            if (!CollectionUtils.isEmpty(backupImageList)) {
                for (BackUpImage backupImagedata : backupImageList) {
                    ArrayList<BackUpImage> backupImagesFolderFile = new ArrayList();
                    if (StringUtils.isNotEmpty((String)backupImagedata.getDevicePath())) {
                        logger.debug("....backupImagedata non empty..." + backupImage.getFileName());
                        backupImagesFolderFile = this.externalStorageBackupFileDao.getBackupFilesForBasePath(cloudId, cloudName, userName, device, backupImagedata.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImagedata.getFileName());
                    } else {
                        logger.debug(backupImagedata.getFileName() + "....backupImagedata  empty..." + backupImage.getFileName());
                        backupImagesFolderFile = this.externalStorageBackupFileDao.getBackupFilesForBasePath(cloudId, cloudName, userName, device, backupImage.getFileName());
                        logger.debug("...devuse..." + device.getDeviceUUID() + "...." + userName + "...." + backupImage.getFileName());
                        for (BackUpImage img : backupImagesFolderFile) {
                            logger.debug("...path and file..." + img.getDevicePath() + "..." + img.getFileName());
                        }
                    }
                    if (CollectionUtils.isEmpty(backupImagesFolderFile)) continue;
                    folderSize = this.restoreBackupFolder(cloud, response, downloadFileTO, deviceUUID, path, tempdownloadDir, backupImagesFolderFile, folderSize, restorePath);
                }
            }
            downloadTO.setSize(folderSize);
            logger.debug("Completed ....." + folderSize);
            String fullyQualifiedPath = path + devicePath + ".zip";
            ZipUtil.pack((File)new File(restorePath), (File)new File(fullyQualifiedPath));
            logger.debug("Path..." + path);
            logger.debug(new File(fullyQualifiedPath).length() + "...file length....");
            downloadTO.setPath(fullyQualifiedPath);
            try {
                logger.debug(new File(restorePath).length() + ".....restore...");
                FileUtils.deleteDirectory((File)new File(restorePath));
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error(" error trying to delete dir ...." + e.getMessage());
            }
            logger.debug("..full path...." + fullyQualifiedPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception" + e.getMessage());
            logger.trace("Exception" + e);
        }
    }

    @Override
    public void getAllFolderChildrenByDevicePath(String cloudName, String userName, String filePath, Device device, int cloudId, List<BackUpImage> backupImages) {
        List backUpImagesTemp = this.externalStorageBackupFileDao.getBackupFolderForBasePath(cloudId, cloudName, userName, device, filePath);
        backupImages.addAll(backUpImagesTemp);
        logger.debug("...folders for path ....." + filePath + "..." + backupImages.size());
        if (!CollectionUtils.isEmpty((Collection)backUpImagesTemp)) {
            Stream stream = backUpImagesTemp.parallelStream();
            stream.forEach(backUpImage -> {
                String devicePath = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                logger.debug("Inside loop after getting folders..bkpimages list size:" + backUpImagesTemp.size());
                if (StringUtils.isEmpty((String)backUpImage.getDevicePath())) {
                    devicePath = backUpImage.getFileName();
                }
                logger.debug("Inside loop to get immediate folders deevicePath:" + devicePath);
                this.getAllFolderChildrenByDevicePath(cloudName, userName, devicePath, device, cloudId, backupImages);
            });
        }
    }

    @Override
    public void getAllFolderChildrenByDevicePathLatest(String cloudName, String userName, String filePath, Device device, int cloudId, List<RestoreBackUpImage> backupImages) {
        List backUpImagesTemp = this.externalStorageBackupFileDao.getBackupFolderForBasePathLatest(cloudId, cloudName, userName, device, filePath);
        backupImages.addAll(backUpImagesTemp);
        logger.debug("...folders for path ....." + filePath + "..." + backupImages.size());
        if (!CollectionUtils.isEmpty((Collection)backUpImagesTemp)) {
            Stream stream = backUpImagesTemp.parallelStream();
            stream.forEach(backUpImage -> {
                String devicePath = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                logger.debug("Inside loop after getting folders..bkpimages list size:" + backUpImagesTemp.size());
                if (StringUtils.isEmpty((String)backUpImage.getDevicePath())) {
                    devicePath = backUpImage.getFileName();
                }
                logger.debug("Inside loop to get immediate folders deevicePath:" + devicePath);
                this.getAllFolderChildrenByDevicePathLatest(cloudName, userName, devicePath, device, cloudId, backupImages);
            });
        }
    }

    private long restoreBackupFolder(Cloud cloud, HttpServletResponse response, DownloadFileTO downloadFileTO, String deviceUUID, String path, File tempdownloadDir, List<BackUpImage> backupImages, long folderSize, String restoreFolderPath) {
        ArrayList<com.pg.domain.BackupFile> backupFiles = new ArrayList<com.pg.domain.BackupFile>();
        ArrayList<com.pg.domain.BackupFile> backupFilesForPg = new ArrayList<com.pg.domain.BackupFile>();
        long zipFileSize = 0L;
        logger.debug("restoreBackupFolder Size..." + backupImages.size());
        for (BackUpImage backupImage : backupImages) {
            com.pg.domain.BackupFile backupFileData = new com.pg.domain.BackupFile();
            if (StringUtils.isNotEmpty((String)backupImage.getStoragePlace()) && backupImage.getStoragePlace().equalsIgnoreCase("CLOUD") && !CollectionUtils.isEmpty((Collection)backupImage.getChunkFiles())) {
                this.convertBackupImageToBackupFile(backupImage, backupFileData);
                backupFiles.add(backupFileData);
                zipFileSize += backupImage.getSize();
            } else {
                this.convertBackupImageToBackupFile(backupImage, backupFileData);
                backupFileData.setId(backupImage.getId().toString());
                backupFilesForPg.add(backupFileData);
                zipFileSize += backupImage.getSize();
            }
            if (backupImage.getSizeInBytes() != 0L) {
                folderSize += backupImage.getSizeInBytes();
                continue;
            }
            folderSize += backupImage.getSize();
        }
        zipFileSize += zipFileSize;
        logger.debug("total size required create zip " + zipFileSize);
        this.restoreBackupFolder(cloud, response, downloadFileTO, deviceUUID, path, tempdownloadDir, backupFiles, backupFilesForPg, restoreFolderPath);
        return folderSize;
    }

    @Override
    public DownloadTO downloadBackupFileForPortal(DownloadFileTO downloadFileTO, Cloud cloud, String cloudName, HttpServletResponse response, String browserType) {
        FileInfo fileInfo = null;
        com.pg.domain.BackupFile backupFile = null;
        String userName = downloadFileTO.getUserName();
        DownloadTO downloadTO = new DownloadTO("");
        boolean isSync = false;
        int cloudId = cloud.getCloudId();
        String deviceUUID = downloadFileTO.getDeviceUUID();
        if (StringUtils.isEmpty((String)deviceUUID)) {
            deviceUUID = this.backupFileDao.getDeviceUUIDForId(cloudId, cloudName, userName, downloadFileTO.getBackupID());
        }
        logger.debug(downloadFileTO.getBackupID() + " backup id @@@@@ device uuid .... " + deviceUUID);
        if (deviceUUID != null) {
            downloadFileTO.setDeviceUUID(deviceUUID);
        }
        Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
        if (!StringUtils.isEmpty((String)downloadFileTO.getBackupID())) {
            backupFile = this.backupFileDao.getBackupFilesForId(cloudId, cloudName, userName, device, downloadFileTO.getBackupID());
        }
        if (backupFile == null || CollectionUtils.isEmpty((Collection)backupFile.getChunkFiles())) {
            logger.debug("..download fromPG...");
            fileInfo = this.fileDao.getFileFromPG(userName, cloudName, downloadFileTO.getBackupID(), isSync);
            this.syncDownloadService.downloadFileFromPGForPortal(cloud, response, fileInfo, browserType, downloadFileTO.getAttachmentId(), userName, backupFile);
        }
        if (backupFile != null && !StringUtils.isEmpty((String)backupFile.getFileName()) && !StringUtils.isEmpty((String)backupFile.getFilePath())) {
            downloadTO.setFilePath(backupFile.getFilePath());
            downloadTO.setFileName(backupFile.getFileName());
        }
        if (fileInfo != null) {
            downloadTO.setSize(fileInfo.getSize().longValue());
            downloadTO.setFilePath(fileInfo.getFilePath());
            downloadTO.setFileName(fileInfo.getFileName());
            return downloadTO;
        }
        if (backupFile == null) {
            logger.debug(FILE_NOT_FOUND + downloadFileTO.getBackupID());
            throw new ParacloudBackupException(FILE_NOT_FOUND, 507);
        }
        if (backupFile.getSizeInBytes() != null && backupFile.getSizeInBytes() != 0L) {
            downloadTO.setSize(backupFile.getSizeInBytes().longValue());
        } else {
            downloadTO.setSize(backupFile.getSize().longValue());
        }
        this.downloadFromCloudForPortal(backupFile, downloadFileTO, response, cloud, browserType, device);
        return downloadTO;
    }

    @Override
    public byte[] downloadContactsPhotoForPortal(DownloadFileTO downloadFileTO, Cloud cloud, String cloudName, String browserType) {
        Object fileInfo = null;
        com.pg.domain.BackupFile backupFile = null;
        String userName = downloadFileTO.getUserName();
        DownloadTO downloadTO = new DownloadTO("");
        boolean isSync = false;
        int cloudId = cloud.getCloudId();
        String deviceUUID = this.backupFileDao.getDeviceUUIDForId(cloudId, cloudName, userName, downloadFileTO.getBackupID());
        logger.debug(downloadFileTO.getBackupID() + " backup id @@@@@ device uuid .... " + deviceUUID);
        if (deviceUUID != null) {
            downloadFileTO.setDeviceUUID(deviceUUID);
        }
        Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
        if (!StringUtils.isEmpty((String)downloadFileTO.getBackupID())) {
            backupFile = this.backupFileDao.getBackupFilesForId(cloudId, cloudName, userName, device, downloadFileTO.getBackupID());
        }
        if (backupFile == null) {
            logger.debug(FILE_NOT_FOUND + downloadFileTO.getBackupID());
            throw new ParacloudBackupException(FILE_NOT_FOUND, 507);
        }
        if (backupFile.getSizeInBytes() != null && backupFile.getSizeInBytes() != 0L) {
            downloadTO.setSize(backupFile.getSizeInBytes().longValue());
        } else {
            downloadTO.setSize(backupFile.getSize().longValue());
        }
        return this.downloadFromCloudContactsPhotoForPortal(backupFile, downloadFileTO, cloud, browserType, device);
    }

    private void restoreBackupFolder(Cloud cloud, HttpServletResponse response1, DownloadFileTO downloadFileTO, String deviceUUID, String path, File tempdownloadDir, List<com.pg.domain.BackupFile> backupFiles, List<com.pg.domain.BackupFile> backupFilesForPg, String restoreFolderPath) {
        String saltKeyTemp = "";
        String userName = downloadFileTO.getUserName();
        logger.debug("backupFilesForPg  " + backupFilesForPg.size());
        for (com.pg.domain.BackupFile backupFilePg : backupFilesForPg) {
            FileInfo fileInfo = this.fileDao.getFileFromPG(downloadFileTO.getUserName(), cloud.getCloudName(), backupFilePg.getId(), false);
            if (fileInfo == null) continue;
            fileInfo.setFilePath(backupFilePg.getFilePath());
            String filePath = fileInfo.getFilePath();
            filePath = filePath.replace("\\", "/");
            fileInfo.setFilePath(filePath);
            this.downloadZipFileFromPGForPortal(cloud.getCloudName(), response1, fileInfo, downloadFileTO, restoreFolderPath);
        }
        logger.debug(".....SIZE...." + backupFiles.size());
        block21: for (com.pg.domain.BackupFile backupFile : backupFiles) {
            if (StringUtils.isEmpty((String)userName)) {
                logger.debug("...emptry username so assign diffe from file...." + backupFile.getUserName());
                userName = backupFile.getUserName();
            }
            String folderPath = "";
            String replaceValue = "";
            if (StringUtils.isNotEmpty((String)downloadFileTO.getFilePath())) {
                folderPath = downloadFileTO.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            } else {
                folderPath = ":";
                replaceValue = "_DRIVE";
            }
            String backupFileName = backupFile.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupFile.getFileName();
            String fileName = backupFileName.replaceAll(folderPath, replaceValue);
            String tempPath = backupFile.getFilePath().replace(":", "_DRIVE");
            logger.debug(backupFile.getUserName() + "....fileName..." + fileName);
            fileName = fileName.replaceAll("//", "\\");
            logger.debug(tempPath + "....fileName after replace..." + fileName);
            String fileCompletePath = restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath;
            logger.debug(tempPath + "....fileCompletePath.." + fileCompletePath);
            File file = new File(fileCompletePath);
            if (!file.exists()) {
                try {
                    file.mkdirs();
                }
                catch (Exception e1) {
                    logger.trace("" + e1);
                    logger.error("EXCPTION" + e1.getMessage());
                }
            }
            fileCompletePath = fileCompletePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupFile.getFileName();
            if (backupFile.isMail()) {
                fileCompletePath = fileCompletePath + ".eml";
            }
            logger.debug(".#############...fileCompletePath.." + fileCompletePath);
            List chunkFilesList = backupFile.getChunkFiles();
            int totalChunks = chunkFilesList.size();
            Collections.sort(chunkFilesList, new Comparator<com.pg.domain.ChunkFile>(){

                @Override
                public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                    if (c1 == null || c2 == null || c1.getFileName() == null || c2.getFileName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)c1.getFileName().toLowerCase(), (Object)c2.getFileName().toLowerCase()).toComparison();
                }
            });
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileCompletePath));
                Throwable throwable = null;
                try {
                    for (com.pg.domain.ChunkFile chunkFile : chunkFilesList) {
                        logger.debug("chunk file-------" + chunkFile.toString());
                        String syncDecryptKey = SYNC_DECRYPT_KEY;
                        String productType = "sync";
                        String dedupVal = this.getDedupValue(userName);
                        logger.debug("..before chunk detail...." + userName + "...." + dedupVal + "...ch..." + chunkFile.getMd5());
                        ChunkDetail chunkDetail = null;
                        List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
                        if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                            logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                            chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                        }
                        if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                            for (ChunkDetail detailFromDB : chunkDetailList) {
                                if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                                chunkDetail = detailFromDB;
                            }
                        }
                        BufferedInputStream inputStream = null;
                        try {
                            if (chunkDetail == null) {
                                logger.debug(CHUNK_DETAILS_NULL);
                                chunkDetail = new ChunkDetail();
                                chunkDetail.setCloudChunkName(chunkFile.getFileName());
                                chunkDetail.setUserName(userName);
                                chunkDetail.setContainerName(userName.toLowerCase());
                                chunkDetail.setMd5(chunkFile.getMd5());
                            }
                            logger.debug(CLOUD_CHUNK_NAME + chunkDetail.getCloudChunkName());
                            String backupId = backupFile.getId();
                            String containerName = null;
                            containerName = chunkDetail.getContainerName();
                            StringBuilder fileNameToDownload = new StringBuilder();
                            fileNameToDownload.append(chunkDetail.getCloudChunkName());
                            int occurance = StringUtils.countMatches((String)fileNameToDownload.toString(), (String)".");
                            if (occurance == 0 || occurance == 1 && chunkFilesList.size() > 1 && fileNameToDownload.toString().startsWith("part")) {
                                fileNameToDownload.append(".").append(backupId);
                            }
                            if (chunkDetail != null) {
                                containerName = chunkDetail.getContainerName();
                                if (!StringUtils.isEmpty((String)chunkDetail.getCloudStoragePath())) {
                                    chunkFile.setCloudStoragePath(chunkDetail.getCloudStoragePath());
                                }
                            }
                            if (!StringUtils.isEmpty((String)chunkDetail.getContainerName()) && !"ParaBlu".equalsIgnoreCase(chunkDetail.getContainerName())) {
                                productType = BACKUP;
                                syncDecryptKey = chunkDetail.getContainerName();
                            }
                            com.pg.domain.ChunkFile pgChunkFile = new com.pg.domain.ChunkFile();
                            BeanUtils.copyProperties((Object)chunkFile, (Object)pgChunkFile);
                            boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                            String fileToDownload = fileNameToDownload.toString();
                            if (isGDEnabled) {
                                fileToDownload = chunkDetail.getCloudChunkName();
                                logger.debug(fileNameToDownload.toString() + "....chunk fileid... " + chunkDetail.getCloudChunkName());
                            }
                            logger.debug(chunkFile.getCloudStoragePath() + LOOP_BEFORE_DOWNLOAD_FILE + fileToDownload + " ..new");
                            FileStatusElement fileStatusElement = new FileStatusElement();
                            inputStream = this.cloudSupportService.downloadFile(cloud, tempdownloadDir.getPath(), fileToDownload, userName, backupFile.getDeviceUUID(), containerName, pgChunkFile, false, backupFile, fileStatusElement, chunkDetail.getUserName(), chunkDetail, "");
                            if (inputStream == null) {
                                continue block21;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.trace("" + e);
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException e1) {
                                logger.trace("" + e1);
                                logger.error("EXCPTION" + e1.getMessage());
                            }
                            logger.error(ERROR_TRYING_TO_DOWNLOAD_FROM_ORIGINAL_SOURCE_PATH, (Throwable)e);
                            throw new ParacloudBackupException(AZURE_DOWNLOAD_ERROR, 507);
                        }
                        saltKeyTemp = this.getEncryptOrDecryptKey(cloud.getCloudId(), chunkFile.getUploadedTimeStamp(), BACKUP);
                        File decryptedFile = this.getDecryptedFileForPortal(cloud.getCloudName(), saltKeyTemp, deviceUUID, chunkFile.getFileName(), inputStream, chunkDetail.getUserName(), path, chunkFile, cloud.getCloudId(), chunkDetail);
                        try {
                            int buff;
                            FileInputStream copyFileInput = new FileInputStream(decryptedFile.getAbsolutePath());
                            FilterInputStream fif = new BufferedInputStream(copyFileInput);
                            logger.debug(IS_COMPRESSED + backupFile.isCompressed());
                            if (backupFile.isCompressed()) {
                                fif = new GZIPInputStream(copyFileInput);
                            }
                            byte[] b = new byte[4096];
                            while ((buff = ((InputStream)fif).read(b)) != -1) {
                                bos.write(b, 0, buff);
                            }
                            ((InputStream)fif).close();
                        }
                        catch (IOException e) {
                            logger.error("Exception" + e.getMessage());
                        }
                        logger.debug(" remaining chunks ......" + --totalChunks);
                        logger.debug("....Download Done for " + backupFile.getFileName() + "...");
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bos == null) continue;
                    if (throwable != null) {
                        try {
                            bos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bos.close();
                }
            }
            catch (FileNotFoundException e2) {
                logger.trace("" + e2);
                logger.error("EXCPTION" + e2.getMessage());
            }
            catch (IOException e3) {
                logger.trace("" + e3);
                logger.error("EXCPTION" + e3.getMessage());
            }
        }
    }

    @Override
    public DownloadTO restoreFolderForPortal(Cloud cloud, String cloudName, String userName, String fileName, String filePath, String saltKey, String deviceUUID, String syncRevisionId, String gatewayName, boolean b, HttpServletResponse response, String browserType) {
        DownloadTO downloadTO = new DownloadTO("");
        return null;
    }

    private void convertBackupImageToBackupFile(BackUpImage backupImage, com.pg.domain.BackupFile backupFileData) {
        BeanUtils.copyProperties((Object)backupImage, (Object)backupFileData);
        ArrayList<com.pg.domain.ChunkFile> chunkList = new ArrayList<com.pg.domain.ChunkFile>();
        for (ChunkFile chunkFile : backupImage.getChunkFiles()) {
            com.pg.domain.ChunkFile file = new com.pg.domain.ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)file);
            chunkList.add(file);
        }
        backupFileData.setChunkFiles(chunkList);
        backupFileData.setFilePath(backupImage.getDevicePath());
    }

    private void downloadZipFileFromPGForPortal(String cloudName, HttpServletResponse response1, FileInfo fileInfo, DownloadFileTO downloadFileTO, String restoreFolderPath) {
        String folderPath = "";
        String replaceValue = "";
        if (StringUtils.isNotEmpty((String)downloadFileTO.getFilePath())) {
            folderPath = downloadFileTO.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        } else {
            folderPath = ":";
            replaceValue = "_DRIVE";
        }
        logger.debug(".....file");
        String backupFileName = fileInfo.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        String fileName = backupFileName.replaceAll(folderPath, replaceValue);
        String tempPath = fileInfo.getFilePath().replace(":", "_DRIVE");
        logger.debug("....fileName..." + fileName);
        fileName = fileName.replaceAll("//", "\\");
        logger.debug(restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath + "....fileName after replace..." + fileName);
        File tempFile = new File(restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempPath);
        if (!tempFile.exists()) {
            try {
                tempFile.mkdirs();
            }
            catch (Exception e1) {
                logger.trace("" + e1);
                logger.error("EXCPTION" + e1.getMessage());
            }
        }
        String fileCompletePath = restoreFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getFileName();
        logger.debug(tempPath + "....fileCompletePath.." + fileCompletePath);
        logger.debug(" file is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
        List list = fileInfo.getChunkFiles();
        Collections.sort(list);
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
            deviceTempPath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getBatchId();
        }
        String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        if (!StringUtils.isEmpty((String)fileInfo.getSubject()) || !StringUtils.isEmpty((String)fileInfo.getFrom())) {
            fileCompletePath = fileCompletePath + ".eml";
        }
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileCompletePath));){
            for (String chunkName : list) {
                int endIndex;
                if (!StringUtils.isEmpty((String)chunkName) && chunkName.startsWith("part") && (endIndex = chunkName.lastIndexOf(46)) != -1) {
                    chunkName = chunkName.substring(0, endIndex);
                }
                logger.debug(FILE_FROM_PG + chunkName);
                String filePath = chunkFilePath + "/" + chunkName;
                File file = new File(filePath);
                if (file.exists()) {
                    long size = file.length();
                    logger.debug(size + " file from pg.size................." + filePath);
                    try {
                        int buff;
                        FileInputStream copyFileInput = new FileInputStream(file.getAbsolutePath());
                        FilterInputStream fif = new BufferedInputStream(copyFileInput);
                        if (fileInfo.isCompressed()) {
                            fif = new GZIPInputStream(copyFileInput);
                        }
                        byte[] b = new byte[4096];
                        while ((buff = ((InputStream)fif).read(b)) != -1) {
                            bos.write(b, 0, buff);
                        }
                        ((InputStream)fif).close();
                    }
                    catch (IOException e) {
                        logger.debug("....execption......" + e);
                    }
                    continue;
                }
                logger.error(" file does not exists........" + filePath);
                break;
            }
        }
        catch (Exception e1) {
            logger.error("Exception" + e1.getMessage(), (Throwable)e1);
        }
    }

    @Override
    public DownloadTO downloadBackupFolderForPortal(DownloadFileTO downloadFileTO, Cloud cloud, HttpServletResponse response, String browserType) {
        String userName = downloadFileTO.getUserName();
        int cloudId = cloud.getCloudId();
        String deviceUUID = downloadFileTO.getDeviceUUID();
        logger.debug("..existing deviuuid..." + deviceUUID);
        if (StringUtils.isEmpty((String)deviceUUID) && !StringUtils.isEmpty((String)(deviceUUID = this.backupFileDao.getDeviceUUIDForId(cloudId, cloud.getCloudName(), userName, downloadFileTO.getBackupID())))) {
            downloadFileTO.setDeviceUUID(deviceUUID);
        }
        Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
        DownloadTO downloadTO = new DownloadTO("");
        return this.downloadZipFileFromCloudForPortal(downloadFileTO, response, cloud, browserType, downloadTO, device);
    }

    private void restoreMailFromPG(String cloudName, HttpServletResponse response, FileInfo fileInfo, String restoreId) {
        if (fileInfo != null) {
            String fileInfoFileName = fileInfo.getFileName() + ".eml";
            Long filesize = fileInfo.getSize();
            String encodedFilename = fileInfoFileName;
            try {
                logger.debug(" file mail is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
                List list = fileInfo.getChunkFiles();
                Collections.sort(list);
                String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                    deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
                }
                String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
                logger.debug(" file mail s from pg.................." + encodedFilename);
                File tempdownloadDir = new File(chunkFilePath);
                if (!tempdownloadDir.exists()) {
                    tempdownloadDir.mkdirs();
                }
                String filePath = chunkFilePath + "/" + encodedFilename;
                try {
                    MimeMessage mimeMessage = DownloadServiceImpl.convertToMimeMessage(fileInfo);
                    logger.debug("....file path for dd downloading..." + filePath);
                    File msgFile = new File(filePath);
                    mimeMessage.writeTo((OutputStream)new FileOutputStream(msgFile));
                    if (msgFile.exists()) {
                        long size = msgFile.length();
                        logger.debug(size + " file from pg.size................." + filePath + "...msg file name." + fileInfoFileName);
                        FileInputStream input = new FileInputStream(msgFile);
                        this.writeDataToStream(response, filePath, fileInfo, fileInfoFileName, filePath, input, restoreId);
                    } else {
                        logger.error(" file does not exists........" + filePath);
                    }
                }
                catch (Exception e) {
                    logger.error(".. unable to download mail..." + e.getMessage());
                }
                logger.debug(" before returning.........");
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
        }
    }

    private void restoreMailFromCloud(String cloudName, HttpServletResponse response, FileInfo fileInfo, String restoreId) {
        if (fileInfo != null) {
            String fileInfoFileName = fileInfo.getFileName() + ".eml";
            Long filesize = fileInfo.getSize();
            String encodedFilename = fileInfoFileName;
            try {
                logger.debug(" file mail is in pg .... " + fileInfo.getFileName() + "...." + fileInfo.getFilePath());
                List list = fileInfo.getChunkFiles();
                Collections.sort(list);
                String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                if (!StringUtils.isEmpty((String)fileInfo.getBatchId())) {
                    deviceTempPath = deviceTempPath + "/" + fileInfo.getBatchId();
                }
                String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
                logger.debug(" file mail s from pg.................." + encodedFilename);
                File tempdownloadDir = new File(chunkFilePath);
                if (!tempdownloadDir.exists()) {
                    tempdownloadDir.mkdirs();
                }
                String filePath = chunkFilePath + "/" + encodedFilename;
                try {
                    MimeMessage mimeMessage = DownloadServiceImpl.convertToMimeMessage(fileInfo);
                    logger.debug("....file path for dd downloading..." + filePath);
                    File msgFile = new File(filePath);
                    mimeMessage.writeTo((OutputStream)new FileOutputStream(msgFile));
                    if (msgFile.exists()) {
                        long size = msgFile.length();
                        logger.debug(size + " file from pg.size................." + filePath + "...msg file name." + fileInfoFileName);
                        FileInputStream input = new FileInputStream(msgFile);
                        this.writeDataToStream(response, filePath, fileInfo, fileInfoFileName, filePath, input, restoreId);
                    } else {
                        logger.error(" file does not exists........" + filePath);
                    }
                }
                catch (Exception e) {
                    logger.error(".. unable to download mail..." + e.getMessage());
                }
                logger.debug(" before returning.........");
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("" + e.getMessage());
            }
        }
    }

    private static MimeMessage convertToMimeMessage(FileInfo fileInfo) throws Exception {
        Properties p = System.getProperties();
        Session session = Session.getInstance((Properties)p);
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setSubject(fileInfo.getSubject());
        mimeMessage.setSentDate(fileInfo.getSentDate());
        InternetAddress fromMailbox = new InternetAddress();
        if (fileInfo.getFromEmailAddress() != null) {
            fromMailbox.setAddress(fileInfo.getFromEmailAddress().getAddress());
            if (fileInfo.getFromEmailAddress() != null) {
                fromMailbox.setPersonal(fileInfo.getFromEmailAddress().getName());
            } else {
                fromMailbox.setPersonal(fileInfo.getFromEmailAddress().getName());
            }
        }
        mimeMessage.setFrom((Address)fromMailbox);
        fileInfo.getCcRecipientsAddress().forEach(ccrec -> {
            try {
                mimeMessage.setRecipient(Message.RecipientType.CC, (Address)new InternetAddress(ccrec.getAddress(), ccrec.getName()));
            }
            catch (Exception e) {
                logger.error(".... exception......" + e.getMessage());
            }
        });
        fileInfo.getBccRecipientsAddress().forEach(bccrec -> {
            try {
                mimeMessage.setRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bccrec.getAddress(), bccrec.getName()));
            }
            catch (Exception e) {
                logger.error(".... exception......" + e.getMessage());
            }
        });
        fileInfo.getToRecipientsAddress().forEach(torec -> {
            try {
                mimeMessage.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(torec.getAddress(), torec.getName()));
            }
            catch (Exception e) {
                logger.error(".... exception......" + e.getMessage());
            }
        });
        MimeMultipart rootMultipart = new MimeMultipart();
        MimeMultipart contentMultipart = new MimeMultipart();
        MimeBodyPart contentBodyPart = new MimeBodyPart();
        contentBodyPart.setContent((Multipart)contentMultipart);
        MimeBodyPart htmlBodyPart = new MimeBodyPart();
        htmlBodyPart.setContent((Object)fileInfo.getBodyContent(), "text/html; charset=utf-8");
        contentMultipart.addBodyPart((BodyPart)htmlBodyPart);
        rootMultipart.addBodyPart((BodyPart)contentBodyPart);
        mimeMessage.setContent((Multipart)rootMultipart);
        return mimeMessage;
    }

    @Override
    public com.pg.domain.BackupFile getBackupFileForId(int cloudId, String userName, String backupID) {
        com.pg.domain.BackupFile backupFile = null;
        if (!StringUtils.isEmpty((String)backupID)) {
            String deviceUUID = this.backupFileDao.getDeviceUUIDForId(cloudId, "", userName, backupID);
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            backupFile = this.backupFileDao.getBackupFilesForId(cloudId, "", userName, device, backupID);
        }
        return backupFile;
    }

    @Override
    public BackUpImage getBackupImageForId(int cloudId, Device device, String backupID) {
        return this.externalStorageBackupFileDao.getBackupImageForId(cloudId, backupID, device);
    }

    @Override
    public List<BackUpImage> getBackupFilesForBasePath(int cloudId, String cloudName, String userName, Device device, String devcePath) {
        return this.externalStorageBackupFileDao.getBackupFilesForBasePath(cloudId, cloudName, userName, device, devcePath);
    }

    @Override
    public List<BackUpImage> getBaseFoldersForDevice(int cloudId, Device device) {
        return this.backupFileDao.getBaseFoldersForDevice(cloudId, device);
    }

    @Override
    public FileInfo getFileFromPG(int cloudId, String userName, String backupId) {
        return this.fileDao.getFileFromPG(userName, "", backupId, false);
    }

    private void writeDataToStream(File file, HttpServletResponse response) throws IOException {
        try {
            int buff;
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream fif = new BufferedInputStream(fis);
            byte[] b = new byte[4096];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
                response.getOutputStream().flush();
            }
            ((InputStream)fif).close();
            logger.debug(FINISHED_FILE + file.getName());
            file.delete();
            logger.debug("deleting  file  under path ....." + file.getPath());
        }
        catch (Exception e) {
            logger.debug("Exception   " + e);
            logger.error("Exception   " + e.getMessage());
        }
    }

    @Override
    public List<RestoreBackUpImage> getBaseFoldersForDeviceLatest(int cloudId, Device device) {
        return this.backupFileDao.getBaseFoldersForDeviceLatest(cloudId, device);
    }

    @Override
    public List<RestoreBackUpImage> getBackupFilesForBasePathLatest(int cloudId, String cloudName, String userName, Device device, String devcePath) {
        return this.externalStorageBackupFileDao.getBackupFilesForBasePathLatest(cloudId, cloudName, userName, device, devcePath);
    }
}

