/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.parablu.pcbd.domain.Cloud;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.DeleteTempDataTimerService;
import com.pg.service.UtilService;
import java.io.File;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTempDataTimerServiceImpl
implements DeleteTempDataTimerService {
    private static Logger logger = LoggerFactory.getLogger(DeleteTempDataTimerServiceImpl.class);

    @Override
    public void deleteTempFilesBasedonBatchstatus(UtilService utilService) {
        try {
            File[] listofDeviceUUID;
            Set<String> collectioinNames = utilService.getBlukryptCollectionsName();
            Cloud cloud = utilService.getCloud(1);
            String TmpFolder = PCHelperConstant.getMntTempChunkPath();
            File intermediateUpload = new File(TmpFolder);
            for (File deviceUUIDFolder : listofDeviceUUID = intermediateUpload.listFiles()) {
                try {
                    File[] listofbatchIdFolders;
                    logger.debug("device UUID ..." + deviceUUIDFolder.getName());
                    if (!deviceUUIDFolder.exists() || deviceUUIDFolder.getName().startsWith("tempLogs")) continue;
                    for (File batchIdFolder : listofbatchIdFolders = deviceUUIDFolder.listFiles()) {
                        try {
                            String status;
                            logger.debug("batchId Folder ..." + batchIdFolder.getName());
                            if (batchIdFolder.exists() && batchIdFolder.isDirectory() && StringUtils.isNotEmpty((String)(status = utilService.getBackupBatchStatusById(cloud.getCloudId(), batchIdFolder.getName()))) && (status.equalsIgnoreCase("COMPLETED") || status.equalsIgnoreCase("ABORTED"))) {
                                try {
                                    logger.debug("############ before deleting the folder....");
                                    FileUtils.deleteDirectory((File)batchIdFolder);
                                    for (String collection : collectioinNames) {
                                        if (!collection.endsWith(batchIdFolder.getName())) continue;
                                        utilService.dropBluCollBasedonBatchstatus(collection);
                                    }
                                }
                                catch (Exception e) {
                                    logger.error("############ error deleting the folder....", (Throwable)e);
                                }
                                logger.debug("*********End of deleting backup batch folder *********");
                            }
                            if (!batchIdFolder.exists() || !batchIdFolder.isFile()) continue;
                            logger.debug("*********Inside delete file condition.... *********");
                            long currenttime = System.currentTimeMillis();
                            long fileModifiedTime = batchIdFolder.lastModified();
                            long modifiedTime = currenttime - fileModifiedTime;
                            long dayinMilliSeconds = 86400000L;
                            logger.debug(dayinMilliSeconds + "......" + modifiedTime);
                            if (modifiedTime < dayinMilliSeconds) continue;
                            logger.debug("deleting file modified time is greater than 24 hrs ..." + batchIdFolder.getAbsolutePath());
                            batchIdFolder.delete();
                            logger.debug("*********End of deleting backup batch folfder *********");
                        }
                        catch (Exception e) {
                            logger.debug("Error to delete temp files...." + e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    logger.debug("Error to delete temp files...." + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.debug("Error to delete temp files...." + e.getMessage());
        }
    }
}

