/*
 * Decompiled with CFR 0.152.
 */
package com.pg.odb.util;

import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.extensions.Drive;
import com.microsoft.graph.models.extensions.DriveItem;
import com.microsoft.graph.models.extensions.IGraphServiceClient;
import com.microsoft.graph.requests.extensions.GraphServiceClient;
import com.microsoft.graph.requests.extensions.IDriveCollectionPage;
import com.microsoft.graph.requests.extensions.IDriveCollectionRequest;
import com.microsoft.graph.requests.extensions.IDriveCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IUserRequestBuilder;
import com.parablu.pcbd.dao.BackupOverViewDao;
import com.parablu.pcbd.domain.RetryPolicyTable;
import com.parablu.pcbd.domain.User;
import com.pg.controller.Graph;
import com.pg.dao.Office365Dao;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.service.GraphUploadService;
import com.pg.service.Office365UploadService;
import com.pg.service.RetryService;
import com.pg.service.UtilService;
import com.pg.service.impl.Office365DownloadServiceImplData;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.function.CheckedSupplier;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class OneDriveUtil {
    private static final int MAX_FILE_COUNT = 4000;
    @Autowired
    private UtilService utilService;
    @Autowired
    private Office365UploadService office365UploadService;
    @Autowired
    private GraphUploadService graphUploadService;
    @Autowired
    private BackupOverViewDao backupOverViewDao;
    @Autowired
    private Office365Dao office365Dao;
    @Autowired
    private RetryService retryService;
    private static OneDriveUtil singleton = new OneDriveUtil();
    private static Logger logger = Logger.getLogger(OneDriveUtil.class);
    Map<String, UserOdbElement> userCountMap = new ConcurrentHashMap<String, UserOdbElement>();
    Map<String, Object> userObjectMap = new ConcurrentHashMap<String, Object>();

    private OneDriveUtil() {
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setOffice365UploadService(Office365UploadService office365UploadService) {
        this.office365UploadService = office365UploadService;
    }

    public static OneDriveUtil getInstance() {
        return singleton;
    }

    private synchronized void setUserElementUsingGraph(PciAuthorizationTokenElement pciTokenElement, boolean isSync, String emailId, User user, String deviceUUID, String actualUserName) {
        logger.error((Object)("MAP-VAL................" + this.userCountMap + "...." + emailId));
        if (this.userCountMap.get(actualUserName) == null) {
            ArrayList<Integer> folderNameList;
            logger.debug((Object)("inside getUserElement nulll " + actualUserName));
            String lastCloudStoragePath = this.checkOneDriveStoragePath(pciTokenElement.getCloudName(), pciTokenElement.getUserName(), isSync, user);
            int count = this.getCountOFFilesInFolderUsingGraph(pciTokenElement, emailId, deviceUUID, lastCloudStoragePath);
            logger.debug((Object)(".......folder count before assigning setuserElement..... " + count));
            while (count >= 4000 && (count = this.getCountOFFilesInFolderUsingGraph(pciTokenElement, emailId, deviceUUID, lastCloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList = this.splitPathAndGetFolderDepth(lastCloudStoragePath), count))) >= 4000) {
            }
            logger.debug((Object)(".......folder count after assigning setuserElement..... " + count + "......." + lastCloudStoragePath));
            UserOdbElement userOdbElement = new UserOdbElement(count, System.currentTimeMillis(), lastCloudStoragePath);
            this.userCountMap.put(actualUserName, userOdbElement);
        }
    }

    public int getCountOFFilesInFolderUsingGraph(PciAuthorizationTokenElement pciTokenElement, String emailId, String deviceUUID, String path) {
        DriveItem item;
        int countVal;
        block4: {
            countVal = 0;
            IGraphServiceClient graphClient = OneDriveUtil.getGraphClient(pciTokenElement.getAccessToken());
            String driveId = this.getPBFolderItemId(pciTokenElement.getAccessToken(), emailId);
            String userNameToGetUrl = "";
            if (!StringUtils.isEmpty((Object)deviceUUID)) {
                userNameToGetUrl = OneDriveUtil.getUniqueODUserFolder(deviceUUID);
                logger.debug((Object)("....device unique id ....... " + userNameToGetUrl));
            }
            item = null;
            try {
                item = (DriveItem)graphClient.customRequest("/drives/" + driveId + "/root:/" + userNameToGetUrl + "/" + path, DriveItem.class).buildRequest().get();
            }
            catch (GraphServiceException e) {
                logger.error((Object)("....excep..." + e.getResponseCode()));
                if (e.getResponseCode() != 404) break block4;
                return 0;
            }
        }
        if (item != null && item.folder != null) {
            countVal = item.folder.childCount;
        }
        return countVal;
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty((Object)deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString((String)deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    public static IGraphServiceClient getGraphClient(String accessToken) {
        Graph graph = Graph.getInstance(accessToken);
        IGraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)graph).buildClient();
        return graphClient;
    }

    private static boolean isPBDrive(String json) {
        boolean pbDrive = false;
        String webUrl = "";
        try {
            JSONObject jsonObject = new JSONObject(json);
            webUrl = (String)jsonObject.get("webUrl");
            String docLibraryName = webUrl.substring(webUrl.lastIndexOf("/") + 1);
            logger.debug((Object)(".....doclib....." + docLibraryName));
            if (!StringUtils.isEmpty((Object)docLibraryName) && docLibraryName.equalsIgnoreCase("PB")) {
                pbDrive = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)(webUrl + "...unable to get drive .... " + e.getMessage()));
            pbDrive = false;
        }
        return pbDrive;
    }

    public String getPBFolderItemId(String accessToken, String emailId) {
        String pbFolderItemId = "";
        try {
            logger.debug((Object)"NEW METHOD TO GET DRIVE ID");
            RetryPolicy<String> getDriveId = this.getRetryPolicy();
            Office365DownloadServiceImplData downloadServiceImplData = new Office365DownloadServiceImplData();
            PciAuthorizationTokenElement authorizationTokenElement = new PciAuthorizationTokenElement();
            authorizationTokenElement.setAccountId(emailId);
            authorizationTokenElement.setAccessToken(accessToken);
            downloadServiceImplData.setToken(authorizationTokenElement);
            this.setRetriesToGetDriveId(getDriveId, downloadServiceImplData, emailId);
            pbFolderItemId = this.getDriveIdWithFailSafe(downloadServiceImplData, getDriveId);
            logger.debug((Object)("NEW METHOD TO GET DRIVE ID:" + pbFolderItemId));
        }
        catch (Exception e) {
            logger.error((Object)"error getting drive id for one drive upload", (Throwable)e);
        }
        return pbFolderItemId;
    }

    public static String getPBFolderItemIdWithErrorCode(String accessToken, String emailId) {
        String pbFolderItemId = "";
        try {
            IGraphServiceClient graphClient = OneDriveUtil.getGraphClient(accessToken);
            IUserRequestBuilder users = graphClient.users(emailId);
            IDriveCollectionRequestBuilder drives = users.drives();
            IDriveCollectionRequest buildRequests = drives.buildRequest();
            IDriveCollectionPage iDriveCollectionPages = buildRequests.get();
            for (Drive drive : iDriveCollectionPages.getCurrentPage()) {
                logger.debug((Object)("...." + drive.name));
                if (!OneDriveUtil.isPBDrive(drive.getRawObject().toString())) continue;
                pbFolderItemId = drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.debug((Object)(".....driveid error code ...." + e.getResponseCode()));
            pbFolderItemId = "" + e.getResponseCode();
            logger.error((Object)"error getting drive id for one drive upload", (Throwable)e);
        }
        if (StringUtils.isEmpty((Object)pbFolderItemId)) {
            pbFolderItemId = "404";
        }
        return pbFolderItemId;
    }

    private String getDriveIdWithFailSafe(final Office365DownloadServiceImplData downloadServiceImplData, RetryPolicy<String> retryPolicy) {
        CheckedSupplier<String> checkedSupplier = new CheckedSupplier<String>(){

            public String get() throws Throwable {
                return downloadServiceImplData.getPBFolderItemId();
            }
        };
        return (String)Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).get((CheckedSupplier)checkedSupplier);
    }

    private void setRetriesToGetDriveId(RetryPolicy<String> getDriveId, Office365DownloadServiceImplData downloadServiceImplData, String email) {
        getDriveId.onRetry(e -> {
            ExecutionAttemptedEvent event = e;
            Throwable failure = event.getLastFailure();
            logger.debug((Object)("Connection error encountered {}" + failure.getMessage()), failure);
            logger.debug((Object)("Retrying Count:" + event.getAttemptCount()));
        });
        getDriveId.handleResultIf(res -> {
            logger.debug((Object)"inside retry handleResultIf...........");
            if (res == null) {
                logger.debug((Object)"Result is null so retry...........");
                return true;
            }
            if (res instanceof String) {
                if (StringUtils.isEmpty((Object)res)) {
                    logger.error((Object)"get drive id String is empty so retry true");
                    OneDriveUtil.sleep();
                    return true;
                }
                if (res.equalsIgnoreCase("401")) {
                    logger.debug((Object)("401 case drive id inside fail safe:" + res));
                    OneDriveUtil.sleep();
                    PciAuthorizationTokenElement element1 = this.office365Dao.getMSGTokenElement(1, downloadServiceImplData.getToken().getAccountId());
                    if (element1 != null) {
                        element1.setAccountId(email);
                        downloadServiceImplData.setToken(element1);
                    }
                    return true;
                }
            }
            return false;
        });
    }

    private static void sleep() {
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e1) {
            logger.error((Object)("InterruptedException:" + e1));
        }
    }

    private synchronized void setUserElement(PciAuthorizationTokenElement pciTokenElement, boolean isSync, String emailId, User user, String deviceUUID, String actualUserName) {
        logger.error((Object)("MAP-VAL................" + this.userCountMap + "...." + emailId));
        if (this.userCountMap.get(actualUserName) == null) {
            ArrayList<Integer> folderNameList;
            logger.debug((Object)("inside getUserElement nulll " + actualUserName));
            String lastCloudStoragePath = this.checkOneDriveStoragePath(pciTokenElement.getCloudName(), pciTokenElement.getUserName(), isSync, user);
            int count = this.getCountOFFilesInFolder(pciTokenElement, lastCloudStoragePath, deviceUUID);
            logger.debug((Object)(".......folder count before assigning setuserElement..... " + count));
            while (count >= 4000 && (count = this.getCountOFFilesInFolder(pciTokenElement, lastCloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList = this.splitPathAndGetFolderDepth(lastCloudStoragePath), count), deviceUUID)) >= 4000) {
            }
            logger.debug((Object)(".......folder count after assigning setuserElement..... " + count + "......." + lastCloudStoragePath));
            UserOdbElement userOdbElement = new UserOdbElement(count, System.currentTimeMillis(), lastCloudStoragePath);
            this.userCountMap.put(actualUserName, userOdbElement);
        }
    }

    private synchronized void updateOdbCount(boolean isSync, String userName, int count, String emailId, PciAuthorizationTokenElement pciTokenElement, String deviceUUID, String actualUserName) {
        if (this.userCountMap.get(actualUserName).getCount() >= 4000) {
            ArrayList<Integer> folderNameList = this.splitPathAndGetFolderDepth(this.userCountMap.get(actualUserName).getPath());
            String cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList, this.userCountMap.get(actualUserName).getCount());
            int filesInFoldercount = this.getCountOFFilesInFolder(pciTokenElement, cloudStoragePath, deviceUUID);
            logger.debug((Object)(".......folder count before assigning..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount));
            if (filesInFoldercount != 0 && filesInFoldercount < 4000) {
                this.userCountMap.get(actualUserName).setCount(filesInFoldercount + 1);
            } else {
                while (filesInFoldercount >= 4000) {
                    logger.error((Object)("...greater than 4000.....check here... " + emailId));
                    folderNameList = this.splitPathAndGetFolderDepth(cloudStoragePath);
                    filesInFoldercount = this.getCountOFFilesInFolder(pciTokenElement, cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList, filesInFoldercount), deviceUUID);
                    if (filesInFoldercount >= 4000) continue;
                }
                logger.debug((Object)(".......folder count after finding correct path..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount));
                this.userCountMap.get(actualUserName).setCount(1);
                this.userCountMap.get(actualUserName).setPath(cloudStoragePath);
                this.utilService.updateUserStoragePath(1, userName, this.userCountMap.get(actualUserName).getPath(), isSync);
                Set<String> values = this.userCountMap.keySet();
                for (String user : values) {
                    logger.debug((Object)(".................users in memcached...." + user));
                }
            }
        } else {
            this.userCountMap.get(actualUserName).setCount(count + 1);
        }
    }

    private synchronized void updateOdbCountUsingGraph(boolean isSync, String userName, int count, String emailId, PciAuthorizationTokenElement pciTokenElement, String deviceUUID, String actualUserName) {
        if (this.userCountMap.get(actualUserName).getCount() >= 4000) {
            ArrayList<Integer> folderNameList = this.splitPathAndGetFolderDepth(this.userCountMap.get(actualUserName).getPath());
            String cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList, this.userCountMap.get(actualUserName).getCount());
            int filesInFoldercount = this.getCountOFFilesInFolderUsingGraph(pciTokenElement, emailId, deviceUUID, cloudStoragePath);
            logger.debug((Object)(".......folder count before assigning..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount));
            if (filesInFoldercount != 0 && filesInFoldercount < 4000) {
                this.userCountMap.get(actualUserName).setCount(filesInFoldercount + 1);
            } else {
                while (filesInFoldercount >= 4000) {
                    logger.error((Object)("...greater than 4000.....check here... " + emailId));
                    folderNameList = this.splitPathAndGetFolderDepth(cloudStoragePath);
                    filesInFoldercount = this.getCountOFFilesInFolderUsingGraph(pciTokenElement, emailId, deviceUUID, cloudStoragePath = this.checkOneDriveStoragePathAndCount(folderNameList, filesInFoldercount));
                    if (filesInFoldercount >= 4000) continue;
                }
                logger.debug((Object)(".......folder count after finding correct path..... " + cloudStoragePath + ".....filescount...." + filesInFoldercount));
                this.userCountMap.get(actualUserName).setCount(1);
                this.userCountMap.get(actualUserName).setPath(cloudStoragePath);
                this.utilService.updateUserStoragePath(1, userName, this.userCountMap.get(actualUserName).getPath(), isSync);
                Set<String> values = this.userCountMap.keySet();
                for (String user : values) {
                    logger.debug((Object)(".................users in memcached...." + user));
                }
            }
        } else {
            this.userCountMap.get(actualUserName).setCount(count + 1);
        }
    }

    public boolean isODBCountApiCallReq(String userName) {
        boolean isODBCountApiCallReq = true;
        if (this.userCountMap.get(userName) != null && this.userCountMap.get(userName).getCount() < 4000 && this.userCountMap.get(userName).getCount() % PCHelperConstant.getODBCallFrequency() != 0) {
            isODBCountApiCallReq = false;
        }
        return isODBCountApiCallReq;
    }

    public FileStatusElement uploadToODB(PciAuthorizationTokenElement pciTokenElement, boolean isSync, FileStatusElement fileStatusElement, File encryptedFile, String lastStoragePathForSameFile, String deviceUUID, String actualUserName, String gateWayName, String uplodingFileName, boolean isChunkDeleteProcessStarted) {
        User user = this.utilService.getUserInfoByName(1, pciTokenElement.getUserName());
        String emailId = user.getOdbLoginId();
        boolean muxedEnabled = PCHelperConstant.isMuxedEnabled();
        if (muxedEnabled && StringUtils.isEmpty((Object)emailId)) {
            this.utilService.updateUserBackupTargetStatus(1, user.getUserName(), 204);
            fileStatusElement.setUploadStatus(false);
            logger.debug((Object)("...muxedEnabled..." + muxedEnabled + "...user OdbLoginId is empty or return..."));
            return fileStatusElement;
        }
        if (StringUtils.isEmpty((Object)emailId)) {
            emailId = user.getEmailId();
        }
        boolean isOdbApiCallRequired = this.isODBCountApiCallReq(emailId);
        logger.debug((Object)("Email Id>>>>>" + emailId + "....user name:" + user.getUserName() + "...." + isOdbApiCallRequired));
        if (this.userCountMap.get(actualUserName) == null) {
            this.setUserElement(pciTokenElement, isSync, emailId, user, deviceUUID, actualUserName);
        } else {
            this.setCountForUser(pciTokenElement, isSync, pciTokenElement.getUserName(), isOdbApiCallRequired, emailId, deviceUUID, actualUserName);
        }
        logger.debug((Object)(emailId + " before  setCountForUser.......... " + isOdbApiCallRequired));
        String userStoragepath = this.userCountMap.get(actualUserName).getPath();
        if (StringUtils.isEmpty((Object)userStoragepath)) {
            userStoragepath = isSync ? user.getCloudSyncStoragePath() : user.getCloudBkpStoragePath();
            if (StringUtils.isEmpty((Object)userStoragepath)) {
                userStoragepath = "1";
            }
            logger.debug((Object)("....user storagepath for user ..." + user.getUserName() + "....path...." + userStoragepath));
        }
        logger.error((Object)(userStoragepath + " latest COUNT>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> " + this.userCountMap.get(actualUserName).getCount()));
        logger.debug((Object)"...beforewrite...");
        FileStatusElement elementAfterUpload = this.office365UploadService.uploadFileToODB(pciTokenElement.getAccessToken(), pciTokenElement, encryptedFile, userStoragepath, deviceUUID, gateWayName, uplodingFileName, fileStatusElement, isChunkDeleteProcessStarted);
        logger.debug((Object)"...afterwrite...");
        String encodedFileName = elementAfterUpload.getEncodedFileName();
        fileStatusElement.setEncodedFileName(encodedFileName);
        fileStatusElement.setUploadStatuscode(elementAfterUpload.getUploadStatuscode());
        if (!StringUtils.isEmpty((Object)elementAfterUpload.getOdbLoginId())) {
            fileStatusElement.setOdbLoginId(elementAfterUpload.getOdbLoginId());
        }
        logger.debug((Object)(" END OF next file ..... " + userStoragepath));
        fileStatusElement.setCloudStoragePath(userStoragepath);
        fileStatusElement.setUploadStatus(true);
        if (StringUtils.isEmpty((Object)encodedFileName)) {
            fileStatusElement.setUploadStatus(false);
            logger.debug((Object)("...failed case .. " + deviceUUID + "..." + this.userCountMap.get(actualUserName).getCount()));
            if (this.userCountMap.get(actualUserName) != null) {
                logger.debug((Object)("...failed case .. " + deviceUUID + "..." + this.userCountMap.get(actualUserName).getCount()));
                this.decreOdbCount(this.userCountMap.get(actualUserName).getCount(), actualUserName);
            }
        }
        if (this.userCountMap.size() > 500) {
            this.removeOldUser();
        }
        return fileStatusElement;
    }

    public FileStatusElement uploadToODBUsingGraph(PciAuthorizationTokenElement pciTokenElement, boolean isSync, FileStatusElement fileStatusElement, File encryptedFile, String lastStoragePathForSameFile, String deviceUUID, String actualUserName, String gateWayName, String uplodingFileName, String driveId) {
        User user = this.utilService.getUserInfoByName(1, pciTokenElement.getUserName());
        String emailId = user.getOdbLoginId();
        boolean muxedEnabled = PCHelperConstant.isMuxedEnabled();
        if (muxedEnabled && StringUtils.isEmpty((Object)emailId)) {
            this.utilService.updateUserBackupTargetStatus(1, user.getUserName(), 204);
            fileStatusElement.setUploadStatus(false);
            logger.debug((Object)("...muxedEnabled..." + muxedEnabled + "...user OdbLoginId is empty or return..."));
            return fileStatusElement;
        }
        if (StringUtils.isEmpty((Object)emailId)) {
            emailId = user.getEmailId();
        }
        logger.debug((Object)("Email Id>>>>>" + emailId + "....user name:" + user.getUserName()));
        boolean isOdbApiCallRequired = this.isODBCountApiCallReq(actualUserName);
        if (this.userCountMap.get(actualUserName) == null) {
            this.setUserElementUsingGraph(pciTokenElement, isSync, emailId, user, deviceUUID, actualUserName);
        } else {
            this.setCountForUserUsingGraph(pciTokenElement, isSync, pciTokenElement.getUserName(), isOdbApiCallRequired, emailId, deviceUUID, actualUserName);
        }
        logger.debug((Object)(emailId + " before  setCountForUser.......... " + isOdbApiCallRequired));
        String userStoragepath = this.userCountMap.get(actualUserName).getPath();
        if (StringUtils.isEmpty((Object)userStoragepath)) {
            userStoragepath = isSync ? user.getCloudSyncStoragePath() : user.getCloudBkpStoragePath();
            if (StringUtils.isEmpty((Object)userStoragepath)) {
                userStoragepath = "1";
            }
            logger.debug((Object)("....user storagepath for user ..." + user.getUserName() + "....path...." + userStoragepath));
        }
        logger.error((Object)(userStoragepath + " latest COUNT>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> " + this.userCountMap.get(actualUserName).getCount()));
        FileStatusElement elementAfterUpload = this.graphUploadService.uploadFileToODB(pciTokenElement.getAccessToken(), pciTokenElement, encryptedFile, userStoragepath, deviceUUID, gateWayName, uplodingFileName, fileStatusElement, driveId);
        String encodedFileName = elementAfterUpload.getEncodedFileName();
        fileStatusElement.setEncodedFileName(encodedFileName);
        fileStatusElement.setUploadStatuscode(elementAfterUpload.getUploadStatuscode());
        if (!StringUtils.isEmpty((Object)elementAfterUpload.getOdbLoginId())) {
            fileStatusElement.setOdbLoginId(elementAfterUpload.getOdbLoginId());
        }
        logger.debug((Object)(" END OF next file ..... " + userStoragepath));
        fileStatusElement.setCloudStoragePath(userStoragepath);
        fileStatusElement.setUploadStatus(true);
        if (StringUtils.isEmpty((Object)encodedFileName)) {
            fileStatusElement.setUploadStatus(false);
            logger.debug((Object)("...failed case .. " + deviceUUID + "..." + this.userCountMap.get(actualUserName).getCount()));
            if (this.userCountMap.get(actualUserName) != null) {
                logger.debug((Object)("...failed case .. " + deviceUUID + "..." + this.userCountMap.get(actualUserName).getCount()));
                this.decreOdbCount(this.userCountMap.get(actualUserName).getCount(), actualUserName);
            }
        }
        if (this.userCountMap.size() > 500) {
            this.removeOldUser();
        }
        return fileStatusElement;
    }

    public FileStatusElement uploadToOneDriveUsingGraph(PciAuthorizationTokenElement pciTokenElement, File encryptedFile, String uplodingFileName, String driveId, String storagePath) {
        User user = this.utilService.getUserInfoByName(1, pciTokenElement.getUserName());
        String emailId = user.getOdbLoginId();
        if (StringUtils.isEmpty((Object)emailId)) {
            emailId = user.getEmailId();
        }
        FileStatusElement elementAfterUpload = this.graphUploadService.uploadToOneDriveUsingGraph(pciTokenElement.getAccessToken(), pciTokenElement, encryptedFile, uplodingFileName, emailId, user.getUserName(), storagePath);
        return elementAfterUpload;
    }

    private synchronized void decreOdbCount(int count, String actualUserName) {
        if (this.userCountMap.get(actualUserName) != null) {
            this.userCountMap.get(actualUserName).setCount(count - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCountForUser(PciAuthorizationTokenElement pciTokenElement, boolean isSync, String userName, boolean isOdbApiCallRequired, String emailId, String deviceUUID, String actualUserName) {
        if (!this.userObjectMap.containsKey(emailId)) {
            Object object = new Object();
            this.userObjectMap.put(emailId, object);
        }
        Object obj = this.userObjectMap.get(emailId);
        logger.debug((Object)(obj + "..... obj synchronized ....." + emailId + "..isOdbApiCallRequired.." + isOdbApiCallRequired));
        if (isOdbApiCallRequired) {
            Object object = obj;
            synchronized (object) {
                if (this.isODBCountApiCallReq(emailId)) {
                    int count = this.getCountOFFilesInFolder(pciTokenElement, this.userCountMap.get(actualUserName).getPath(), deviceUUID);
                    if (count <= 0) {
                        count = this.userCountMap.get(actualUserName).getCount();
                    }
                    this.updateOdbCount(isSync, userName, count, emailId, pciTokenElement, deviceUUID, actualUserName);
                } else {
                    this.updateOdbCount(isSync, userName, this.userCountMap.get(actualUserName).getCount(), emailId, pciTokenElement, deviceUUID, actualUserName);
                }
            }
            logger.debug((Object)"INSID isOdbApiCallRequired.....");
        } else {
            this.updateOdbCount(isSync, userName, this.userCountMap.get(actualUserName).getCount(), emailId, pciTokenElement, deviceUUID, actualUserName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCountForUserUsingGraph(PciAuthorizationTokenElement pciTokenElement, boolean isSync, String userName, boolean isOdbApiCallRequired, String emailId, String deviceUUID, String actualUserName) {
        if (!this.userObjectMap.containsKey(emailId)) {
            Object object = new Object();
            this.userObjectMap.put(emailId, object);
        }
        Object obj = this.userObjectMap.get(emailId);
        logger.debug((Object)(obj + "..... obj synchronized ....." + emailId + "...odbcall required..." + isOdbApiCallRequired));
        if (isOdbApiCallRequired) {
            Object object = obj;
            synchronized (object) {
                if (this.isODBCountApiCallReq(emailId)) {
                    int count = this.getCountOFFilesInFolderUsingGraph(pciTokenElement, emailId, deviceUUID, this.userCountMap.get(actualUserName).getPath());
                    if (count <= 0) {
                        count = this.userCountMap.get(actualUserName).getCount();
                    }
                    this.updateOdbCountUsingGraph(isSync, userName, count, emailId, pciTokenElement, deviceUUID, actualUserName);
                } else {
                    this.updateOdbCountUsingGraph(isSync, userName, this.userCountMap.get(actualUserName).getCount(), emailId, pciTokenElement, deviceUUID, actualUserName);
                }
            }
            logger.debug((Object)"INSID isOdbApiCallRequired.....");
        } else {
            this.updateOdbCountUsingGraph(isSync, userName, this.userCountMap.get(actualUserName).getCount(), emailId, pciTokenElement, deviceUUID, actualUserName);
        }
    }

    private void removeOldUser() {
        HashMap<String, Long> userMap = new HashMap<String, Long>();
        for (Map.Entry<String, UserOdbElement> entry : this.userCountMap.entrySet()) {
            String key = entry.getKey();
            UserOdbElement userOdbElement = entry.getValue();
            userMap.put(key, userOdbElement.getTimeMillis());
        }
        String userToBeRemoved = Collections.min(userMap.entrySet(), new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return o1.getValue().intValue() - o2.getValue().intValue();
            }
        }).getKey();
        if (!StringUtils.isEmpty((Object)userToBeRemoved)) {
            Long oldestTimeStamp = (Long)userMap.get(userToBeRemoved);
            int fiveMinsInactivePeriod = 300000;
            if (oldestTimeStamp != null && System.currentTimeMillis() > oldestTimeStamp + (long)fiveMinsInactivePeriod) {
                logger.debug((Object)("removing user .... " + userToBeRemoved));
                this.userCountMap.remove(userToBeRemoved);
            }
        }
    }

    private int getCountOFFilesInFolder(PciAuthorizationTokenElement pciTokenElement, String lastCloudStoragePath, String deviceUUID) {
        return this.office365UploadService.getCountOfFilesInFolder(pciTokenElement, lastCloudStoragePath, deviceUUID);
    }

    private synchronized String checkOneDriveStoragePath(String cloudName, String userName, boolean isSync, User user) {
        String cloudStoragePath = "1";
        if (isSync) {
            if (!StringUtils.isEmpty((Object)user.getCloudSyncStoragePath())) {
                cloudStoragePath = user.getCloudSyncStoragePath();
            }
        } else if (!StringUtils.isEmpty((Object)user.getCloudBkpStoragePath())) {
            cloudStoragePath = user.getCloudBkpStoragePath();
        }
        if (StringUtils.isEmpty((Object)cloudStoragePath)) {
            cloudStoragePath = "1";
        }
        logger.debug((Object)(userName + "Inside check onedrivepath>>>>>>>>>>>>" + cloudStoragePath));
        return cloudStoragePath;
    }

    private String checkOneDriveStoragePathAndCount(ArrayList<Integer> folderNameList, int count) {
        int countTemp = count;
        String cloudStoragePath = "";
        int folderDepthSize = folderNameList.size();
        int folderValue = folderNameList.get(0);
        if (folderDepthSize == 1 && folderValue <= 900) {
            logger.debug((Object)("Folder DEpth Size 1 folder value>>>>>>" + folderValue));
            if (countTemp < 4000) {
                cloudStoragePath = String.valueOf(folderValue);
                logger.debug((Object)("Folder DEpth Size 1 folder value count less than 500>>>>>>." + countTemp));
            } else if (folderValue < 900) {
                countTemp = 0;
                folderNameList.set(0, folderValue + 1);
                cloudStoragePath = String.valueOf(folderValue + 1);
                logger.debug((Object)("count >= MAX_FILE_COUNT ........... " + cloudStoragePath));
            } else if (folderValue >= 900) {
                folderNameList.clear();
                countTemp = 0;
                folderNameList.add(0, 1);
                folderNameList.add(1, 1);
                cloudStoragePath = "1/1";
                logger.debug((Object)("folderValue >= 900 ........... " + cloudStoragePath));
            }
            ++countTemp;
        } else {
            int lastFolder = folderNameList.get(folderDepthSize - 1);
            int previousFolder = 0;
            if (folderDepthSize > 1) {
                previousFolder = folderNameList.get(folderDepthSize - 2);
            }
            if (lastFolder <= 900) {
                if (countTemp < 4000) {
                    cloudStoragePath = String.valueOf(previousFolder + "/" + lastFolder);
                    logger.debug((Object)("else count < MAX_FILE_COUNT ........... " + cloudStoragePath));
                } else if (lastFolder < 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, lastFolder + 1);
                    cloudStoragePath = String.valueOf(previousFolder + "/" + ++lastFolder);
                    logger.debug((Object)("else count >= MAX_FILE_COUNT ........... " + cloudStoragePath));
                } else if (lastFolder >= 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, 1);
                    if (folderDepthSize > 1) {
                        folderNameList.set(folderDepthSize - 2, previousFolder + 1);
                    }
                    cloudStoragePath = ++previousFolder + "/1";
                    logger.debug((Object)("else lastFolder >= 900 ........... " + cloudStoragePath));
                }
            } else if (lastFolder >= 900) {
                countTemp = 0;
                folderNameList.set(folderDepthSize - 1, 1);
                if (folderDepthSize > 1) {
                    folderNameList.set(folderDepthSize - 2, previousFolder + 1);
                }
                cloudStoragePath = ++previousFolder + "/1";
                logger.debug((Object)("else lastFolder >= 900 ........... " + cloudStoragePath));
            }
            ++countTemp;
        }
        logger.debug((Object)("4000 max size " + cloudStoragePath + " endo of method ........" + countTemp));
        return cloudStoragePath;
    }

    private ArrayList<Integer> splitPathAndGetFolderDepth(String cloudStoragePath) {
        ArrayList<Integer> pathListNumbers = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)cloudStoragePath)) {
            String[] pathList;
            for (String path : pathList = cloudStoragePath.split("/")) {
                pathListNumbers.add(Integer.parseInt(path));
            }
        } else {
            pathListNumbers.add(1);
        }
        return pathListNumbers;
    }

    public FileStatusElement deleteFromODB(PciAuthorizationTokenElement pciTokenElement, String fileNameTodownload, String lastStoragePathForSameFile, String deviceUUID) {
        return this.office365UploadService.deleteFileFromODB(pciTokenElement, fileNameTodownload, lastStoragePathForSameFile, deviceUUID);
    }

    public void updateBkpOverviewForDeletedFiles(int cloudId, String deviceUUID, Long deletedFileSize) {
        logger.debug((Object)(".....processing for thread...." + Thread.currentThread().getName()));
        try {
            long updatedSize = -deletedFileSize.longValue();
            logger.debug((Object)(deviceUUID + "....updateBkpOverviewForDeletedFiles%%......" + updatedSize + "...rem..." + updatedSize));
            this.backupOverViewDao.updateSizeDeviceBackupOverView(cloudId, deviceUUID, Long.valueOf(updatedSize), null, null, null);
        }
        catch (Exception e) {
            logger.error((Object)("...Exception :" + e.getMessage()));
        }
        catch (Error ee) {
            logger.error((Object)("...Exception :" + ee.getMessage()));
        }
    }

    public void updateSizeInDeviceBackupOverview(int cloudId, String deviceUUID, Long sizeToUpdatePG, Long sizeToUpdateInCloud, Long latestVersionSize, Long pgCompressedSize) {
        logger.debug((Object)(".....processing for thread...." + Thread.currentThread().getName() + " sizeToUpdatePG " + sizeToUpdatePG + " sizeToUpdateInCloud " + sizeToUpdateInCloud + " latestVersionSize " + latestVersionSize + " pgCompressedSize " + pgCompressedSize));
        this.backupOverViewDao.updateSizeDeviceBackupOverView(cloudId, deviceUUID, sizeToUpdatePG, sizeToUpdateInCloud, latestVersionSize, pgCompressedSize);
    }

    public FileStatusElement deleteFromODBUsingGraph(PciAuthorizationTokenElement pciTokenElement, String fileName, String cloudStoragePath, String deviceUUID, String driveId) {
        return this.graphUploadService.deleteFileFromODB(pciTokenElement, fileName, cloudStoragePath, deviceUUID, driveId);
    }

    private static String convertedValue(DecimalFormat twoDecimalForm, String value) {
        double totRam = Double.parseDouble(value);
        double mb = totRam / 1024.0;
        double gb = totRam / 1048576.0;
        double tb = totRam / 1.073741824E9;
        String lastValue = twoDecimalForm.format(mb).concat(" MB");
        return lastValue;
    }

    private static String formatFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    private static String getValue(String load) {
        Pattern p = Pattern.compile("(\\d+)");
        System.out.println("..inside getval...." + load);
        Matcher m = p.matcher(load);
        String value = "";
        while (m.find()) {
            value = m.group(1);
        }
        return value;
    }

    private RetryPolicy<String> getRetryPolicy() {
        logger.debug((Object)("retryService:" + this.retryService));
        RetryPolicyTable policyTable = this.retryService.getRetryPolicyTable(1, "");
        RetryPolicy retryPolicy = this.retryService.valueOf(policyTable);
        return retryPolicy;
    }

    public class UserOdbElement {
        Integer count;
        Long timeMillis;
        String path;

        public UserOdbElement(Integer count, Long timeMillis, String path) {
            this.count = count;
            this.timeMillis = timeMillis;
            this.path = path;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Long getTimeMillis() {
            return this.timeMillis;
        }

        public void setTimeMillis(Long timeMillis) {
            this.timeMillis = timeMillis;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

