/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.graphsdk;

import com.parablu.graphsdk.IAuthorizationManager;
import com.parablu.graphsdk.MSGraphHelper;
import com.parablu.graphsdk.TestAuthorizationManager;
import com.parablu.graphsdk.Translator;
import com.parablu.graphsdk.entities.GraphErrorResponse;
import com.parablu.graphsdk.entities.GraphResponse;
import java.io.IOException;
import java.util.Optional;
import javax.net.ssl.SSLException;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphClient {
    static final Logger logger = LoggerFactory.getLogger(GraphClient.class);
    final IAuthorizationManager mgr;
    final MSGraphHelper graphHelper;
    private static GraphClient _this = null;

    private GraphClient(GraphClientBuilder values) throws SSLException {
        this.mgr = values.mgr;
        this.graphHelper = new MSGraphHelper.Builder().authManager(values.mgr).build();
    }

    public MSGraphHelper getGraphHelper() {
        return this.graphHelper;
    }

    public static <A> GraphResponse<A> handleErrorResponse(IOException e, Response r) {
        GraphErrorResponse errorResponse;
        if (r.getStatusCode() > 300) {
            logger.error("HTTP call failed! " + Integer.toString(r.getStatusCode()) + r.getResponseBody());
            errorResponse = Translator.INSTANCE.TranslateToError(r.getStatusCode(), r.getResponseBody());
        } else {
            logger.error("handleError Exception happened: " + e.getMessage());
            logger.error("Non http exception! ");
            errorResponse = new GraphErrorResponse(e.getMessage());
        }
        GraphResponse error = new GraphResponse.Builder().setError(errorResponse).build();
        return error;
    }

    public static void initiateGraphclient() throws SSLException {
        _this = new GraphClientBuilder().authMgr(new TestAuthorizationManager()).proxySetting("127.0.0.1", 8080, 8080).build();
    }

    public static GraphClient getInstance() {
        return _this;
    }

    public static class GraphClientBuilder {
        private IAuthorizationManager mgr;
        Optional<MSGraphHelper.ProxySettings> proxy = Optional.ofNullable(null);

        public GraphClientBuilder authMgr(IAuthorizationManager mgr) {
            this.mgr = mgr;
            return this;
        }

        public GraphClientBuilder proxySetting(String hostVal, int portVal, int securePortVal) {
            this.proxy = Optional.of(new MSGraphHelper.ProxySettings(hostVal, portVal, securePortVal));
            return this;
        }

        public GraphClient build() throws SSLException {
            return new GraphClient(this);
        }
    }
}

