/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.cloudbackup;

import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.parablu.cloudbackup.CloudBackupStorageBridge;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.RestoreBackUpImage;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import com.parablu.pcbd.domain.User;
import com.pg.controller.BaseController;
import com.pg.domain.BackupFile;
import com.pg.domain.FileInfo;
import com.pg.domain.OfficeRestoreFileInfo;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.DownloadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncDownloadService;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.search.FolderTraversal;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.Mailbox;
import microsoft.exchange.webservices.data.search.FindFoldersResults;
import microsoft.exchange.webservices.data.search.FolderView;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public enum OfficeRestoreService {
    GETINST;

    private static final String BACKUP = "BACKUP";
    private static final String COMPLETED = "COMPLETED";
    private static final String RESOURCE = "https://outlook.office365.com";
    private static final String AUTHORITY = "https://login.microsoftonline.com/";
    private static final String EWS_URL = "https://outlook.office365.com/EWS/Exchange.asmx";
    private static final String VERSION = "(Version-";
    private static final String STOPPED_BACKUP_ERROR_CODE = "1207";
    private static final String PAUSED_BACKUP_ERROR_CODE = "1992";
    private static final String STARTED = "STARTED";
    static final Logger logger;
    CloudBackupStorageBridge uploadService;
    UtilService utilServiceObj;
    SyncDownloadService syncDownloadService;
    DownloadService downloadService;
    volatile boolean shutdown = false;
    static final String BASE_FOLDER = "Files/";
    private Set<String> fileUnderProcess = new HashSet<String>();
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    private Set<String> batchUnderProcess = new HashSet<String>();
    private static List<RestoreEvents> batchList;

    public boolean initialize(CloudBackupStorageBridge uploadService, UtilService utilService, SyncDownloadService syncDownloadServiceObj, DownloadService downloadServiceObj) {
        try {
            logger.debug("OffilceRestore service!");
            this.uploadService = uploadService;
            this.utilServiceObj = utilService;
            this.syncDownloadService = syncDownloadServiceObj;
            this.downloadService = downloadServiceObj;
            logger.info("response handler started");
        }
        catch (Exception e) {
            logger.error("Failed to start the consumer! " + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void run() {
        Cloud cloud = this.utilServiceObj.getCloud(1);
        boolean isExchangeBackupEnabled = this.isExchangeBackupEnabled(cloud);
        boolean isOneDriveForBusinessBackupEnabled = this.isOneDriveForBusinessBackupEnabled(cloud);
        logger.debug("Office service...." + isOneDriveForBusinessBackupEnabled);
        if (isOneDriveForBusinessBackupEnabled || isExchangeBackupEnabled) {
            logger.debug("Restore service has started running! - " + Thread.currentThread().getName());
            logger.debug(isExchangeBackupEnabled + "...inside while loop check....odb .." + isOneDriveForBusinessBackupEnabled);
            ExecutorService executor = null;
            try {
                long threadSize = this.utilServiceObj.getThreadSize(cloud.getCloudId(), cloud.getCloudName());
                if (threadSize == 0L) {
                    threadSize = PCHelperConstant.getThreadLimit();
                }
                threadSize = 1L;
                logger.debug(" threads val........" + threadSize);
                int threadSizeVal = (int)threadSize;
                executor = Executors.newFixedThreadPool(threadSizeVal);
                batchList = this.getBatchFromList(cloud.getCloudId());
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                this.checkThreadStatusAndStartUpload(cloud, executor, pool);
                for (int i = 0; i < threadSizeVal; ++i) {
                    logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                    this.callRestoreFiles(cloud, executor, pool);
                }
                logger.debug(" exit upload part..........");
            }
            catch (Exception e) {
                logger.error(" exception in backup upload job......." + e.getMessage());
                logger.trace("exception in backup upload job ......." + e);
            }
            logger.debug("Done!");
        }
    }

    private boolean isExchangeBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private boolean isOneDriveForBusinessBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void callRestoreFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        BaseController.printLogs("Files to restore ............... :", PCHelperConstant.isBrevityLogging());
        Runnable uploadJob = () -> this.restoreFiles(cloud, executor, pool);
        pool.submit(uploadJob, "");
    }

    private void restoreFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        logger.debug("....inside while loop restore..........");
        RestoreEvents restoreEvents = null;
        try {
            restoreEvents = this.getRestoreEventsFromOneDriveServer();
            if (restoreEvents != null) {
                this.restoreBatch(restoreEvents, cloud);
                logger.error(restoreEvents.getActionOnDeviceUUID() + " %%%%%%% restore completed for file ....");
            } else {
                BaseController.printLogs("... no events for restore...", PCHelperConstant.isBrevityLogging());
            }
            if (!CollectionUtils.isEmpty(batchList)) {
                logger.debug("Thread ready for next File .... " + batchList.size());
            }
        }
        catch (Exception e) {
            logger.error("exception inside storageservice .... " + e.getMessage());
            logger.trace("exception inside storageservice ...." + e);
        }
        if (restoreEvents != null && restoreEvents.getId() != null) {
            this.batchUnderProcess.remove(restoreEvents.getId().toString());
        }
        BaseController.printLogs("no files to upload so wait and then retry>>>>", PCHelperConstant.isBrevityLogging());
        logger.error("no files to upload so wait and then retry>>>>");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.callRestoreFiles(cloud, executor, pool);
    }

    public void restoreBatch(RestoreEvents restoreEvents, Cloud cloudval) {
        List<OfficeRestoreFileInfo> fileInfoList;
        int cloudId = cloudval.getCloudId();
        logger.debug("... inside-restore ....." + restoreEvents.getId());
        String deviceUUID = restoreEvents.getActionOnDeviceUUID();
        BackupBatch backupBatch = new BackupBatch();
        BeanUtils.copyProperties((Object)restoreEvents, (Object)backupBatch);
        backupBatch.setId(restoreEvents.getId());
        String policyName = backupBatch.getOdbPolicyName();
        backupBatch.setUserName(restoreEvents.getActionBy());
        BackupBatch pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), backupBatch.getId().toString());
        int uploadedFiles = 0;
        if (pbBkpBatch != null) {
            String[] parts = pbBkpBatch.getUploadedFiles().split("/");
            try {
                uploadedFiles = Integer.parseInt(parts[0]);
            }
            catch (Exception e) {
                logger.trace("Exception  :" + e);
                logger.error("Exception  :" + e.getMessage());
            }
        }
        logger.debug("....prev files ... " + uploadedFiles);
        Device device = this.utilServiceObj.getDeviceForUUID(cloudId, deviceUUID);
        boolean isOutlookDevice = false;
        ExchangeService service = null;
        HashMap<String, String> existingFolders = new HashMap();
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            isOutlookDevice = true;
            EWSAppSetting appSetting = this.utilServiceObj.getEwsAppSettingDetail(cloudId);
            if (appSetting == null || StringUtils.isEmpty((String)appSetting.getAccountId())) {
                String clientId = "bfbe8c43-6b60-41b8-8ab2-9b60074f23c3";
                String clientSecret = "?se_cQBB@euT61E?JfqA3aic6[OqhtON";
                String tenantId = "a53329c6-582f-48e5-b286-15e6bcc658b0";
                logger.debug(clientId + ".....clientid + clientSecret... " + clientSecret);
                appSetting = new EWSAppSetting();
                appSetting.setClientId(clientId);
                appSetting.setClientSecret(clientSecret);
                appSetting.setTenantId(tenantId);
                this.utilServiceObj.saveEwsAppSetting(cloudId, appSetting);
            }
            String token = OfficeRestoreService.getEWSAccesToken(appSetting);
            service = OfficeRestoreService.getAuthenticatedService(token, appSetting.getAccountId());
            existingFolders = OfficeRestoreService.getExistingFolders(service, device.getUserName());
        }
        String cloudName = cloudval.getCloudName();
        String userName = restoreEvents.getUserName();
        BackUpImage backupImage = null;
        if (!restoreEvents.isDevice() && (backupImage = this.downloadService.getBackupImageForId(cloudval.getCloudId(), device, restoreEvents.getFileInfo().getId())) == null) {
            logger.debug("...... no file to restore....");
            return;
        }
        boolean isFolder = false;
        boolean isDevice = false;
        String restoreFolder = "";
        if (restoreEvents.isDevice()) {
            isDevice = true;
        } else if (backupImage.isFolder()) {
            if (!StringUtils.isEmpty((String)backupImage.getFileName()) && StringUtils.isEmpty((String)backupImage.getDevicePath()) && backupImage.getFileName().equalsIgnoreCase("Files")) {
                isDevice = true;
            } else {
                isFolder = true;
            }
        }
        logger.debug("......device or folder or file..." + isDevice + "...." + isFolder);
        restoreFolder = isDevice ? "All Folders" : (isFolder ? backupImage.getDevicePath() + "/" + backupImage.getFileName() : backupImage.getDevicePath() + "/" + backupImage.getFileName());
        if (restoreFolder.startsWith("null/")) {
            restoreFolder = restoreFolder.replaceAll("null/", "");
        }
        HashSet<String> folderSet = new HashSet<String>();
        if (pbBkpBatch == null) {
            RestoreBackUpImage restoreBackUpImage = new RestoreBackUpImage();
            if (backupImage != null) {
                BeanUtils.copyProperties((Object)backupImage, (Object)restoreBackUpImage);
            }
            this.updateAllFilesforRestore(restoreEvents, cloudval, cloudId, device, cloudName, userName, restoreBackUpImage, isFolder, isDevice, folderSet);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(fileInfoList = this.getOfficeRestoreFileInfoFromListForBatchId(1, restoreEvents.getId().toString()))) {
            fileInfoList = new ArrayList<OfficeRestoreFileInfo>();
            logger.debug(".... no files to process for batch ... ");
        }
        long totalSizeToUpload = 0L;
        for (OfficeRestoreFileInfo fileInfo : fileInfoList) {
            totalSizeToUpload += fileInfo.getSize();
        }
        if (device.getOsType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            totalSizeToUpload /= 1024L;
        }
        logger.debug("....total size to restore fdf.&*&*... " + totalSizeToUpload);
        backupBatch.setTotalSizeToUpload(totalSizeToUpload);
        if (pbBkpBatch != null) {
            backupBatch.setTotalSizeToUpload(pbBkpBatch.getTotalSizeToUpload());
            backupBatch.setTotalNoOfFiles(pbBkpBatch.getTotalNoOfFiles());
        } else {
            backupBatch.setTotalNoOfFiles("" + fileInfoList.size());
        }
        backupBatch.setDeviceUUID(device.getDeviceUUID());
        this.startBackupBatch(backupBatch, cloudval, uploadedFiles);
        logger.debug(".... ss before save history...." + backupBatch.getUserName());
        String restorePath = "";
        boolean restoredInDiffPath = false;
        if (restoreEvents.isInPlaceRestore()) {
            restorePath = "In place Restore";
            restoredInDiffPath = true;
        } else {
            restorePath = restoreEvents.getDestinationPath();
        }
        String destinationDeviceUUID = restoreEvents.getDestinationDeviceUUID();
        logger.debug("..... device before restore..... " + destinationDeviceUUID);
        Device destDevice = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID());
        logger.debug("..... device after..... " + destDevice);
        logger.debug(".....#restoreFolder# 1..." + restoreFolder);
        backupBatch.setId(restoreEvents.getId());
        NotifierEmailBodyElement notifierEmailBodyElement = new NotifierEmailBodyElement();
        notifierEmailBodyElement.setDeviceName(device.getDeviceName());
        notifierEmailBodyElement.setRestoreFolder(restoreFolder);
        User user = this.utilServiceObj.getUserInfoByName(cloudId, userName);
        this.saveRestoreHistory(cloudId, restoreFolder, backupBatch, "" + totalSizeToUpload, restorePath, restoredInDiffPath, device, destDevice, cloudName, notifierEmailBodyElement, user);
        logger.debug(".....#restoreFolder# 2..." + restoreEvents.getId() + "...batch..." + backupBatch);
        int totalNoOfFilesToRestore = Integer.parseInt(backupBatch.getTotalNoOfFiles());
        this.saveRestoreProgress(cloudId, device, fileInfoList, restoreEvents.getActionBy(), restoreEvents.getId().toString(), totalNoOfFilesToRestore);
        logger.debug(restoreEvents.getActionOnDeviceUUID() + "....deviceuuid..." + restoreEvents.getDestinationDeviceUUID());
        RestoreProgressEvents restoreProgressEvents = this.utilServiceObj.getRestoreProgresByDeviceUUID(cloudId, device.getDeviceUUID(), restoreEvents.getActionBy());
        logger.debug(restoreProgressEvents.getRestoredFiles() + "....after save history ...." + fileInfoList.size());
        int errorCode = 0;
        Iterator<OfficeRestoreFileInfo> iterator = fileInfoList.iterator();
        int restoredFiles = (int)restoreProgressEvents.getRestoredFiles();
        long restoredSize = 0L;
        String currentRestorePath = "";
        long currentFolderRestoredFiles = 0L;
        boolean isBatchStopped = false;
        boolean isFoldersCreated = false;
        while (iterator.hasNext()) {
            OfficeRestoreFileInfo item = iterator.next();
            RestoreEvents restoreEventsObj = this.utilServiceObj.getRestoreEventByUUID(cloudId, restoreEvents.getDestinationDeviceUUID());
            if (restoreEventsObj == null) {
                logger.error("... cancel the restore....");
                isBatchStopped = true;
                continue;
            }
            pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), backupBatch.getId().toString());
            if (pbBkpBatch != null && StringUtils.isNotEmpty((String)pbBkpBatch.getErrorCode()) && (pbBkpBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) || pbBkpBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE))) {
                errorCode = pbBkpBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) ? Integer.parseInt(STOPPED_BACKUP_ERROR_CODE) : Integer.parseInt(PAUSED_BACKUP_ERROR_CODE);
                if (errorCode > 0) break;
                logger.debug(".....batch status current..." + pbBkpBatch.getErrorCode());
            }
            logger.debug(backupBatch.getId().toString() + "...inside while loop after msg ... " + item);
            try {
                String finalPath;
                String customPath;
                String path;
                BackUpImage bkpImage = this.utilServiceObj.getBackupImageFile(cloudId, item.getBackupId(), destDevice);
                BackupFile backupFile = this.utilServiceObj.getBackupFileForId(cloudval.getCloudId(), userName, item.getBackupId());
                if (!StringUtils.isEmpty((String)item.getFileName())) {
                    backupFile.setFileName(item.getFileName());
                }
                logger.debug(item.getFileName() + "...trying to download ... " + backupFile.getEwsId());
                if (isOutlookDevice) {
                    Object device2;
                    path = backupFile.getFilePath();
                    if (!StringUtils.isEmpty((String)restoreEvents.getDestinationPath())) {
                        customPath = restoreEvents.getDestinationPath();
                        if (customPath.startsWith("/")) {
                            customPath = customPath.substring(1);
                        }
                        customPath = FilenameUtils.separatorsToUnix((String)customPath);
                        customPath = customPath.replaceAll("//", "/");
                        logger.debug(restoreEvents.isDevice() + "....eventsss..." + restoreEvents.getFileInfo().isFolder());
                        if (restoreEvents.isDevice()) {
                            path = customPath + "/" + path;
                        } else if (restoreEvents.getFileInfo() != null && !restoreEvents.getFileInfo().isFolder()) {
                            path = customPath;
                        } else if (restoreEvents.getFileInfo() != null && restoreEvents.getFileInfo().isFolder()) {
                            logger.debug("..folderest.....");
                            if (backupImage != null) {
                                logger.debug("..folderest1....." + backupImage.getFileName());
                                finalPath = path.substring(path.indexOf(backupImage.getFileName()));
                                logger.debug(".....final path ....." + finalPath.trim());
                                path = customPath + "/" + finalPath;
                            }
                        }
                    }
                    userName = backupFile.getUserName();
                    User userObj = this.utilServiceObj.getUserInfoByName(1, userName);
                    String userMail = userObj.getEmailId();
                    if (!StringUtils.isEmpty((String)userObj.getOdbLoginId())) {
                        userMail = userObj.getOdbLoginId();
                    }
                    String mailUserName = userMail;
                    if (!restoreEvents.getActionOnDeviceUUID().equalsIgnoreCase(restoreEvents.getDestinationDeviceUUID()) && (device2 = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID())) != null) {
                        userObj = this.utilServiceObj.getUserInfoByName(1, device2.getUserName());
                        userMail = userObj.getEmailId();
                        if (!StringUtils.isEmpty((String)userObj.getOdbLoginId())) {
                            userMail = userObj.getOdbLoginId();
                        }
                        mailUserName = userMail;
                    }
                    logger.debug(".....DOWNLOADCHUNKS...." + path + "...");
                    if (!isFoldersCreated) {
                        device2 = folderSet.iterator();
                        while (device2.hasNext()) {
                            String exiFolder = (String)device2.next();
                            if (!StringUtils.isEmpty((String)restoreEvents.getDestinationPath())) {
                                String customPath2 = restoreEvents.getDestinationPath();
                                customPath2 = FilenameUtils.separatorsToUnix((String)customPath2);
                                if ((customPath2 = customPath2.replaceAll("//", "/")).startsWith("/")) {
                                    customPath2 = customPath2.substring(1);
                                }
                                customPath2 = FilenameUtils.separatorsToUnix((String)customPath2);
                                customPath2 = customPath2.replaceAll("//", "/");
                                if (restoreEvents.isDevice()) {
                                    exiFolder = customPath2 + "/" + exiFolder;
                                } else if (restoreEvents.getFileInfo() != null && !restoreEvents.getFileInfo().isFolder()) {
                                    exiFolder = customPath2;
                                } else if (restoreEvents.getFileInfo() != null && restoreEvents.getFileInfo().isFolder()) {
                                    logger.debug("..folderest22.....");
                                    if (backupImage != null) {
                                        logger.debug("..folderest33....." + backupImage.getFileName());
                                        String finalPath2 = path.substring(path.indexOf(backupImage.getFileName()));
                                        logger.debug(".....final path ....." + finalPath2.trim());
                                        exiFolder = customPath2 + "/" + finalPath2;
                                    }
                                }
                            }
                            logger.debug("....exifolder values.." + exiFolder);
                            String idForFolder = "";
                            try {
                                existingFolders = OfficeRestoreService.getExistingFolders(service, mailUserName);
                                idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, exiFolder);
                                if (StringUtils.isEmpty((String)idForFolder)) {
                                    this.createFoldersInMail(service, existingFolders, exiFolder, mailUserName);
                                    existingFolders = new HashMap();
                                    existingFolders = OfficeRestoreService.getExistingFolders(service, mailUserName);
                                    idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, exiFolder);
                                }
                            }
                            catch (Exception e) {
                                this.createFoldersInMail(service, existingFolders, exiFolder, mailUserName);
                                existingFolders = new HashMap();
                                existingFolders = OfficeRestoreService.getExistingFolders(service, mailUserName);
                                idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, exiFolder);
                            }
                            logger.debug("... exist id exists .. " + idForFolder);
                            isFoldersCreated = true;
                        }
                    }
                    if (path.contains("Tasks") || path.contains("Contacts")) {
                        if (path.contains("Contacts")) {
                            logger.debug("... trying to restore contacts ....");
                            this.syncDownloadService.inPlaceRestoreForContactFromCloud(cloudval, userName, mailUserName, backupFile, device.getDestCollection(), bkpImage.getOdItemId());
                        } else {
                            logger.debug(".. trying to restore tasks..... ");
                            boolean differentDest = false;
                            if (!destDevice.getDeviceName().equalsIgnoreCase(device.getDeviceName())) {
                                differentDest = true;
                            }
                            this.syncDownloadService.inPlaceRestoreForTasksFromCloud(cloudval, userName, mailUserName, backupFile, device.getDestCollection(), bkpImage.getOdItemId(), differentDest);
                        }
                    } else {
                        String idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, path);
                        if (StringUtils.isEmpty((String)idForFolder)) {
                            logger.debug("..idforfolder is empty so create...");
                            try {
                                existingFolders = OfficeRestoreService.getExistingFolders(service, mailUserName);
                                idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, path);
                                if (StringUtils.isEmpty((String)idForFolder)) {
                                    this.createFoldersInMail(service, existingFolders, path, mailUserName);
                                    existingFolders = new HashMap();
                                    existingFolders = OfficeRestoreService.getExistingFolders(service, mailUserName);
                                    idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, path);
                                }
                            }
                            catch (Exception e) {
                                this.createFoldersInMail(service, existingFolders, path, mailUserName);
                                existingFolders = new HashMap();
                                existingFolders = OfficeRestoreService.getExistingFolders(service, mailUserName);
                                idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, path);
                            }
                        }
                        logger.debug(idForFolder + "..." + path + "..DOWNLOADCHUNKS for user...." + userName + "..." + mailUserName);
                        this.syncDownloadService.inPlaceRestoreForExchangeFromCloud(cloudval, userName, mailUserName, backupFile, idForFolder, device.getDestCollection());
                    }
                } else {
                    Device device2;
                    path = backupFile.getFilePath();
                    if (!StringUtils.isEmpty((String)restoreEvents.getDestinationPath())) {
                        customPath = restoreEvents.getDestinationPath();
                        if (customPath.startsWith("/")) {
                            customPath = customPath.substring(1);
                        }
                        customPath = FilenameUtils.separatorsToUnix((String)customPath);
                        customPath = customPath.replaceAll("//", "/");
                        logger.debug(restoreEvents.isDevice() + "....eventsss..." + restoreEvents.getFileInfo().isFolder());
                        logger.debug("...beforecustompath..." + customPath);
                        customPath = customPath.replaceAll(" ", "%20");
                        logger.debug("...aftercustompath..." + customPath);
                        if (restoreEvents.isDevice()) {
                            path = customPath + "/" + path;
                        } else if (restoreEvents.getFileInfo() != null && !restoreEvents.getFileInfo().isFolder()) {
                            path = customPath;
                        } else if (restoreEvents.getFileInfo() != null && restoreEvents.getFileInfo().isFolder()) {
                            logger.debug("..folderest.....");
                            if (backupImage != null) {
                                logger.debug("..folderest1....." + backupImage.getFileName());
                                finalPath = path.substring(path.indexOf(backupImage.getFileName()));
                                logger.debug(".....final path ....." + finalPath.trim());
                                path = customPath + "/" + finalPath;
                            }
                        }
                    }
                    String drivUserName = userName;
                    if (!restoreEvents.getActionOnDeviceUUID().equalsIgnoreCase(restoreEvents.getDestinationDeviceUUID()) && (device2 = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID())) != null) {
                        drivUserName = device2.getUserName();
                    }
                    logger.debug(restoreEvents.isInPlaceRestore() + "..... beforepath...." + path);
                    if (restoreEvents.isInPlaceRestore()) {
                        path = path.replaceFirst("Files", "");
                    }
                    logger.debug("..... afterpath...." + path);
                    if (bkpImage != null && StringUtils.isEmpty((String)bkpImage.getStoragePlace())) {
                        FileInfo fileInfo = this.downloadService.getFileFromPG(cloudId, userName, backupFile.getId().toString());
                        logger.debug("..... file is in pg....." + path);
                        this.syncDownloadService.inPlaceRestoreForOndriveFromPg(cloudval, backupFile, fileInfo, path, drivUserName);
                    } else {
                        logger.debug("..... file is in cloud....." + path);
                        this.syncDownloadService.inPlaceRestoreForOndriveFromCloud(cloudval, backupFile, path, drivUserName);
                    }
                }
                ++restoredFiles;
                logger.debug(".......devpath1..." + currentRestorePath + "...." + backupFile.getFilePath());
                if (StringUtils.isEmpty((String)currentRestorePath) || !currentRestorePath.equalsIgnoreCase(backupFile.getFilePath())) {
                    currentFolderRestoredFiles = 0L;
                    currentRestorePath = backupFile.getFilePath();
                    this.utilServiceObj.updateCurrentRestoreProgressPath(cloudId, currentFolderRestoredFiles, currentRestorePath, deviceUUID);
                }
                if (currentRestorePath.equalsIgnoreCase(backupFile.getFilePath())) {
                    ++currentFolderRestoredFiles;
                }
                restoredSize += item.getSize();
                if (restoredFiles % 3 == 0 || fileInfoList.size() < 3) {
                    this.utilServiceObj.updateRestoreProgress(cloudId, restoredFiles, (int)restoredSize, currentFolderRestoredFiles, currentRestorePath, deviceUUID, backupFile.getFileName(), restoreEvents.getActionBy());
                }
            }
            catch (Exception e) {
                logger.error("Failed to handle the message!", (Throwable)e);
                this.fileUnderProcess.remove(item.getBackupId().toString());
            }
            logger.debug(uploadedFiles + ".... before deleting batchid check..... " + backupBatch.getId());
            this.updateBackupBatch(backupBatch, cloudval, 1, item.getSize());
            this.utilServiceObj.removeOfficeRestoreDriveItem(cloudId, item.getId());
            logger.debug(item.getId() + ".. batch id completed...." + backupBatch.getId());
            if (iterator.hasNext()) continue;
            this.utilServiceObj.removeRestoreProgress(cloudId, restoreEvents.getDestinationDeviceUUID());
            this.utilServiceObj.deleteRestoreEventForDeviceUUID(cloudId, restoreEvents.getDestinationDeviceUUID(), policyName);
            this.batchUnderProcess.remove(backupBatch.getId().toString());
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), errorCode);
            DeviceBackupOverView overView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            long noOfSuccessfulRestores = overView.getNoOfSuccessfulRestores();
            overView.setNoOfSuccessfulRestores(noOfSuccessfulRestores + 1L);
            this.utilServiceObj.updateDeviceBackupOverView(cloudId, overView);
            logger.debug(backupBatch.getTotalNoOfFiles() + "..  completed...." + backupBatch.getId());
        }
        logger.debug("....error code..... " + errorCode);
        if (isBatchStopped) {
            for (OfficeRestoreFileInfo item : fileInfoList) {
                this.utilServiceObj.removeOfficeRestoreDriveItem(cloudId, item.getId());
            }
            this.utilServiceObj.deleteMailRestoreBatch(cloudId, backupBatch.getId(), policyName);
            errorCode = 1207;
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), "ABORTED", backupBatch.getDeviceUUID(), errorCode);
            this.batchUnderProcess.remove(backupBatch.getId().toString());
        } else if (org.apache.commons.collections.CollectionUtils.isEmpty(fileInfoList)) {
            this.utilServiceObj.deleteMailRestoreBatch(cloudId, backupBatch.getId(), policyName);
            this.batchUnderProcess.remove(backupBatch.getId().toString());
            logger.debug(backupBatch.getDeviceUUID() + ".... update batch ... " + backupBatch.getId());
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), errorCode);
            this.utilServiceObj.removeRestoreProgress(cloudId, restoreEvents.getDestinationDeviceUUID());
        } else {
            logger.debug(".. debug bug .. 2450 .." + org.apache.commons.collections.CollectionUtils.isEmpty(fileInfoList));
        }
        BackupBatch batch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), backupBatch.getId().toString());
        if (batch != null) {
            logger.debug("....restored size..... " + batch.getUploadedSize());
            logger.debug(".....#restoreFolder#..." + restoreFolder);
            this.saveRestoreHistory(cloudId, restoreFolder, backupBatch, "" + batch.getUploadedSize(), restorePath, restoredInDiffPath, device, destDevice, "", null, null);
        }
        this.utilServiceObj.deleteRestoreEventForDeviceUUID(cloudId, restoreEvents.getDestinationDeviceUUID(), policyName);
        this.utilServiceObj.removeRestoreProgress(cloudId, restoreEvents.getActionOnDeviceUUID());
        logger.debug("....deletedevents..... " + restoreEvents.getDestinationDeviceUUID() + "..." + restoreEvents.getActionOnDeviceUUID());
    }

    private void updateAllFilesforRestore(RestoreEvents restoreEvents, Cloud cloudval, int cloudId, Device device, String cloudName, String userName, RestoreBackUpImage backupImage, boolean isFolder, boolean isDevice, Set<String> folderSet) {
        if (isFolder) {
            logger.debug("...issFOLDER .backupFile..." + backupImage.getId());
            ArrayList<RestoreBackUpImage> backupImages = new ArrayList<RestoreBackUpImage>();
            backupImages.add(backupImage);
            if (!StringUtils.isEmpty((String)backupImage.getDevicePath())) {
                logger.debug("... filespath not empty ...");
                this.downloadService.getAllFolderChildrenByDevicePathLatest(cloudName, userName, backupImage.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImage.getFileName(), device, cloudId, backupImages);
            } else {
                logger.debug("... filespath empty ...");
                this.downloadService.getAllFolderChildrenByDevicePathLatest(cloudName, userName, backupImage.getFileName(), device, cloudId, backupImages);
            }
            logger.debug(".....isfolder files... " + backupImages.size());
            this.updateFilesForRestore(restoreEvents, cloudId, device, cloudName, userName, backupImages, restoreEvents.getRestoreDataBefore(), folderSet);
        } else if (isDevice) {
            ArrayList<RestoreBackUpImage> backupImagesList = new ArrayList<RestoreBackUpImage>();
            List<RestoreBackUpImage> backupImages = this.downloadService.getBaseFoldersForDeviceLatest(cloudval.getCloudId(), device);
            backupImagesList.addAll(backupImages);
            logger.debug("..... isDEVICE basefolderss... " + backupImagesList.size());
            for (RestoreBackUpImage backupImageObj : backupImages) {
                if (!StringUtils.isEmpty((String)backupImageObj.getDevicePath())) {
                    logger.debug("... filespath not empty ...");
                    this.downloadService.getAllFolderChildrenByDevicePathLatest(cloudName, userName, backupImageObj.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImageObj.getFileName(), device, cloudId, backupImagesList);
                    continue;
                }
                logger.debug("... filespath empty ...");
                this.downloadService.getAllFolderChildrenByDevicePathLatest(cloudName, userName, backupImageObj.getFileName(), device, cloudId, backupImagesList);
            }
            this.updateFilesForRestore(restoreEvents, cloudId, device, cloudName, userName, backupImagesList, restoreEvents.getRestoreDataBefore(), folderSet);
        } else {
            BackupFile backupFile = this.utilServiceObj.getBackupFileForId(cloudval.getCloudId(), userName, restoreEvents.getFileInfo().getId());
            logger.debug(backupFile.getLastServerModifiedTime() + "....isFILEEEE.lastservermodified check..... " + backupFile.getLastServerModifiedTime());
            logger.debug("..file restore ... " + restoreEvents.isRestoreAllVersions());
            if (restoreEvents.isRestoreAllVersions()) {
                this.storeRestoreElementsForAllVersions(restoreEvents, cloudId, device, backupImage);
            } else {
                boolean restoreAllowed = true;
                if (restoreEvents.getRestoreDataBefore() > 0L && backupFile.getLastServerModifiedTime() > restoreEvents.getRestoreDataBefore()) {
                    restoreAllowed = false;
                }
                if (restoreAllowed) {
                    OfficeRestoreFileInfo officeRestoreFileInfo = new OfficeRestoreFileInfo();
                    officeRestoreFileInfo.setBackupId(backupFile.getBackupId().toString());
                    officeRestoreFileInfo.setFileName(backupImage.getFileName());
                    officeRestoreFileInfo.setRestoreEventId(restoreEvents.getId().toString());
                    officeRestoreFileInfo.setOdItemId(backupImage.getOdItemId());
                    officeRestoreFileInfo.setFilePath(backupImage.getDevicePath());
                    officeRestoreFileInfo.setSize(backupImage.getSize() * 1024L);
                    officeRestoreFileInfo.setDeviceUUID(backupImage.getDeviceUUID());
                    folderSet.add(backupFile.getFilePath());
                    this.utilServiceObj.saveOfficeRestoreFileInfo(cloudId, officeRestoreFileInfo);
                }
            }
        }
    }

    long getTotalSize(List<OfficeRestoreFileInfo> fileInfoList) {
        long totalSize = 0L;
        for (OfficeRestoreFileInfo fileInfo : fileInfoList) {
            totalSize += fileInfo.getSize();
        }
        return totalSize;
    }

    void saveRestoreProgress(int cloudId, Device device, List<OfficeRestoreFileInfo> fileInfoList, String actionBy, String batchId, int totalNoOfFilesForRestore) {
        RestoreProgressEvents restoreProgressEvents = this.utilServiceObj.getRestoreProgresByDeviceUUID(cloudId, device.getDeviceUUID(), actionBy);
        long totalSize = this.getTotalSize(fileInfoList);
        if (restoreProgressEvents == null) {
            restoreProgressEvents = new RestoreProgressEvents();
        } else {
            restoreProgressEvents.setId(restoreProgressEvents.getId());
        }
        restoreProgressEvents.setTotalNoOfFilesForRestore((long)totalNoOfFilesForRestore);
        restoreProgressEvents.setDeviceUUID(device.getDeviceUUID());
        restoreProgressEvents.setUserName(actionBy);
        restoreProgressEvents.setBatchId(batchId);
        this.utilServiceObj.saveRestoreProgressForDevice(cloudId, restoreProgressEvents);
    }

    private void createFoldersInMail(ExchangeService service, Map<String, String> existingFolders, String exiFolder, String userMail) {
        Path pathsp = Paths.get(exiFolder, new String[0]);
        String[] paths = (String[])StreamSupport.stream(pathsp.spliterator(), false).map(Path::toString).toArray(String[]::new);
        String checkPath = "";
        boolean isParent = false;
        for (String folPath : paths) {
            System.out.println("..... aaa .... " + folPath);
            if (!StringUtils.isEmpty((String)checkPath)) {
                checkPath = checkPath + "/" + folPath;
            } else {
                checkPath = folPath;
                isParent = true;
            }
            boolean pathExists = existingFolders.containsValue(checkPath);
            logger.debug(checkPath + ".....pathexists.... " + pathExists);
            if (!pathExists) {
                try {
                    if (isParent) {
                        Folder folder = new Folder(service);
                        folder.setDisplayName(checkPath.replaceAll("/", ""));
                        Mailbox userMailboxObj = new Mailbox(userMail);
                        FolderId parentId = new FolderId(WellKnownFolderName.MsgFolderRoot, userMailboxObj);
                        service.createFolder(folder, parentId);
                    } else {
                        String parentpath = checkPath.substring(0, checkPath.lastIndexOf(47));
                        String child = checkPath.substring(checkPath.lastIndexOf(47));
                        System.out.println(parentpath + "..." + child);
                        Folder folder = new Folder(service);
                        folder.setDisplayName(child.replaceAll("/", ""));
                        FolderId parentId = new FolderId();
                        String keyFromValue = OfficeRestoreService.getKeyFromValue(existingFolders, parentpath);
                        parentId.setUniqueId(keyFromValue);
                        service.createFolder(folder, parentId);
                    }
                    existingFolders = new HashMap<String, String>();
                    existingFolders = OfficeRestoreService.getExistingFolders(service, userMail);
                }
                catch (Exception e1) {
                    logger.error("... ERRORR...... " + e1.getMessage());
                }
            }
            isParent = false;
        }
    }

    public static String getKeyFromValue(Map<String, String> folderMap, Object value) {
        for (String key : folderMap.keySet()) {
            if (!folderMap.get(key).equals(value)) continue;
            return key;
        }
        return null;
    }

    public static synchronized String getEWSAccesToken(EWSAppSetting ewsAppSetting) {
        String accessToken = "";
        try {
            long now = System.currentTimeMillis();
            ExecutorService es = Executors.newFixedThreadPool(2);
            AuthenticationContext context = new AuthenticationContext(AUTHORITY + ewsAppSetting.getTenantId(), false, es);
            AuthenticationCallback callback = new AuthenticationCallback(){

                public void onSuccess(AuthenticationResult result) {
                    logger.debug("received token");
                }

                public void onFailure(Throwable exc) {
                    throw new RuntimeException(exc);
                }
            };
            logger.debug("requesting token");
            Future future = context.acquireToken(RESOURCE, new ClientCredential(ewsAppSetting.getClientId(), ewsAppSetting.getClientSecret()), callback);
            AuthenticationResult result = (AuthenticationResult)future.get(30L, TimeUnit.SECONDS);
            accessToken = result.getAccessToken();
        }
        catch (Exception e) {
            logger.error("... ERRORR...... " + e.getMessage());
        }
        return accessToken;
    }

    public static ExchangeService getAuthenticatedService(String token, String senderAddr) {
        ExchangeService service = null;
        try {
            service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
            service.getHttpHeaders().put("Authorization", "Bearer " + token);
            service.getHttpHeaders().put("X-AnchorMailbox", senderAddr);
            service.setUrl(new URI(EWS_URL));
            service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.PrincipalName, senderAddr));
        }
        catch (Exception e) {
            logger.error("... ERRORR...... " + e.getMessage());
        }
        return service;
    }

    private static Map<String, String> getExistingFolders(ExchangeService service, String userMail) {
        HashMap<String, String> folderMap = new HashMap<String, String>();
        try {
            FolderView folderView = new FolderView(100);
            FolderId folderIds = new FolderId(WellKnownFolderName.MsgFolderRoot, new Mailbox(userMail));
            folderView.setTraversal(FolderTraversal.Deep);
            FindFoldersResults findFolders = service.findFolders(folderIds, folderView);
            for (Folder folder : findFolders.getFolders()) {
                String parentName;
                String folderName = folder.getDisplayName();
                if (folder.getParentFolderId() != null && !StringUtils.isEmpty((String)(parentName = (String)folderMap.get(folder.getParentFolderId().getUniqueId())))) {
                    folderName = parentName + "/" + folderName;
                }
                folderMap.put(folder.getId().getUniqueId(), folderName);
            }
        }
        catch (Exception e) {
            logger.error("... ERRORR...... " + e.getMessage());
        }
        return folderMap;
    }

    private void storeRestoreElementsForAllVersions(RestoreEvents restoreEvents, int cloudId, Device device, RestoreBackUpImage backupImage) {
        HashedMap fileVersionMapTemp = new HashedMap();
        List<BackUpImage> backUpImages = this.utilServiceObj.getAllVersionsFromBackupImage(cloudId, backupImage.getDevicePath(), backupImage.getFileName(), device);
        logger.debug(".....versions.... " + backUpImages.size());
        for (BackUpImage backUpImage : backUpImages) {
            String mapKey = backUpImage.getDevicePath() + backUpImage.getFileName();
            if (fileVersionMapTemp.containsKey(mapKey)) {
                String newFileName;
                Long versionVal = (Long)fileVersionMapTemp.get(mapKey);
                fileVersionMapTemp.remove(mapKey);
                long newVersion = versionVal + 1L;
                fileVersionMapTemp.put(mapKey, newVersion);
                if (StringUtils.isNotEmpty((String)FilenameUtils.getExtension((String)backUpImage.getFileName()))) {
                    int lastDot = backUpImage.getFileName().lastIndexOf(46);
                    newFileName = backUpImage.getFileName().substring(0, lastDot) + VERSION + newVersion + ")" + backUpImage.getFileName().substring(lastDot);
                } else {
                    newFileName = backUpImage.getFileName() + VERSION + newVersion + ")";
                }
                logger.debug(".....new file name ... " + newFileName);
                backUpImage.setFileName(newFileName);
                continue;
            }
            fileVersionMapTemp.put(mapKey, 1L);
        }
        for (BackUpImage image : backUpImages) {
            boolean restoreAllowed = true;
            if (restoreEvents.getRestoreDataBefore() > 0L && image.getLastServerModifiedTime() > restoreEvents.getRestoreDataBefore()) {
                restoreAllowed = false;
            }
            if (!restoreAllowed) continue;
            OfficeRestoreFileInfo officeRestoreFileInfo = new OfficeRestoreFileInfo();
            officeRestoreFileInfo.setBackupId(image.getId().toString());
            officeRestoreFileInfo.setFileName(image.getFileName());
            officeRestoreFileInfo.setRestoreEventId(restoreEvents.getId().toString());
            officeRestoreFileInfo.setOdItemId(backupImage.getOdItemId());
            officeRestoreFileInfo.setSize(backupImage.getSize());
            officeRestoreFileInfo.setFilePath(backupImage.getDevicePath());
            this.utilServiceObj.saveOfficeRestoreFileInfo(cloudId, officeRestoreFileInfo);
        }
    }

    private void updateRestoreHistoryValues(BackupBatch backupBatch, Device device, String totalSizeRestore, String destFolder, boolean restoredInDiffPath, RestoreHistory restoreHistoy, Device destDevice) {
        restoreHistoy.setUserName(device.getUserName());
        restoreHistoy.setDeviceName(device.getDeviceName());
        restoreHistoy.setDeviceUUID(device.getDeviceUUID());
        restoreHistoy.setRestoreByDeviceName(destDevice.getDeviceName());
        restoreHistoy.setRestoreByUserName(backupBatch.getUserName());
        restoreHistoy.setRestoreByDeviceUUID(destDevice.getDeviceUUID());
        restoreHistoy.setRestoredSize(totalSizeRestore);
        restoreHistoy.setDestFolder(destFolder);
        restoreHistoy.setRestoredInDiffPath(restoredInDiffPath);
    }

    private void saveRestoreHistory(int cloudId, String restoreFolder, BackupBatch backupBatch, String totalSizeRestore, String destFolder, boolean restoredInDiffPath, Device device, Device destDevice, String cloudName, NotifierEmailBodyElement notifierEmailBodyElement, User user1) {
        RestoreHistory restoreHistoy = new RestoreHistory();
        try {
            if (backupBatch.getId() != null) {
                RestoreHistory history = this.utilServiceObj.getRestoreHistoryById(cloudId, backupBatch.getId());
                if (history == null) {
                    logger.debug(destDevice.getDeviceName() + "...totalSizeRestore...." + totalSizeRestore);
                    BeanUtils.copyProperties((Object)backupBatch, (Object)restoreHistoy);
                    if (!StringUtils.isEmpty((String)restoreFolder)) {
                        restoreHistoy.setRestoreFolder(restoreFolder);
                    }
                    this.updateRestoreHistoryValues(backupBatch, device, totalSizeRestore, destFolder, restoredInDiffPath, restoreHistoy, destDevice);
                    this.utilServiceObj.saveRestoreHistory(cloudId, restoreHistoy);
                    this.sendEmailForRestore(cloudId, device, cloudName, notifierEmailBodyElement, user1, destDevice, restoreHistoy.getRestoreByUserName());
                } else {
                    logger.debug("......restore history already exists :" + backupBatch.getId() + "...." + backupBatch.getStatus());
                    history.setDestFolder(destFolder);
                    restoreHistoy.setRestoredInDiffPath(restoredInDiffPath);
                    this.utilServiceObj.saveRestoreHistory(cloudId, history);
                }
            } else {
                BeanUtils.copyProperties((Object)backupBatch, (Object)restoreHistoy);
                this.updateRestoreHistoryValues(backupBatch, device, totalSizeRestore, destFolder, restoredInDiffPath, restoreHistoy, destDevice);
                this.utilServiceObj.saveRestoreHistory(cloudId, restoreHistoy);
            }
        }
        catch (Exception e) {
            logger.trace("Error failed to saveRestoreHistory..." + e);
            logger.error("Error failed to saveRestoreHistory ..." + e.getMessage());
        }
    }

    private void sendEmailForRestore(int cloudId, Device device, String cloudName, NotifierEmailBodyElement notifierEmailBodyElement, User user1, Device destDevice, String actionBy) {
        try {
            String userName = user1.getUserName();
            logger.debug(device.getUserName() + "...start mail restore... " + userName);
            String emailId = user1.getEmailId();
            String actionOn = device.getUserName();
            notifierEmailBodyElement.setRestoreDeviceName(device.getDeviceName());
            notifierEmailBodyElement.setNotifyAllAdmins(true);
            notifierEmailBodyElement.setUserName(userName);
            notifierEmailBodyElement.setCloudId(cloudId);
            notifierEmailBodyElement.setCloudName(cloudName);
            notifierEmailBodyElement.setDeviceName(destDevice.getDeviceName());
            if (!device.getUserName().equalsIgnoreCase(userName)) {
                User user = this.utilServiceObj.getUserInfoByName(cloudId, device.getUserName());
                emailId = user.getEmailId();
            }
            notifierEmailBodyElement.setUserName(userName);
            this.sendEmail("restore-initiated", actionOn, actionBy, emailId, notifierEmailBodyElement, device.getDeviceUUID());
            logger.debug(userName + "...end mail restore... " + emailId);
        }
        catch (Exception e) {
            logger.error("error trying to send mail .." + e.getMessage());
        }
    }

    private List<RestoreBackUpImage> getFilteredBackupImageListByGrouping(List<RestoreBackUpImage> backUpImages) {
        logger.debug("Inside grouping backup images");
        ArrayList<RestoreBackUpImage> filteredBackUpImages = new ArrayList<RestoreBackUpImage>();
        backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(RestoreBackUpImage::getFileName)).entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(RestoreBackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        Map<String, Map<String, List<RestoreBackUpImage>>> map = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(RestoreBackUpImage::getDevicePath, Collectors.groupingBy(RestoreBackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<RestoreBackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(RestoreBackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    private void updateFilesForRestore(RestoreEvents restoreEvents, int cloudId, Device device, String cloudName, String userName, List<RestoreBackUpImage> backupImages, long restoreDateBefore, Set<String> folderSet) {
        List<RestoreBackUpImage> overallFiles = new ArrayList<RestoreBackUpImage>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(backupImages)) {
            List<Object> backupImagesFolderFile = new ArrayList();
            for (RestoreBackUpImage backupImagedata : backupImages) {
                logger.debug("....files1  ..." + backupImagedata.getId());
                if (StringUtils.isNotEmpty((String)backupImagedata.getDevicePath())) {
                    logger.debug("....files2  ..." + backupImagedata.getDevicePath());
                    backupImagesFolderFile = this.downloadService.getBackupFilesForBasePathLatest(cloudId, cloudName, userName, device, backupImagedata.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImagedata.getFileName());
                    logger.debug("....files2 completed ..." + backupImagedata.getDevicePath());
                } else {
                    logger.debug(userName + "...." + device.getDeviceUUID() + "....files3  ..." + backupImagedata.getDevicePath() + "...." + backupImagedata.getFileName());
                    backupImagesFolderFile = this.downloadService.getBackupFilesForBasePathLatest(cloudId, cloudName, userName, device, backupImagedata.getFileName());
                    logger.debug("....files3 completed  ..." + backupImagedata.getDevicePath() + "...." + backupImagedata.getFileName());
                }
                logger.debug("....files for ..." + backupImagedata.getFileName() + "...." + backupImagesFolderFile.size());
                overallFiles.addAll(backupImagesFolderFile);
            }
        }
        logger.debug(restoreEvents.isRestoreAllVersions() + "....oveall files before.. " + overallFiles.size());
        overallFiles = this.getFilteredBackupImageListByGrouping(overallFiles);
        logger.debug(restoreDateBefore + "....oveall files.. " + overallFiles.size());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(overallFiles)) {
            for (RestoreBackUpImage backupImg : overallFiles) {
                if (backupImg.isFolder() || "DELETED".equalsIgnoreCase(backupImg.getStatus())) continue;
                long serverModifiedTime = backupImg.getLastServerModifiedTime();
                boolean isOutlook = device.getOsType().equalsIgnoreCase(Device.TYPE.OUTLOOK.toString());
                if (isOutlook && backupImg.getSentDate() != null) {
                    serverModifiedTime = backupImg.getSentDate().getTime();
                    Date date = new Date(serverModifiedTime);
                    SimpleDateFormat df2 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    String dateText = df2.format(date);
                    logger.debug("....outlook sent date ...." + dateText);
                }
                if (restoreDateBefore > 0L && serverModifiedTime > restoreDateBefore) continue;
                if (restoreEvents.isRestoreAllVersions()) {
                    this.storeRestoreElementsForAllVersions(restoreEvents, cloudId, device, backupImg);
                    continue;
                }
                OfficeRestoreFileInfo officeRestoreFileInfo = new OfficeRestoreFileInfo();
                officeRestoreFileInfo.setBackupId(backupImg.getId().toString());
                officeRestoreFileInfo.setRestoreEventId(restoreEvents.getId().toString());
                officeRestoreFileInfo.setSize(backupImg.getSize() * 1024L);
                officeRestoreFileInfo.setOdItemId(backupImg.getOdItemId());
                officeRestoreFileInfo.setFilePath(backupImg.getDevicePath());
                officeRestoreFileInfo.setDeviceUUID(backupImg.getDeviceUUID());
                folderSet.add(backupImg.getDevicePath());
                this.utilServiceObj.saveOfficeRestoreFileInfo(cloudId, officeRestoreFileInfo);
            }
        }
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private synchronized RestoreEvents getRestoreEventsFromOneDriveServer() {
        int cloudId = 1;
        logger.debug("... inside getRestoreEventsFromOneDriveServer... ");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(batchList) && org.apache.commons.collections.CollectionUtils.isEmpty(batchList = this.getBatchFromList(cloudId))) {
            try {
                logger.debug("...batch Completed ... ");
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
        RestoreEvents restoreEvents = batchList.get(0);
        if (restoreEvents != null) {
            if (this.batchUnderProcess.contains(restoreEvents.getId().toString())) {
                batchList.remove(restoreEvents);
                logger.debug(batchList.size() + "..only one 5...");
                if (batchList.size() == 0) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return this.getRestoreEventsFromOneDriveServer();
            }
            batchList.remove(restoreEvents);
            this.batchUnderProcess.add(restoreEvents.getId().toString());
        }
        logger.debug("...after bkp batch list size....." + batchList.size());
        return restoreEvents;
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            OfficeRestoreService.this.callRestoreFiles(cloud, executor, pool);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }

    private List<RestoreEvents> getBatchFromList(int cloudId) {
        List<OfficeBackupPolicy> list = this.utilServiceObj.getPolicyForBluKrypt(cloudId);
        for (OfficeBackupPolicy oneDriveBackupPolicy : list) {
            List<RestoreEvents> batchListVal = this.uploadService.getRestoreEventsList(cloudId, oneDriveBackupPolicy.getPolicyName());
            BaseController.printLogs(oneDriveBackupPolicy.getPolicyName() + "...mailrestorebatchsize.." + batchListVal.size(), PCHelperConstant.isBrevityLogging());
            if (batchList == null) {
                batchList = new ArrayList<RestoreEvents>();
            }
            for (RestoreEvents restoreEvents : batchListVal) {
                RestoreEvents newevents = new RestoreEvents();
                BeanUtils.copyProperties((Object)restoreEvents, (Object)newevents);
                newevents.setOfficePolicyName(oneDriveBackupPolicy.getPolicyName());
                newevents.setOfficeBackupPolicy(oneDriveBackupPolicy);
                batchList.add(newevents);
            }
        }
        return batchList;
    }

    private void updateBatchAndOverview(int cloudId, ObjectId backupBatchId, String status, String deviceUUID, int errorCode) {
        this.utilServiceObj.updateBackupBatch(cloudId, backupBatchId, status, errorCode);
        Device device = this.utilServiceObj.getDeviceForUUID(cloudId, deviceUUID);
        BackupBatch backupBatch = this.utilServiceObj.getBackupBatchById(cloudId, backupBatchId.toString());
        this.updateBackupOverview(cloudId, "RESTORE", deviceUUID, device, backupBatch);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    private List<OfficeRestoreFileInfo> getOfficeRestoreFileInfoFromListForBatchId(int cloudId, String batchId) {
        List<OfficeRestoreFileInfo> list = this.utilServiceObj.getOfficeRestoreFileInfoFromListForBatchId(cloudId, batchId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return new ArrayList<OfficeRestoreFileInfo>();
        }
        return list;
    }

    public void updateBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, Long size) {
        logger.debug("calling backup Batch ..." + backupBatchOdb.getNoOfFiles());
        try {
            int cloudId = cloud.getCloudId();
            logger.debug(" ************ ");
            this.utilServiceObj.updateBackupBatch(cloudId, backupBatchOdb.getId().toString(), uploadedFiles, size);
            this.utilServiceObj.updateUplodedFilesInBackupOverView(cloudId, backupBatchOdb.getDeviceUUID(), uploadedFiles, size, backupBatchOdb.getTotalSizeToUpload());
            logger.debug("[backupBatch][" + backupBatchOdb.getUserName() + "][" + backupBatchOdb.getDeviceUUID() + "][" + backupBatchOdb.getId() + "][" + backupBatchOdb.getStatus() + "][" + backupBatchOdb.getBatchStartTimestamp() + "][" + backupBatchOdb.getBatchEndTimestamp() + "]");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling backup Batch ...");
    }

    private void updateBackupOverview(int cloudId, String jobType, String deviceUUID, Device device, BackupBatch backupBatch) {
        logger.debug(".... job type..... " + jobType);
    }

    long getActualUploadedFiles(String uploadedFiles) {
        if (StringUtils.isEmpty((String)uploadedFiles)) {
            uploadedFiles = "0/0";
        }
        String[] parts = uploadedFiles.split("/");
        return Long.parseLong(parts[0]);
    }

    public void startBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles) {
        logger.debug("calling start restore backup Batch ...");
        try {
            int cloudId = cloud.getCloudId();
            String jobType = "RESTORE";
            String totalNoOfFiles = "" + backupBatchOdb.getNoOfFiles();
            String deviceUUID = backupBatchOdb.getDeviceUUID();
            Device device = this.utilServiceObj.getDeviceForUUID(cloudId, deviceUUID);
            BackupBatch backupBatch = new BackupBatch();
            backupBatch.setId(backupBatchOdb.getId());
            backupBatch.setUserName(backupBatchOdb.getUserName());
            backupBatch.setDeviceName(backupBatchOdb.getDeviceName());
            backupBatch.setDeviceUUID(deviceUUID);
            backupBatch.setStatus(STARTED);
            backupBatch.setJobType(jobType);
            backupBatch.setBatchStartTimestamp(System.currentTimeMillis());
            backupBatch.setTotalNoOfFiles(backupBatchOdb.getTotalNoOfFiles());
            backupBatch.setUploadedFiles(uploadedFiles + "/" + totalNoOfFiles);
            backupBatch.setDeviceName(device.getDeviceName());
            backupBatch.setBatchEndTimestamp(System.currentTimeMillis());
            backupBatch.setNoOfFiles(backupBatchOdb.getNoOfFiles());
            backupBatch.setTotalSizeToUpload(backupBatchOdb.getTotalSizeToUpload());
            this.utilServiceObj.saveBackupBatch(cloudId, backupBatch);
            logger.debug("[backupBatch][" + backupBatch.getUserName() + "][" + backupBatch.getDeviceUUID() + "][" + backupBatch.getId() + "][" + backupBatch.getStatus() + "][" + backupBatch.getBatchStartTimestamp() + "][" + backupBatch.getBatchEndTimestamp() + "]");
            logger.debug(" before updateoverview..");
            this.updateBackupOverview(cloudId, jobType, deviceUUID, device, backupBatch);
            this.utilServiceObj.deleteEventHubForDeviceUUID(cloudId, deviceUUID, PCHelperConstant.EVENTHUB_ACTION_STATUS.RESTORE_CREATED.toString());
            logger.debug(" after updateoverview..");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling method backup Batch ...");
    }

    private void sendEmail(String action, String actionOn, String actionBy, String emailId, NotifierEmailBodyElement bodyElement, String deviceUUID) {
        try {
            logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email12 completion...." + bodyElement.getTotalBackupSize());
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl().trim() + "/paracloud/cloud/" + bodyElement.getCloudName() + "/mail";
            logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email url with dev details s...." + url);
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("isInternalCall", "true");
            httpPost.setHeader("bkupsDone", String.valueOf(bodyElement.getNoOfFilesBackedUp()));
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)actionBy);
            emailDetails.put("action", (Object)action);
            emailDetails.put("actionOn", (Object)actionOn);
            emailDetails.put("toUser", true);
            emailDetails.put("userName", (Object)bodyElement.getUserName());
            emailDetails.put("deviceUUID", (Object)deviceUUID);
            emailDetails.put("bodyData", (Object)bodyElement.getRestoreDeviceName());
            emailDetails.put("fileName", (Object)bodyElement.getRestoreFolder());
            emailDetails.put("customMailMessage", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
            emailDetails.put("deviceName", (Object)String.valueOf(bodyElement.getDeviceName()));
            emailDetails.put("totalStorageUtilized", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
            emailDetails.put("bkupsDone", (Object)String.valueOf(bodyElement.getNoOfFilesBackedUp()));
            emailDetails.put("toAdmins", true);
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            logger.debug(actionBy + "..Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    static {
        logger = LoggerFactory.getLogger(OfficeRestoreService.class);
        batchList = null;
    }

    class NotifierEmailBodyElement {
        private int cloudId;
        private String cloudName;
        private String userName;
        private String deviceName;
        private String restoreDeviceName;
        private String restoreFolder;
        private String noOfFilesBackedUp;
        private String totalBackupSize;
        private boolean notifyAllAdmins;

        NotifierEmailBodyElement() {
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public String getRestoreDeviceName() {
            return this.restoreDeviceName;
        }

        public void setRestoreDeviceName(String restoreDeviceName) {
            this.restoreDeviceName = restoreDeviceName;
        }

        public String getRestoreFolder() {
            return this.restoreFolder;
        }

        public void setRestoreFolder(String restoreFolder) {
            this.restoreFolder = restoreFolder;
        }

        public String getTotalBackupSize() {
            return this.totalBackupSize;
        }

        public void setTotalBackupSize(String totalBackupSize) {
            this.totalBackupSize = totalBackupSize;
        }

        public String getNoOfFilesBackedUp() {
            return this.noOfFilesBackedUp;
        }

        public void setNoOfFilesBackedUp(String noOfFilesBackedUp) {
            this.noOfFilesBackedUp = noOfFilesBackedUp;
        }

        public boolean isNotifyAllAdmins() {
            return this.notifyAllAdmins;
        }

        public void setNotifyAllAdmins(boolean notifyAllAdmins) {
            this.notifyAllAdmins = notifyAllAdmins;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public int getCloudId() {
            return this.cloudId;
        }

        public void setCloudId(int cloudId) {
            this.cloudId = cloudId;
        }

        public String getCloudName() {
            return this.cloudName;
        }

        public void setCloudName(String cloudName) {
            this.cloudName = cloudName;
        }
    }
}

